/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.teiidddl;

import java.io.File;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.teiid.core.designer.util.FileUtils;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.transformation.ui.UiConstants;
import org.teiid.designer.transformation.ui.teiidddl.TeiidDdlExporter;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.wizard.AbstractWizardPage;

public class ExportTeiidDdlOutputPage
extends AbstractWizardPage
implements UiConstants {
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix(ExportTeiidDdlOutputPage.class);
    private static final String TITLE = "Export Model as Teiid DDL";
    private static final String FILE_GROUP = "Output File Definition";
    private static final String FILE_LABEL = "Name";
    private static final String FILE_BUTTON = "...";
    private static final String FILE_DIALOG_TITLE = "Select DDL File for Export";
    private static final String DDL_EXTENSION = String.valueOf(FileUtils.Constants.FILE_EXTENSION_SEPARATOR) + "ddl";
    private Combo fileCombo;
    private final TeiidDdlExporter exporter;

    private static String getString(String id) {
        return Util.getString(String.valueOf(I18N_PREFIX) + id, new Object[0]);
    }

    public ExportTeiidDdlOutputPage(TeiidDdlExporter exporter) {
        super(ExportTeiidDdlOutputPage.class.getSimpleName(), TITLE);
        this.exporter = exporter;
    }

    public void createControl(Composite parent) {
        Composite mainPanel = new Composite(parent, 0);
        mainPanel.setLayout((Layout)new GridLayout(2, false));
        mainPanel.setLayoutData((Object)new GridData(272));
        mainPanel.setSize(mainPanel.computeSize(-1, -1));
        this.setControl((Control)mainPanel);
        this.setMessage("Select DDL File for export");
    }

    private void createExportToSection(Composite pg, IDialogSettings settings) {
        Group exportToGroup = WidgetFactory.createGroup((Composite)pg, (String)FILE_GROUP, (int)768, (int)1, (int)1);
        Composite buttonComposite = new Composite((Composite)exportToGroup, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)buttonComposite);
        GridLayoutFactory.fillDefaults().numColumns(3).margins(10, 10).applyTo(buttonComposite);
        final Composite exportToFilePanel = new Composite((Composite)exportToGroup, 0);
        GridDataFactory.fillDefaults().grab(true, false).hint(-1, 50).applyTo((Control)exportToFilePanel);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(exportToFilePanel);
        Button clipboardButton = WidgetFactory.createButton((Composite)buttonComposite, (String)TeiidDdlExporter.CLIPBOARD_TYPE.getLabel(), (int)576, (int)1, (int)16);
        clipboardButton.setToolTipText(ExportTeiidDdlOutputPage.getString("ExportTeiidDdlWizard_clipboardTooltip"));
        clipboardButton.setSelection(true);
        clipboardButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExportTeiidDdlOutputPage.this.exporter.setExportType(TeiidDdlExporter.CLIPBOARD_TYPE);
                ExportTeiidDdlOutputPage.this.validatePage();
                exportToFilePanel.setVisible(false);
            }
        });
        Button fileButton = WidgetFactory.createButton((Composite)buttonComposite, (String)TeiidDdlExporter.FILE_TYPE.getLabel(), (int)576, (int)1, (int)16);
        fileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExportTeiidDdlOutputPage.this.exporter.setExportType(TeiidDdlExporter.FILE_TYPE);
                ExportTeiidDdlOutputPage.this.validatePage();
                exportToFilePanel.setVisible(true);
            }
        });
        WidgetFactory.createLabel((Composite)exportToFilePanel, (String)FILE_LABEL);
        this.fileCombo = WidgetFactory.createCombo((Composite)exportToFilePanel, (int)0, (int)768, (Object[])settings.getArray(FILE_LABEL));
        this.fileCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                ExportTeiidDdlOutputPage.this.fileModified();
            }
        });
        WidgetFactory.createButton((Composite)exportToFilePanel, (String)FILE_BUTTON).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ExportTeiidDdlOutputPage.this.fileButtonSelected();
            }
        });
        exportToFilePanel.setVisible(false);
    }

    private void fileButtonSelected() {
        FileDialog dlg = new FileDialog(this.getShell(), 8196);
        dlg.setFilterExtensions(new String[]{"*.ddl", "*.sql", "*.*"});
        dlg.setText(FILE_DIALOG_TITLE);
        String file = dlg.open();
        if (file != null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(file);
            if (file.indexOf(46) < 0) {
                buffer.append(DDL_EXTENSION);
            }
            this.fileCombo.setText(buffer.toString());
            this.exporter.setDdlFile(new File(file));
        }
        this.validatePage();
    }

    private void fileModified() {
        String file = this.fileCombo.getText();
        if (file != null && file.length() > 0) {
            char lastChr = file.charAt(file.length() - 1);
            if (file.indexOf(FileUtils.Constants.FILE_EXTENSION_SEPARATOR) < 0 && lastChr != ':' && lastChr != '\\' && lastChr != '/') {
                file = String.valueOf(file) + DDL_EXTENSION;
            }
            this.exporter.setDdlFile(new File(file));
        }
        this.validatePage();
    }

    public boolean canFlipToNextPage() {
        return true;
    }

    private boolean validatePage() {
        this.exporter.validate();
        return true;
    }
}

