/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.teiidddl;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.core.designer.util.FileUtils;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.transformation.ui.UiConstants;
import org.teiid.designer.transformation.ui.UiPlugin;
import org.teiid.designer.transformation.ui.teiidddl.ExportTeiidDdlModelSelectionPage;
import org.teiid.designer.transformation.ui.teiidddl.ExportTeiidShowDdlPage;
import org.teiid.designer.transformation.ui.teiidddl.TeiidDdlExporter;
import org.teiid.designer.ui.common.InternalUiConstants;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.common.wizard.AbstractWizard;
import org.teiid.designer.ui.viewsupport.ModelIdentifier;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class ExportTeiidDdlWizard
extends AbstractWizard
implements FileUtils.Constants,
IExportWizard,
InternalUiConstants.Widgets,
CoreStringUtil.Constants,
UiConstants {
    private static final String TITLE = ExportTeiidDdlWizard.getString("ExportTeiidDdlWizard_title");
    private static final ImageDescriptor IMAGE = UiPlugin.getDefault().getImageDescriptor("icons/full/ctool16/exportddl_wiz.gif");
    private static final String EXPORT_ERROR_MESSAGE = ExportTeiidDdlWizard.getString("ExportTeiidDdlWizard_exportErrorMessage");
    private TeiidDdlExporter exporter;
    private IStructuredSelection selection;
    private WizardPage pg;
    private ExportTeiidDdlModelSelectionPage modelSelectionPage;
    private ExportTeiidShowDdlPage ddlSummaryPage;
    private boolean invalidSelection;

    private static String getString(String id) {
        return UiConstants.Util.getString(id, new Object[0]);
    }

    public ExportTeiidDdlWizard() {
        super((AbstractUIPlugin)UiPlugin.getDefault(), TITLE, IMAGE);
    }

    public boolean finish() {
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.invalidSelection = false;
        ModelResource selectedModelResource = null;
        if (!SelectionUtilities.isSingleSelection((ISelection)selection)) {
            this.invalidSelection = true;
        } else if (!SelectionUtilities.isAllIResourceObjects((ISelection)selection)) {
            this.invalidSelection = true;
        } else {
            Object obj = SelectionUtilities.getSelectedObject((ISelection)selection);
            if (obj instanceof IResource) {
                IResource iRes = (IResource)obj;
                if (!ModelIdentifier.isRelationalSourceModel((IResource)iRes) && !ModelIdentifier.isRelationalViewModel((IResource)iRes)) {
                    this.invalidSelection = true;
                } else {
                    selectedModelResource = ModelUtilities.getModelResource((Object)obj);
                }
            }
        }
        this.selection = selection;
        this.exporter = new TeiidDdlExporter();
        this.exporter.setModelResource(selectedModelResource);
        this.modelSelectionPage = new ExportTeiidDdlModelSelectionPage(this.exporter);
        this.modelSelectionPage.setPageComplete(false);
        this.addPage((IWizardPage)this.modelSelectionPage);
        this.ddlSummaryPage = new ExportTeiidShowDdlPage(this.exporter);
        this.ddlSummaryPage.setPageComplete(false);
        this.addPage((IWizardPage)this.ddlSummaryPage);
    }

    static /* synthetic */ String access$0(String string) {
        return ExportTeiidDdlWizard.getString(string);
    }

    private static enum ExportChoice {
        CLIPBOARD(ExportTeiidDdlWizard.access$0("ExportTeiidDdlWizard_clipboardChoiceLabel")),
        FILE(ExportTeiidDdlWizard.access$0("ExportTeiidDdlWizard_fileChoiceLabel"));

        private final String label;

        private ExportChoice(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

