/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.teiidddl;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelEditor;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.util.ModelContents;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.transformation.ddl.TeiidModelToDdlGenerator;
import org.teiid.designer.transformation.ui.UiConstants;
import org.teiid.designer.transformation.ui.UiPlugin;
import org.teiid.designer.ui.common.util.WidgetUtil;

public class TeiidDdlExporter {
    public static final int WRITTEN_WITH_NO_PROBLEMS = 4001;
    public static final int UNABLE_TO_GET_EMF_RESOURCE = 4002;
    public static final int WRITE_WITH_WARNINGS = 4003;
    public static final int WRITE_WITH_ERRORS = 4004;
    public static final int WRITE_WITH_WARNINGS_AND_ERRORS = 4005;
    public static final int WRITE_WITH_NO_WARNINGS_AND_ERRORS = 4006;
    public static final int UNEXPECTED_EXCEPTION = 4007;
    public static final int XSLT_PROBLEMS = 4008;
    public static final int UNEXPECTED_IO_EXCEPTION = 4009;
    public static final int TRANSFORMER_CONFIGURATION_EXCEPTION = 4010;
    public static final int ERROR_COMPUTING_RESOURCES_TO_BE_EXPORTED = 4011;
    public static boolean DEFAULT_USE_NAME_IN_SOURCE = true;
    public static boolean DEFAULT_USE_NATIVE_TYPE = false;
    public static ExportChoice CLIPBOARD_TYPE = ExportChoice.CLIPBOARD;
    public static ExportChoice FILE_TYPE = ExportChoice.FILE;
    private boolean nameInSourceUsed;
    private boolean nativeTypeUsed;
    private ModelResource modelResource;
    private File ddlFile;
    private ExportChoice exportType = ExportChoice.CLIPBOARD;
    private static Clipboard CLIPBOARD;
    private IStatus writeStatus;
    private IStatus OK_STATUS = new Status(0, "org.teiid.designer.transformation.ui", "Click Finish to export");

    public TeiidDdlExporter() {
        this.nameInSourceUsed = DEFAULT_USE_NAME_IN_SOURCE;
        this.nativeTypeUsed = DEFAULT_USE_NATIVE_TYPE;
        if (CLIPBOARD == null) {
            CLIPBOARD = new Clipboard(UiPlugin.getDefault().getWorkbench().getDisplay());
        }
    }

    public boolean isNameInSourceUsed() {
        return this.nameInSourceUsed;
    }

    public void setNameInSourceUsed(boolean useNameInSource) {
        this.nameInSourceUsed = useNameInSource;
    }

    public boolean isNativeTypeUsed() {
        return this.nativeTypeUsed;
    }

    public void setNativeTypeUsed(boolean useNativeType) {
        this.nativeTypeUsed = useNativeType;
    }

    public ModelResource getModelResource() {
        return this.modelResource;
    }

    public void setModelResource(ModelResource modelResource) {
        this.modelResource = modelResource;
    }

    public File getDdlFile() {
        return this.ddlFile;
    }

    public void setDdlFile(File ddlFile) {
        this.ddlFile = ddlFile;
    }

    public ExportChoice getExportType() {
        return this.exportType;
    }

    public void setExportType(ExportChoice exportType) {
        this.exportType = exportType;
    }

    public IStatus validate() {
        if (this.modelResource == null) {
            return new Status(4, "org.teiid.designer.transformation.ui", "No model selected for export");
        }
        return this.OK_STATUS;
    }

    public String generateDdl() {
        String ddl = null;
        try {
            TeiidModelToDdlGenerator generator = new TeiidModelToDdlGenerator();
            ddl = generator.generate(this.getModelResource());
        }
        catch (ModelWorkspaceException e) {
            e.printStackTrace();
        }
        return ddl;
    }

    public IStatus write(ModelResource modelResource, OutputStream stream, IProgressMonitor monitor) {
        CoreArgCheck.isNotNull((Object)modelResource);
        CoreArgCheck.isNotNull((Object)stream);
        try {
            modelResource.getEmfResource();
            ModelEditor editor = ModelerCore.getModelEditor();
            editor.getModelName(modelResource);
            modelResource.getPath().toString();
            ModelContents.getModelContents((ModelResource)modelResource);
            return this.doWrite(modelResource, stream, (IProgressMonitor)(monitor != null ? monitor : new NullProgressMonitor()));
        }
        catch (ModelWorkspaceException modelWorkspaceException) {
            return new Status(4, "org.teiid.designer.transformation.ui", "ERROR WRITING DDL");
        }
    }

    protected IStatus doWrite(ModelResource modelResource, OutputStream stream, IProgressMonitor monitor) {
        CoreArgCheck.isNotNull((Object)modelResource);
        CoreArgCheck.isNotNull((Object)stream);
        return new Status(0, "org.teiid.designer.transformation.ui", "NOT YET IMPLEMENTED");
    }

    private void writeToStream(final OutputStream stream) throws Exception {
        new ProgressMonitorDialog(Display.getCurrent().getActiveShell()).run(false, true, new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        TeiidDdlExporter.this.writeStatus = TeiidDdlExporter.this.write(TeiidDdlExporter.this.modelResource, stream, monitor);
                    }
                    catch (Exception err) {
                        throw new InvocationTargetException(err);
                    }
                }
                finally {
                    try {
                        stream.close();
                    }
                    catch (IOException e) {
                        UiConstants.Util.log((Throwable)e);
                    }
                    monitor.done();
                }
            }
        });
        if (!this.writeStatus.isOK()) {
            UiConstants.Util.log(this.writeStatus);
            WidgetUtil.showError((String)"ERROR exporting model to file");
        }
    }

    public void exportToFile() throws Exception {
        if (this.ddlFile == null || this.ddlFile.exists() && !WidgetUtil.confirmOverwrite((File)this.ddlFile)) {
            return;
        }
        this.writeToStream(new FileOutputStream(this.ddlFile));
    }

    public void exportToClipboard() throws Exception {
        if (CLIPBOARD == null || CLIPBOARD.isDisposed()) {
            WidgetUtil.showError((String)"ERROR exporting to clipboard");
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        this.writeToStream(stream);
        CLIPBOARD.setContents(new Object[]{stream.toString()}, new Transfer[]{TextTransfer.getInstance()});
    }

    public static enum ExportChoice {
        CLIPBOARD("Clipboard"),
        FILE("To File");

        private final String label;

        private ExportChoice(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

