/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.textimport;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.metamodel.aspect.AspectManager;
import org.teiid.designer.core.metamodel.aspect.uml.UmlDiagramAspect;
import org.teiid.designer.core.metamodel.aspect.uml.UmlPackage;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.metamodels.core.ModelType;
import org.teiid.designer.transformation.ui.UiConstants;
import org.teiid.designer.ui.PluginConstants;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.common.viewsupport.StatusInfo;
import org.teiid.designer.ui.explorer.ModelExplorerContentProvider;
import org.teiid.designer.ui.explorer.ModelExplorerLabelProvider;
import org.teiid.designer.ui.viewsupport.ModelIdentifier;
import org.teiid.designer.ui.viewsupport.ModelNameUtil;
import org.teiid.designer.ui.viewsupport.ModelUtilities;
import org.teiid.designer.ui.viewsupport.ModelWorkspaceDialog;

public class VirtualModelSelectorDialog
extends ModelWorkspaceDialog
implements UiConstants {
    private Label lblVirtualModelName;
    private Text txtVirtualModelName;
    private IContainer newModelParent;
    private IPath targetVirtualFilePath;
    private ModelResource mrVirtualModel;
    private EObject selectedEObject;
    private SelectionAdapter saCreateCbxAdapter;
    private String sNewVirtualModelName;
    boolean createNewModel = false;
    private static final String FILE_EXT = ".xmi";
    private static final int MODEL_NAME_TEXT_WIDTH = (int)((double)Display.getCurrent().getBounds().width * 0.25);
    private static final String I18N_PREFIX = "VirtualModelSelectorDialog";
    private static final String SEPARATOR = ".";
    private static final String TITLE = VirtualModelSelectorDialog.getString("title");
    private static final String MODEL_CREATE_ERROR_IS_VALID = VirtualModelSelectorDialog.getString("isValid.message");
    private static String MODEL_CREATE_INSTRUCTION = VirtualModelSelectorDialog.getString("modelCreateInstruction.message");
    private static String EXISTING_MODEL_FOLDER_SELECTED = VirtualModelSelectorDialog.getString("existingModelFolderLocationSelected.message");
    private static final String VIRTUAL_LABEL = VirtualModelSelectorDialog.getString("virtualModelName.text");
    private static final String SELECTED_MODEL_NOT_VIRTUAL_MODEL = VirtualModelSelectorDialog.getString("selModelNotVirtual.message");
    private static final String SELECTED_RESOURCE_NOT_VIRTUAL_MODEL = VirtualModelSelectorDialog.getString("selResrcNotVirtual.message");

    private static String getString(String id) {
        return Util.getString("VirtualModelSelectorDialog." + id, new Object[0]);
    }

    public VirtualModelSelectorDialog(Shell parent) {
        this(parent, (ILabelProvider)new ModelExplorerLabelProvider(), (ITreeContentProvider)new ModelExplorerContentProvider());
    }

    public VirtualModelSelectorDialog(Shell parent, ILabelProvider labelProvider, ITreeContentProvider contentProvider) {
        super(parent, TITLE, labelProvider, contentProvider);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createModelCreationComposite(composite);
        return composite;
    }

    private Composite createModelCreationComposite(Composite parent) {
        Composite nameComposite = new Composite(parent, 0);
        GridLayout nameCompositeLayout = new GridLayout();
        nameComposite.setLayout((Layout)nameCompositeLayout);
        nameCompositeLayout.numColumns = 3;
        nameCompositeLayout.marginWidth = 0;
        GridData nameCompositeGridData = new GridData(768);
        nameCompositeGridData.horizontalIndent = 20;
        nameComposite.setLayoutData((Object)nameCompositeGridData);
        this.lblVirtualModelName = new Label(nameComposite, 0);
        this.lblVirtualModelName.setText(VIRTUAL_LABEL);
        this.lblVirtualModelName.getAlignment();
        this.txtVirtualModelName = WidgetFactory.createTextField((Composite)nameComposite, (int)256);
        GridData modelNameTextGridData = new GridData();
        modelNameTextGridData.widthHint = MODEL_NAME_TEXT_WIDTH;
        this.txtVirtualModelName.setLayoutData((Object)modelNameTextGridData);
        this.txtVirtualModelName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                VirtualModelSelectorDialog.this.handleSetVirtualModelName();
            }
        });
        this.handleSetVirtualModelName();
        this.setCreateControlsEnabled(false);
        return nameComposite;
    }

    void createVirtualModel() {
        this.mrVirtualModel = this.constructVirtualModel((IResource)this.newModelParent, this.sNewVirtualModelName);
        try {
            if (this.mrVirtualModel != null) {
                this.mrVirtualModel.save(null, false);
            }
        }
        catch (ModelWorkspaceException mwe) {
            Util.log((Throwable)mwe);
        }
    }

    public Object[] getResult() {
        if (this.mrVirtualModel != null) {
            return new Object[]{this.mrVirtualModel};
        }
        if (this.selectedEObject != null) {
            return new Object[]{this.selectedEObject};
        }
        return super.getResult();
    }

    private SelectionAdapter getOKSelectionListener() {
        if (this.saCreateCbxAdapter == null) {
            this.saCreateCbxAdapter = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    if (VirtualModelSelectorDialog.this.createNewModel) {
                        VirtualModelSelectorDialog.this.createVirtualModel();
                    }
                }
            };
        }
        return this.saCreateCbxAdapter;
    }

    private void updateDialogMessage(String sMessage, boolean bIsError) {
        int iStatusCode = 0;
        if (bIsError) {
            iStatusCode = 4;
        }
        StatusInfo status = new StatusInfo("org.teiid.designer.transformation.ui", iStatusCode, sMessage);
        this.updateStatus((IStatus)status);
    }

    protected void registerControls() {
        this.getTreeViewer().addSelectionChangedListener((ISelectionChangedListener)this);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        super.selectionChanged(event);
        this.newModelParent = null;
        IStructuredSelection sel = (IStructuredSelection)this.getTreeViewer().getSelection();
        Object oSelection = sel.getFirstElement();
        this.createNewModel = true;
        if (this.isVirtualModelResource(oSelection)) {
            this.newModelParent = null;
            this.selectedEObject = null;
            this.createNewModel = false;
            String instruction = Util.getString("VirtualModelSelectorDialog.useExistingModelInstruction.message", (Object)((IResource)oSelection).getName());
            this.updateDialogMessage(instruction, false);
            this.setCreateControlsEnabled(false);
            this.enableOKButton();
        } else if (this.isModelResource(oSelection)) {
            this.newModelParent = null;
            this.selectedEObject = null;
            this.setCreateControlsEnabled(false);
            this.disableOKButton();
            this.updateDialogMessage(SELECTED_MODEL_NOT_VIRTUAL_MODEL, true);
        } else if (this.isContainer(oSelection)) {
            this.newModelParent = (IContainer)oSelection;
            this.selectedEObject = null;
            this.setCreateControlsEnabled(true);
            this.handleSetVirtualModelName();
        } else if (this.isPackageInVirtualModel(oSelection)) {
            this.selectedEObject = (EObject)oSelection;
            this.newModelParent = null;
            this.createNewModel = false;
            this.setCreateControlsEnabled(false);
            this.enableOKButton();
            this.updateDialogMessage(EXISTING_MODEL_FOLDER_SELECTED, false);
        } else if (oSelection instanceof IResource) {
            this.newModelParent = null;
            this.selectedEObject = null;
            this.setCreateControlsEnabled(false);
            this.disableOKButton();
            this.updateDialogMessage(SELECTED_RESOURCE_NOT_VIRTUAL_MODEL, true);
        }
    }

    void handleSetVirtualModelName() {
        String nameText = this.txtVirtualModelName.getText();
        if (this.isValidVirtualModelName(nameText)) {
            this.sNewVirtualModelName = nameText;
            this.enableOKButton();
            String message = this.getVirtualModelNameStatus(nameText);
            this.updateDialogMessage(message, false);
        } else {
            this.disableOKButton();
            if (nameText.trim().length() == 0) {
                if (this.newModelParent != null) {
                    MODEL_CREATE_INSTRUCTION = Util.getString("VirtualModelSelectorDialog.modelCreateInstruction.message", (Object)this.newModelParent.getName());
                    this.updateDialogMessage(MODEL_CREATE_INSTRUCTION, true);
                }
            } else {
                String message = this.getVirtualModelNameStatus(nameText);
                this.updateDialogMessage(message, true);
            }
        }
    }

    public ModelResource constructVirtualModel(IResource targetRes, String sModelName) {
        String sFileName = this.getFileName(sModelName);
        IPath relativeModelPath = targetRes.getProjectRelativePath().append(sFileName);
        IFile modelFile = targetRes.getProject().getFile(relativeModelPath);
        ModelResource resrc = ModelerCore.create((IFile)modelFile);
        try {
            resrc.getModelAnnotation().setPrimaryMetamodelUri("http://www.metamatrix.com/metamodels/Relational");
            resrc.getModelAnnotation().setModelType(ModelType.VIRTUAL_LITERAL);
        }
        catch (ModelWorkspaceException mwe) {
            mwe.printStackTrace();
        }
        return resrc;
    }

    private String getVirtualModelNameStatus(String sModelName) {
        IStatus status = ModelNameUtil.validate((String)sModelName, (String)FILE_EXT, (IContainer)this.newModelParent, (int)13);
        if (status.getSeverity() == 4) {
            return String.valueOf(ModelNameUtil.MESSAGES.INVALID_MODEL_NAME) + status.getMessage();
        }
        return MODEL_CREATE_ERROR_IS_VALID;
    }

    private boolean isValidVirtualModelName(String sModelName) {
        IStatus status = ModelNameUtil.validate((String)sModelName, (String)FILE_EXT, (IContainer)this.newModelParent, (int)13);
        return status.getSeverity() != 4;
    }

    private void setCreateControlsEnabled(boolean b) {
        this.txtVirtualModelName.setEnabled(b);
        this.lblVirtualModelName.setEnabled(b);
    }

    private void disableOKButton() {
        if (this.getOkButton() != null) {
            this.getOkButton().removeSelectionListener((SelectionListener)this.getOKSelectionListener());
            this.getOkButton().setEnabled(false);
        }
    }

    private void enableOKButton() {
        if (this.getOkButton() != null) {
            this.getOkButton().addSelectionListener((SelectionListener)this.getOKSelectionListener());
            this.getOkButton().setEnabled(true);
        }
    }

    private boolean isVirtualModelResource(Object oSelection) {
        IResource resource;
        boolean bResult = false;
        if (oSelection instanceof IResource && ModelUtilities.isModelFile((IResource)(resource = (IResource)oSelection))) {
            ModelResource mr = null;
            try {
                mr = ModelUtil.getModelResource((IFile)((IFile)resource), (boolean)true);
            }
            catch (ModelWorkspaceException theException) {
                ModelerCore.Util.log(4, (Throwable)theException, theException.getMessage());
                WidgetUtil.showError((Throwable)theException);
            }
            if (ModelIdentifier.isVirtualModelType((ModelResource)mr)) {
                try {
                    if (mr.getPrimaryMetamodelDescriptor() != null && mr.getPrimaryMetamodelDescriptor().getNamespaceURI().equals("http://www.metamatrix.com/metamodels/Relational")) {
                        bResult = true;
                    }
                }
                catch (ModelWorkspaceException mwe) {
                    ModelerCore.Util.log(4, (Throwable)mwe, mwe.getMessage());
                    WidgetUtil.showError((Throwable)mwe);
                }
            }
        }
        return bResult;
    }

    private boolean isModelResource(Object oSelection) {
        boolean bResult = false;
        if (oSelection instanceof IResource) {
            try {
                ModelResource mr;
                IResource resource = (IResource)oSelection;
                if (ModelUtilities.isModelFile((IResource)resource) && (mr = ModelUtil.getModelResource((IFile)((IFile)resource), (boolean)true)).getPrimaryMetamodelDescriptor() != null) {
                    bResult = true;
                }
            }
            catch (ModelWorkspaceException mwe) {
                ModelerCore.Util.log(4, (Throwable)mwe, mwe.getMessage());
            }
        }
        return bResult;
    }

    private boolean isContainer(Object oSelection) {
        return oSelection instanceof IContainer || oSelection instanceof IFolder;
    }

    private boolean isPackageInVirtualModel(Object oSelection) {
        UmlDiagramAspect mmAspect;
        return oSelection instanceof EObject && (mmAspect = AspectManager.getUmlDiagramAspect((EObject)((EObject)oSelection))) != null && mmAspect instanceof UmlPackage;
    }

    protected TreeViewer createTreeViewer(Composite parent) {
        TreeViewer result = super.createTreeViewer(parent);
        result.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                boolean result = true;
                if (element instanceof IProject) {
                    IProject project = (IProject)element;
                    if (!project.isOpen()) {
                        result = false;
                    } else {
                        try {
                            if (!project.hasNature("org.teiid.designer.core.modelNature")) {
                                result = false;
                            } else {
                                String name = project.getName();
                                if (name != null && PluginConstants.HIDDEN_PROJECTS.contains(name)) {
                                    return false;
                                }
                            }
                        }
                        catch (CoreException theException) {
                            ModelerCore.Util.log((Throwable)theException);
                            result = false;
                        }
                    }
                }
                return result;
            }
        });
        result.expandToLevel(2);
        return result;
    }

    private String getFileName(String sModelName) {
        String sResult = sModelName.trim();
        if (!sResult.endsWith(FILE_EXT)) {
            sResult = String.valueOf(sResult) + FILE_EXT;
        }
        return sResult;
    }

    public boolean close() {
        this.getTreeViewer().removeSelectionChangedListener((ISelectionChangedListener)this);
        return super.close();
    }
}

