/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.textimport;

public class VirtualTableRowObject {
    private String row;
    private String name;
    private String description;
    private String selectSql;
    private static char COMMA = (char)44;
    private static char DQUOTE = (char)34;
    private static char ESCAPE = (char)92;
    private boolean valid = false;

    public VirtualTableRowObject(String row) {
        this.row = row;
        this.parseRow();
    }

    public VirtualTableRowObject(String name, String description, String selectSql) {
        this.name = name;
        this.description = description;
        this.selectSql = selectSql;
        if (this.name != null && this.name.length() > 0 && this.selectSql != null && this.selectSql.length() > 0) {
            this.valid = true;
        }
    }

    private void parseRow() {
        try {
            if (this.row != null && this.row.length() > 8) {
                int nextCommaIndex = this.row.indexOf(COMMA);
                int firstdQuoteIndex = this.row.indexOf(DQUOTE);
                if (firstdQuoteIndex > nextCommaIndex) {
                    this.name = this.row.substring(0, nextCommaIndex).trim();
                    this.valid = true;
                } else {
                    String ss1 = this.row.substring(firstdQuoteIndex + 1, nextCommaIndex);
                    int dQuote2 = ss1.indexOf(DQUOTE);
                    this.name = ss1.substring(0, dQuote2).trim();
                    this.valid = true;
                }
                if (this.row.length() > nextCommaIndex) {
                    ++nextCommaIndex;
                }
                String restOfRow1 = this.row.substring(nextCommaIndex);
                nextCommaIndex = restOfRow1.indexOf(COMMA);
                firstdQuoteIndex = this.getIndexOfFirstNonExcapedDoubleQuote(restOfRow1);
                if (firstdQuoteIndex > -1 && (firstdQuoteIndex < nextCommaIndex || nextCommaIndex == -1)) {
                    int seconddQuoteIndex;
                    int sqlBegin = firstdQuoteIndex + 1;
                    String restOfRow2 = restOfRow1.substring(sqlBegin);
                    int sqlEnd = seconddQuoteIndex = this.getIndexOfFirstNonExcapedDoubleQuote(restOfRow2);
                    String restOfRow3 = restOfRow1.substring(seconddQuoteIndex + 1);
                    nextCommaIndex = restOfRow3.indexOf(COMMA);
                    this.selectSql = restOfRow2.substring(0, sqlEnd).trim();
                    this.selectSql = this.removeEscapeCharsFromSQL(this.selectSql);
                    this.description = this.parseDescription(restOfRow3.substring(nextCommaIndex + 1).trim());
                    this.valid = true;
                }
            }
        }
        catch (Exception exception) {
            this.valid = false;
        }
    }

    private int getIndexOfFirstNonExcapedDoubleQuote(String str) {
        char[] charArray;
        int index = 0;
        char[] cArray = charArray = str.toCharArray();
        int n = charArray.length;
        int n2 = 0;
        while (n2 < n) {
            char theChar = cArray[n2];
            if (index > 0 && theChar == DQUOTE && charArray[index - 1] != ESCAPE) {
                return index;
            }
            ++index;
            ++n2;
        }
        return -1;
    }

    private String removeEscapeCharsFromSQL(String str) {
        char[] charArray;
        StringBuffer sb = new StringBuffer(str.length());
        int index = 0;
        char[] cArray = charArray = str.toCharArray();
        int n = charArray.length;
        int n2 = 0;
        while (n2 < n) {
            char theChar = cArray[n2];
            if (index < charArray.length && (index == charArray.length - 1 || theChar != ESCAPE && charArray[index + 1] != DQUOTE)) {
                sb.append(theChar);
            }
            ++index;
            ++n2;
        }
        return sb.toString();
    }

    private String parseDescription(String subString) {
        StringBuffer buffer = new StringBuffer();
        boolean removedFirstDQuote = false;
        boolean addChar = false;
        int length = subString.length();
        int i = 0;
        while (i < length) {
            if (i < length - 2 && subString.charAt(i) == DQUOTE) {
                if (removedFirstDQuote) {
                    addChar = subString.charAt(i + 1) != DQUOTE;
                } else {
                    removedFirstDQuote = true;
                }
            } else {
                addChar = subString.charAt(i) != DQUOTE || i != length - 1;
            }
            if (addChar) {
                buffer.append(subString.charAt(i));
            }
            ++i;
        }
        return buffer.toString();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Table Row Object").append("\n    Name = " + this.name).append("\n    Description = " + this.description).append("\n    Select SQL = " + this.selectSql);
        return buffer.toString();
    }

    public boolean isValid() {
        return this.valid;
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public String getSelectSql() {
        return this.selectSql;
    }
}

