/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.metamodel.aspect.sql.SqlAspectHelper;
import org.teiid.designer.core.metamodel.aspect.sql.SqlColumnAspect;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.metamodels.transformation.TransformationMappingRoot;
import org.teiid.designer.transformation.ui.UiConstants;
import org.teiid.designer.transformation.ui.actions.TransformationSourceManager;
import org.teiid.designer.transformation.util.TransformationHelper;
import org.teiid.designer.ui.viewsupport.ModelObjectUtilities;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class SqlDependencyHelper {
    private EObject vGroup;
    private HashMap sourceTables = new HashMap();
    private ModelResource vResource;
    private final String STRING_STRING = "string";
    private final String EMPTY_STRING = "";
    private final char DOUBLE_QUOTE = (char)34;
    private final String NEWLINE = CoreStringUtil.Constants.LINE_FEED;
    private Collection rows = new ArrayList();
    private int maxDep = 0;
    private HashMap columnStrings = new HashMap();
    boolean includeIntermediates = true;
    private String delimeter;
    private String nullValue;
    private String nullColumnString;
    private static final boolean ADD_NULL_COLUMN = true;
    private static final boolean DO_NOT_ADD_NULL_COLUMN = false;
    public static final int SEARCHABLE = 0;
    public static final int ALL_EXCEPT_LIKE = 1;
    public static final int LIKE_ONLY = 2;
    public static final int UNSEARCHABLE = 3;
    public static final String SEARCHABLE_STRING = "SEARCHABLE";
    public static final String ALL_EXCEPT_LIKE_STRING = "ALL_EXCEPT_LIKE";
    public static final String LIKE_ONLY_STRING = "LIKE_ONLY";
    public static final String UNSEARCHABLE_STRING = "UNSEARCHABLE";
    public static final String UNKNOWN_STRING = "UNKNOWN";
    public static final String NULL_STRING = "NULL";

    public SqlDependencyHelper(EObject virtualGroup, boolean includeIntermediates, String delimeter, String nullValue) {
        CoreArgCheck.isNotNull((Object)virtualGroup, (String)"SqlDependencyHelper got NULL virtual group. Expected Non-Null");
        this.vGroup = virtualGroup;
        this.includeIntermediates = includeIntermediates;
        this.delimeter = delimeter;
        this.nullValue = nullValue;
        this.init();
    }

    public EObject getVGroup() {
        return this.vGroup;
    }

    private void init() {
        this.vResource = ModelUtilities.getModelResourceForModelObject((EObject)this.vGroup);
        this.loadSourceTables();
        this.loadDependentAttributes();
    }

    private void loadSourceTables() {
        this.findSourceTables();
    }

    private void findSourceTables() {
        EObject transformationEObject = this.getTransformation(this.vGroup);
        Iterator sourceIter = this.getSources(transformationEObject).iterator();
        EObject nextSourceEObject = null;
        while (sourceIter.hasNext()) {
            nextSourceEObject = (EObject)sourceIter.next();
            if (nextSourceEObject.eIsProxy()) {
                nextSourceEObject = this.getRealEObjectFromProxy(nextSourceEObject);
            }
            if (nextSourceEObject == null) continue;
            this.addSourceTable(nextSourceEObject);
            if (!ModelObjectUtilities.isVirtual((EObject)nextSourceEObject)) continue;
            this.addDependencies(nextSourceEObject);
        }
    }

    private EObject getRealEObjectFromProxy(EObject proxyEObj) {
        EObject eObjectResult = null;
        if (proxyEObj.eIsProxy() && proxyEObj instanceof EObjectImpl) {
            try {
                String sUUIDFrag = ((EObjectImpl)proxyEObj).eProxyURI().fragment();
                eObjectResult = (EObject)ModelerCore.getModelContainer().getEObjectFinder().find((Object)sUUIDFrag);
            }
            catch (CoreException e) {
                String message = UiConstants.Util.getString("SqlDependencyHelper.getRealEObjectFromProxyError", new Object[0]);
                UiConstants.Util.log(4, (Throwable)e, message);
            }
        }
        return eObjectResult;
    }

    private void addSourceTable(EObject sourceTable) {
        if (this.sourceTables.get(sourceTable) == null) {
            this.sourceTables.put(sourceTable, "x");
        }
    }

    private void addDependencyStringRow(String rowString) {
        this.rows.add(rowString);
    }

    private void addDependencies(EObject virtualSource) {
        ArrayList<EObject> virtualSources = new ArrayList<EObject>();
        EObject transformationEObject = this.getTransformation(virtualSource);
        if (transformationEObject != null) {
            Iterator sourceIter = this.getSources(transformationEObject).iterator();
            EObject nextSourceEObject = null;
            while (sourceIter.hasNext()) {
                nextSourceEObject = (EObject)sourceIter.next();
                if (nextSourceEObject.eIsProxy()) {
                    nextSourceEObject = this.getRealEObjectFromProxy(nextSourceEObject);
                }
                if (nextSourceEObject == null) continue;
                if (ModelObjectUtilities.isVirtual((EObject)nextSourceEObject)) {
                    virtualSources.add(nextSourceEObject);
                }
                this.addSourceTable(nextSourceEObject);
            }
        }
        if (!virtualSources.isEmpty()) {
            Iterator vIter = virtualSources.iterator();
            while (vIter.hasNext()) {
                this.addDependencies((EObject)vIter.next());
            }
        }
    }

    private void loadDependentAttributes() {
        List columns = TransformationHelper.getTableColumns((EObject)this.vGroup);
        Iterator iter = columns.iterator();
        EObject nextColumn = null;
        while (iter.hasNext()) {
            nextColumn = (EObject)iter.next();
            this.findAttributeDependencies(nextColumn);
        }
    }

    private void findAttributeDependencies(EObject selectedColumn) {
        List targetList = Collections.EMPTY_LIST;
        if (ModelObjectUtilities.isVirtual((EObject)selectedColumn)) {
            this.getSourceDependencies(selectedColumn, selectedColumn, targetList);
        }
        if (!this.includeIntermediates) {
            this.maxDep = 1;
        }
    }

    private boolean getSourceDependencies(EObject selectedColumn, EObject selectedAttribute, List targetList) {
        boolean foundDependencies = false;
        if (ModelObjectUtilities.isVirtual((EObject)selectedAttribute)) {
            EObject virtualTarget = selectedAttribute.eContainer();
            if (!TransformationHelper.isValidSqlTransformationTarget((Object)virtualTarget) && TransformationHelper.isSqlColumnSet((Object)virtualTarget)) {
                virtualTarget = virtualTarget.eContainer();
            }
            if (virtualTarget != null) {
                TransformationMappingRoot tmr = (TransformationMappingRoot)this.getTransformation(virtualTarget);
                ArrayList attrDepList = new ArrayList(TransformationHelper.getSourceAttributesForTargetAttr((Object)selectedAttribute, (Object)tmr));
                if (attrDepList.size() == 0) {
                    this.addDependencyStringRow(this.getDependentString(selectedColumn, (EObject)null, false));
                } else {
                    EObject nextEObject2 = null;
                    for (EObject nextEObject2 : attrDepList) {
                        EObject attributeParent;
                        if (nextEObject2.equals(selectedAttribute) || this.sourceTables.get(attributeParent = nextEObject2.eContainer()) == null) continue;
                        foundDependencies = true;
                        if (targetList.contains(nextEObject2)) continue;
                        if (this.columnStrings.get(nextEObject2) == null) {
                            this.columnStrings.put(nextEObject2, this.getSourceColumnString(nextEObject2));
                        }
                        ArrayList<EObject> newTargetList = new ArrayList<EObject>(targetList);
                        newTargetList.add(nextEObject2);
                        if (ModelObjectUtilities.isVirtual((EObject)nextEObject2)) {
                            boolean foundDep = this.getSourceDependencies(selectedColumn, nextEObject2, newTargetList);
                            if (foundDep) continue;
                            if (this.includeIntermediates) {
                                this.addDependencyStringRow(this.getDependentString(selectedColumn, newTargetList, true));
                                continue;
                            }
                            this.addDependencyStringRow(this.getDependentString(selectedColumn, nextEObject2, true));
                            continue;
                        }
                        if (this.includeIntermediates) {
                            this.addDependencyStringRow(this.getDependentString(selectedColumn, newTargetList, false));
                            continue;
                        }
                        this.addDependencyStringRow(this.getDependentString(selectedColumn, nextEObject2, false));
                    }
                }
            }
        }
        return foundDependencies;
    }

    private EObject getTransformation(EObject targetVirtualGroupEObject) {
        return TransformationHelper.getTransformationMappingRoot((EObject)targetVirtualGroupEObject);
    }

    protected List getSources(EObject transformationEObject) {
        return TransformationSourceManager.getSourceEObjects(transformationEObject);
    }

    private String getDependentString(EObject virtualColumn, List columnDependencies, boolean addNullColumn) {
        StringBuffer buffer = new StringBuffer();
        int dotIndex = this.vResource.getResource().getName().indexOf(".xmi");
        buffer.append(String.valueOf(this.getOutputString(this.vResource.getResource().getName().substring(0, dotIndex))) + this.delimeter);
        buffer.append(String.valueOf(this.getOutputString(this.getName(this.vGroup))) + this.delimeter);
        SqlColumnAspect columnAspect = (SqlColumnAspect)SqlAspectHelper.getSqlAspect((EObject)virtualColumn);
        buffer.append(String.valueOf(this.getOutputString(columnAspect.getName(virtualColumn))) + this.delimeter);
        String dName = columnAspect.getDatatypeName(virtualColumn);
        String rName = columnAspect.getRuntimeType(virtualColumn);
        int length = columnAspect.getLength(virtualColumn);
        if (dName == null) {
            dName = "";
        } else if ((this.isStringType(dName) || this.isStringType(rName)) && length > 0) {
            dName = String.valueOf(dName) + "(" + length + ")";
        }
        buffer.append(String.valueOf(this.getOutputString(dName)) + this.delimeter);
        buffer.append(String.valueOf(this.getOutputString(this.getDescription(virtualColumn))) + this.delimeter);
        buffer.append(String.valueOf(this.getOutputString(this.getSearchableString(columnAspect.getSearchType(virtualColumn)))) + this.delimeter);
        buffer.append(String.valueOf(this.getOutputString(this.booleanString(columnAspect.isSelectable(virtualColumn)))) + this.delimeter);
        EObject nextColumn2 = null;
        for (EObject nextColumn2 : columnDependencies) {
            buffer.append((String)this.columnStrings.get(nextColumn2));
        }
        if (addNullColumn) {
            buffer.append(this.getNullSourceColumnString());
        }
        if (columnDependencies.size() > this.maxDep) {
            this.maxDep = columnDependencies.size();
        }
        return buffer.toString();
    }

    private String booleanString(boolean value) {
        if (value) {
            return "true";
        }
        return "false";
    }

    private String getDependentString(EObject virtualColumn, EObject lastDepColumn, boolean addNullColumn) {
        StringBuffer buffer = new StringBuffer();
        int dotIndex = this.vResource.getResource().getName().indexOf(".xmi");
        buffer.append(String.valueOf(this.getOutputString(this.vResource.getResource().getName().substring(0, dotIndex))) + this.delimeter);
        buffer.append(String.valueOf(this.getOutputString(this.getName(this.vGroup))) + this.delimeter);
        SqlColumnAspect columnAspect = (SqlColumnAspect)SqlAspectHelper.getSqlAspect((EObject)virtualColumn);
        buffer.append(String.valueOf(this.getOutputString(columnAspect.getName(virtualColumn))) + this.delimeter);
        String dName = columnAspect.getDatatypeName(virtualColumn);
        String rName = columnAspect.getRuntimeType(virtualColumn);
        int length = columnAspect.getLength(virtualColumn);
        if (dName == null) {
            dName = "";
        } else if ((this.isStringType(dName) || this.isStringType(rName)) && length > 0) {
            dName = String.valueOf(dName) + "(" + length + ")";
        }
        buffer.append(String.valueOf(this.getOutputString(dName)) + this.delimeter);
        String description = this.getDescription(virtualColumn);
        if (description == null) {
            description = "";
        }
        buffer.append(String.valueOf(this.getOutputString(description)) + this.delimeter);
        buffer.append(String.valueOf(this.getOutputString(this.getSearchableString(columnAspect.getSearchType(virtualColumn)))) + this.delimeter);
        buffer.append(String.valueOf(this.getOutputString(this.booleanString(columnAspect.isSelectable(virtualColumn)))) + this.delimeter);
        if (lastDepColumn == null) {
            buffer.append(this.getNullSourceColumnString());
        } else {
            buffer.append(this.columnStrings.get(lastDepColumn));
        }
        if (addNullColumn) {
            buffer.append(this.getNullSourceColumnString());
        }
        return buffer.toString();
    }

    private String getSourceColumnString(EObject sourceColumn) {
        StringBuffer buffer = new StringBuffer();
        SqlColumnAspect columnAspect = (SqlColumnAspect)SqlAspectHelper.getSqlAspect((EObject)sourceColumn);
        EObject table = sourceColumn.eContainer();
        buffer.append(String.valueOf(this.getOutputString(this.getPath(table))) + this.delimeter);
        buffer.append(String.valueOf(this.getOutputString(columnAspect.getName(sourceColumn))) + this.delimeter);
        String nis = columnAspect.getNameInSource(sourceColumn);
        if (nis == null) {
            nis = "";
        }
        buffer.append(String.valueOf(this.getOutputString(nis)) + this.delimeter);
        String dName = columnAspect.getDatatypeName(sourceColumn);
        String rName = columnAspect.getRuntimeType(sourceColumn);
        int length = columnAspect.getLength(sourceColumn);
        if (dName == null) {
            dName = "";
        } else if ((this.isStringType(dName) || this.isStringType(rName)) && length > 0) {
            dName = String.valueOf(dName) + "(" + length + ")";
        }
        buffer.append(String.valueOf(this.getOutputString(dName)) + this.delimeter);
        String description = this.getDescription(sourceColumn);
        if (description == null) {
            description = "";
        }
        buffer.append(String.valueOf(this.getOutputString(description)) + this.delimeter);
        buffer.append(String.valueOf(this.getOutputString(this.getSearchableString(columnAspect.getSearchType(sourceColumn)))) + this.delimeter);
        buffer.append(String.valueOf(this.getOutputString(this.booleanString(columnAspect.isSelectable(sourceColumn)))) + this.delimeter);
        return buffer.toString();
    }

    private String getNullSourceColumnString() {
        if (this.nullColumnString == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(NULL_STRING + this.delimeter);
            buffer.append(NULL_STRING + this.delimeter);
            buffer.append(NULL_STRING + this.delimeter);
            buffer.append(NULL_STRING + this.delimeter);
            buffer.append(NULL_STRING + this.delimeter);
            buffer.append(NULL_STRING + this.delimeter);
            buffer.append(NULL_STRING + this.delimeter);
            this.nullColumnString = buffer.toString();
        }
        return this.nullColumnString;
    }

    private String getName(EObject eObject) {
        return ModelerCore.getModelEditor().getName(eObject);
    }

    private boolean isStringType(String type) {
        return type != null && type.equalsIgnoreCase("string");
    }

    private String getDescription(EObject eObject) {
        String description = "";
        try {
            description = ModelerCore.getModelEditor().getDescription(eObject);
            if (description != null && description.length() > 0) {
                description = String.valueOf('\"') + description + '\"';
            }
        }
        catch (ModelerCoreException modelerCoreException) {}
        return description;
    }

    private String getPath(EObject eObject) {
        return ModelerCore.getModelEditor().getModelRelativePathIncludingModel(eObject).toString();
    }

    private String getOutputString(String val) {
        if (this.nullValue != null && (val == null || val.length() == 0 || val.equals(""))) {
            return this.nullValue;
        }
        return val;
    }

    private String getHeaderString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("VirtualModel" + this.delimeter);
        buffer.append("VirtualTableName" + this.delimeter);
        buffer.append("VirtualColumnName" + this.delimeter);
        buffer.append("DataType(LENGTH)" + this.delimeter);
        buffer.append("ColumnDescription" + this.delimeter);
        buffer.append("Searchable" + this.delimeter);
        buffer.append("Selectable" + this.delimeter);
        int i = 0;
        while (i < this.maxDep) {
            buffer.append("SourceModel/TableName" + this.delimeter);
            buffer.append("SourceColumnName" + this.delimeter);
            buffer.append("ColumnNameInSource" + this.delimeter);
            buffer.append("DataType(LENGTH)" + this.delimeter);
            buffer.append("ColumnDescription" + this.delimeter);
            buffer.append("Searchable" + this.delimeter);
            buffer.append("Selectable" + this.delimeter);
            ++i;
        }
        return buffer.toString();
    }

    public String getFileString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(String.valueOf(this.getHeaderString()) + this.NEWLINE);
        Iterator iter = this.rows.iterator();
        String nextRow = null;
        while (iter.hasNext()) {
            nextRow = (String)iter.next();
            buffer.append(String.valueOf(nextRow) + this.NEWLINE);
        }
        return buffer.toString();
    }

    private String getSearchableString(int value) {
        switch (value) {
            case 0: {
                return SEARCHABLE_STRING;
            }
            case 1: {
                return ALL_EXCEPT_LIKE_STRING;
            }
            case 2: {
                return LIKE_ONLY_STRING;
            }
            case 3: {
                return UNSEARCHABLE_STRING;
            }
        }
        return UNKNOWN_STRING;
    }

    public String getDelimeter() {
        return this.delimeter;
    }

    public void setDelimeter(String delimeter) {
        this.delimeter = delimeter;
    }
}

