/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.ecore.EObject;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.metamodel.aspect.sql.SqlAspectHelper;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.metamodels.diagram.Diagram;
import org.teiid.designer.transformation.ui.UiConstants;
import org.teiid.designer.transformation.util.TransformationHelper;
import org.teiid.designer.ui.util.DiagramProxy;
import org.teiid.designer.ui.viewsupport.ModelObjectUtilities;
import org.teiid.query.ui.UiPlugin;

public class TransformationDiagramUtil {
    private static final String NAMESPACE_URI_PREFIX = "http://www.metamatrix.com/metamodels/";
    private static final String RELATIONAL_URI = "http://www.metamatrix.com/metamodels/Relational";
    private static final String DATA_ACCESS_URI = "http://www.metamatrix.com/metamodels/DataAccess";
    private static final String WEB_SERVICE_URI = "http://www.metamatrix.com/metamodels/WebService";
    private static final String XML_SERVICE_URI = "http://www.metamatrix.com/metamodels/XmlService";

    public static Diagram createTransformationDiagram(EObject target, ModelResource modelResource, boolean persistance) {
        Diagram result;
        block11: {
            result = null;
            boolean persist = persistance;
            if (ModelUtil.isIResourceReadOnly((IResource)modelResource.getResource())) {
                persist = false;
            }
            if (!TransformationDiagramUtil.diagramExistsForProcedure(modelResource, target) && (TransformationDiagramUtil.isVirtualProcedureOrTable(target) || TransformationDiagramUtil.isStandardVirtualSqlTable(target))) {
                boolean requiresStart = ModelerCore.startTxn((boolean)false, (boolean)true, (String)"Create Transformation Diagram", (Object)target);
                boolean succeeded = false;
                try {
                    try {
                        result = modelResource.getModelDiagrams().createNewDiagram(target, persist);
                        result.setType("transformationDiagramType");
                        succeeded = true;
                    }
                    catch (ModelWorkspaceException e) {
                        String message = UiConstants.Util.getString("TransformationDiagramUtil.createTransformationDiagramError", (Object)modelResource.toString());
                        UiConstants.Util.log(4, (Throwable)e, message);
                        if (!requiresStart) break block11;
                        if (succeeded) {
                            ModelerCore.commitTxn();
                            break block11;
                        }
                        ModelerCore.rollbackTxn();
                    }
                }
                finally {
                    if (requiresStart) {
                        if (succeeded) {
                            ModelerCore.commitTxn();
                        } else {
                            ModelerCore.rollbackTxn();
                        }
                    }
                }
            }
        }
        return result;
    }

    private static Diagram createProxiedTransformationDiagram(EObject target, ModelResource modelResource) {
        return new DiagramProxy(target, "transformationDiagramType", modelResource);
    }

    public static List getTransformationDiagrams(ModelResource modelResource, EObject eObject, boolean createIfNone, boolean persistance) {
        ArrayList<Diagram> transformationDiagrams = new ArrayList<Diagram>();
        try {
            ArrayList diagramList = new ArrayList(modelResource.getModelDiagrams().getDiagrams(eObject));
            Iterator iter = diagramList.iterator();
            Diagram nextDiagram = null;
            while (iter.hasNext()) {
                nextDiagram = (Diagram)iter.next();
                if (nextDiagram.getType() == null || !nextDiagram.getType().equals("transformationDiagramType")) continue;
                transformationDiagrams.add(nextDiagram);
            }
        }
        catch (ModelWorkspaceException e) {
            String message = UiConstants.Util.getString("TransformationDiagramUtil.getTransformationDiagramsError", (Object)modelResource.toString());
            UiConstants.Util.log(4, (Throwable)e, message);
        }
        if (transformationDiagrams.isEmpty()) {
            Diagram newTransformationDiagram = null;
            newTransformationDiagram = TransformationDiagramUtil.createProxiedTransformationDiagram(eObject, modelResource);
            if (newTransformationDiagram != null) {
                transformationDiagrams.add(newTransformationDiagram);
            }
        }
        return transformationDiagrams;
    }

    public static Diagram getTransformationDiagram(ModelResource modelResource, EObject eObject, boolean createIfNone, boolean persistance) {
        Diagram tDiagram = null;
        try {
            ArrayList diagramList = new ArrayList(modelResource.getModelDiagrams().getDiagrams(eObject));
            Iterator iter = diagramList.iterator();
            Diagram nextDiagram = null;
            while (iter.hasNext() && tDiagram == null) {
                nextDiagram = (Diagram)iter.next();
                if (nextDiagram.getType() == null || !nextDiagram.getType().equals("transformationDiagramType")) continue;
                tDiagram = nextDiagram;
            }
        }
        catch (ModelWorkspaceException e) {
            String message = UiConstants.Util.getString("TransformationDiagramUtil.getTransformationDiagramsError", (Object)modelResource.toString());
            UiConstants.Util.log(4, (Throwable)e, message);
        }
        if (tDiagram == null) {
            tDiagram = TransformationDiagramUtil.createProxiedTransformationDiagram(eObject, modelResource);
        }
        return tDiagram;
    }

    public static Diagram getTransformationDiagram(ModelResource modelResource, EObject transformationObject) {
        Diagram tDiagram = null;
        EObject mappingClassEObject = null;
        if (!TransformationHelper.isSqlTransformation((Object)transformationObject)) {
            EObject tRoot;
            if (TransformationHelper.isSqlTransformationMappingRoot((Object)transformationObject)) {
                mappingClassEObject = TransformationHelper.getTransformationLinkTarget((EObject)transformationObject);
            } else if (TransformationHelper.isTransformationMapping((Object)transformationObject) && (tRoot = transformationObject.eContainer()) != null) {
                mappingClassEObject = TransformationHelper.getTransformationLinkTarget((EObject)tRoot);
            }
        }
        if (mappingClassEObject != null) {
            tDiagram = TransformationDiagramUtil.getTransformationDiagram(modelResource, mappingClassEObject, true, true);
        }
        return tDiagram;
    }

    public static boolean isStandardVirtualSqlTable(Object input) {
        EObject eObject;
        String mmUri;
        boolean result = false;
        if (input instanceof EObject && (TransformationHelper.isVirtualSqlTable((Object)input) || TransformationHelper.isSqlVirtualProcedure((Object)input)) && (mmUri = (eObject = (EObject)input).eClass().getEPackage().getNsURI()) != null && (mmUri.equals(RELATIONAL_URI) || mmUri.equals(DATA_ACCESS_URI) || mmUri.equals(WEB_SERVICE_URI) || mmUri.equals(XML_SERVICE_URI))) {
            result = true;
        }
        return result;
    }

    public static boolean isVirtualProcedureOrTable(EObject eObject) {
        boolean result = (SqlAspectHelper.isTable((EObject)eObject) || SqlAspectHelper.isProcedure((EObject)eObject)) && ModelObjectUtilities.isVirtual((EObject)eObject);
        return result;
    }

    public static boolean isVirtualProcedure(EObject eObject) {
        return SqlAspectHelper.isProcedure((EObject)eObject) && ModelObjectUtilities.isVirtual((EObject)eObject);
    }

    public static boolean diagramExistsForProcedure(ModelResource modelResource, EObject eObject) {
        boolean exists = false;
        if (TransformationDiagramUtil.isVirtualProcedure(eObject)) {
            try {
                ArrayList diagramList = new ArrayList(modelResource.getModelDiagrams().getDiagrams(eObject));
                if (!diagramList.isEmpty()) {
                    exists = true;
                }
            }
            catch (ModelWorkspaceException e) {
                UiConstants.Util.log(4, (Throwable)e, null);
            }
        }
        return exists;
    }

    public static boolean isTreeLayout() {
        return UiPlugin.getDefault().getPreferenceStore().getBoolean("treeDiagramLayout");
    }
}

