/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.wizards;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.metamodels.core.ModelType;
import org.teiid.designer.metamodels.relational.Schema;
import org.teiid.designer.transformation.ui.UiConstants;
import org.teiid.designer.ui.PluginConstants;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.viewsupport.StatusInfo;
import org.teiid.designer.ui.common.widget.WrappingLabel;
import org.teiid.designer.ui.explorer.ModelExplorerContentProvider;
import org.teiid.designer.ui.explorer.ModelExplorerLabelProvider;
import org.teiid.designer.ui.viewsupport.ModelNameUtil;
import org.teiid.designer.ui.viewsupport.ModelUtilities;
import org.teiid.designer.ui.viewsupport.ModelWorkspaceDialog;

public class RelationalModelSelectorDialog
extends ModelWorkspaceDialog
implements UiConstants {
    private Label lblRelationalModelName;
    private Text txtRelationalModelName;
    private IContainer newModelParent;
    private ModelResource mrRelationalModel;
    private EObject selectedEObject;
    private SelectionAdapter saCreateCbxAdapter;
    private String newRelationalModelName;
    boolean createNewModel = false;
    private static final String FILE_EXT = ".xmi";
    private static final int MODEL_NAME_TEXT_WIDTH = (int)((double)Display.getCurrent().getBounds().width * 0.25);
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix(RelationalModelSelectorDialog.class);
    private static final String TITLE = RelationalModelSelectorDialog.getString("title");
    private static final String MODEL_CREATE_ERROR_NO_NAME = RelationalModelSelectorDialog.getString("noName.message");
    private static final String MODEL_CREATE_ERROR_IS_VALID = RelationalModelSelectorDialog.getString("isValid.message");
    private static String MODEL_CREATE_INSTRUCTION = RelationalModelSelectorDialog.getString("modelCreateInstruction.message");
    private static String EXISTING_MODEL_FOLDER_SELECTED = RelationalModelSelectorDialog.getString("existingModelFolderLocationSelected.message");
    private static final String NEW_MODEL_LABEL = RelationalModelSelectorDialog.getString("modelName.text");
    private static final String SELECTED_MODEL_NOT_RELATIONAL_MODEL = RelationalModelSelectorDialog.getString("selModelNotRelational.message");
    private static final String SELECTED_RESOURCE_NOT_RELATIONAL_MODEL = RelationalModelSelectorDialog.getString("selResrcNotRelational.message");
    private static final String DESCR_LABEL_TEXT = RelationalModelSelectorDialog.getString("descriptionLabel.text");

    private static String getString(String id) {
        return Util.getString(String.valueOf(I18N_PREFIX) + id, new Object[0]);
    }

    public RelationalModelSelectorDialog(Shell parent) {
        this(parent, (ILabelProvider)new ModelExplorerLabelProvider(), (ITreeContentProvider)new ModelExplorerContentProvider());
    }

    public RelationalModelSelectorDialog(Shell parent, ILabelProvider labelProvider, ITreeContentProvider contentProvider) {
        super(parent, TITLE, labelProvider, contentProvider);
    }

    protected Control createDialogArea(Composite parent) {
        WrappingLabel descriptionLabel = WidgetFactory.createWrappingLabel((Composite)parent, (int)0);
        GridData descriptionLabelGridData = new GridData(768);
        descriptionLabelGridData.horizontalIndent = 20;
        descriptionLabel.setLayoutData((Object)descriptionLabelGridData);
        descriptionLabel.setText(DESCR_LABEL_TEXT);
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createModelCreationComposite(composite);
        return composite;
    }

    private Composite createModelCreationComposite(Composite parent) {
        Composite nameComposite = new Composite(parent, 0);
        GridLayout nameCompositeLayout = new GridLayout();
        nameComposite.setLayout((Layout)nameCompositeLayout);
        nameCompositeLayout.numColumns = 3;
        nameCompositeLayout.marginWidth = 0;
        GridData nameCompositeGridData = new GridData(768);
        nameCompositeGridData.horizontalIndent = 20;
        nameComposite.setLayoutData((Object)nameCompositeGridData);
        this.lblRelationalModelName = new Label(nameComposite, 0);
        this.lblRelationalModelName.setText(NEW_MODEL_LABEL);
        this.lblRelationalModelName.getAlignment();
        this.txtRelationalModelName = WidgetFactory.createTextField((Composite)nameComposite, (int)256);
        GridData modelNameTextGridData = new GridData();
        modelNameTextGridData.widthHint = MODEL_NAME_TEXT_WIDTH;
        this.txtRelationalModelName.setLayoutData((Object)modelNameTextGridData);
        this.txtRelationalModelName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                RelationalModelSelectorDialog.this.handleSetRelationalModelName();
            }
        });
        this.handleSetRelationalModelName();
        this.setCreateControlsEnabled(false);
        return nameComposite;
    }

    void createRelationalModel() {
        this.mrRelationalModel = this.constructRelationalModel((IResource)this.newModelParent, this.newRelationalModelName);
        try {
            if (this.mrRelationalModel != null) {
                this.mrRelationalModel.save(null, false);
            }
        }
        catch (ModelWorkspaceException mwe) {
            Util.log((Throwable)mwe);
        }
    }

    public Object[] getResult() {
        if (this.mrRelationalModel != null) {
            return new Object[]{this.mrRelationalModel};
        }
        if (this.selectedEObject != null) {
            return new Object[]{this.selectedEObject};
        }
        return super.getResult();
    }

    private SelectionAdapter getOKSelectionListener() {
        if (this.saCreateCbxAdapter == null) {
            this.saCreateCbxAdapter = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    if (RelationalModelSelectorDialog.this.createNewModel) {
                        RelationalModelSelectorDialog.this.createRelationalModel();
                    }
                }
            };
        }
        return this.saCreateCbxAdapter;
    }

    private void updateDialogMessage(String sMessage, boolean bIsError) {
        int iStatusCode = 0;
        if (bIsError) {
            iStatusCode = 4;
        }
        StatusInfo status = new StatusInfo("org.teiid.designer.transformation.ui", iStatusCode, sMessage);
        this.updateStatus((IStatus)status);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        super.selectionChanged(event);
        this.newModelParent = null;
        IStructuredSelection sel = (IStructuredSelection)this.getTreeViewer().getSelection();
        Object oSelection = sel.getFirstElement();
        this.createNewModel = true;
        if (this.isRelationalModelResource(oSelection)) {
            this.newModelParent = null;
            this.selectedEObject = null;
            this.createNewModel = false;
            String instruction = Util.getString("RelationalModelSelectorDialog.useExistingModelInstruction.message", (Object)((IResource)oSelection).getName());
            this.updateDialogMessage(instruction, false);
            this.setCreateControlsEnabled(false);
            this.enableOKButton();
        } else if (this.isModelResource(oSelection)) {
            this.newModelParent = null;
            this.selectedEObject = null;
            this.setCreateControlsEnabled(false);
            this.disableOKButton();
            this.updateDialogMessage(SELECTED_MODEL_NOT_RELATIONAL_MODEL, true);
        } else if (this.isContainer(oSelection)) {
            this.newModelParent = (IContainer)oSelection;
            this.selectedEObject = null;
            this.setCreateControlsEnabled(true);
            this.handleSetRelationalModelName();
        } else if (this.isPackageInRelationalModel(oSelection)) {
            this.selectedEObject = (EObject)oSelection;
            this.newModelParent = null;
            this.createNewModel = false;
            this.setCreateControlsEnabled(false);
            this.enableOKButton();
            this.updateDialogMessage(EXISTING_MODEL_FOLDER_SELECTED, false);
        } else if (oSelection instanceof IResource) {
            this.newModelParent = null;
            this.selectedEObject = null;
            this.setCreateControlsEnabled(false);
            this.disableOKButton();
            this.updateDialogMessage(SELECTED_RESOURCE_NOT_RELATIONAL_MODEL, true);
        }
    }

    void handleSetRelationalModelName() {
        String nameText = this.txtRelationalModelName.getText();
        if (this.isValidModelName(nameText)) {
            this.newRelationalModelName = nameText;
            this.enableOKButton();
            String message = this.getModelNameStatus(nameText);
            this.updateDialogMessage(message, false);
        } else {
            this.disableOKButton();
            if (nameText.trim().length() == 0) {
                if (this.newModelParent != null) {
                    MODEL_CREATE_INSTRUCTION = Util.getString("RelationalModelSelectorDialog.modelCreateInstruction.message", (Object)this.newModelParent.getName());
                    this.updateDialogMessage(MODEL_CREATE_INSTRUCTION, true);
                }
            } else {
                String message = this.getModelNameStatus(nameText);
                this.updateDialogMessage(message, true);
            }
        }
    }

    public ModelResource constructRelationalModel(IResource targetRes, String sModelName) {
        String sFileName = this.getFileName(sModelName);
        IPath relativeModelPath = targetRes.getProjectRelativePath().append(sFileName);
        IFile modelFile = targetRes.getProject().getFile(relativeModelPath);
        ModelResource resrc = ModelerCore.create((IFile)modelFile);
        try {
            resrc.getModelAnnotation().setPrimaryMetamodelUri("http://www.metamatrix.com/metamodels/Relational");
            resrc.getModelAnnotation().setModelType(ModelType.PHYSICAL_LITERAL);
        }
        catch (ModelWorkspaceException mwe) {
            mwe.printStackTrace();
        }
        return resrc;
    }

    private String getModelNameStatus(String sModelName) {
        if (sModelName == null || sModelName.length() == 0) {
            return MODEL_CREATE_ERROR_NO_NAME;
        }
        IStatus status = ModelNameUtil.validate((String)sModelName, (String)FILE_EXT, (IContainer)this.newModelParent, (int)13);
        if (status.getSeverity() == 4) {
            return String.valueOf(ModelNameUtil.MESSAGES.INVALID_MODEL_NAME) + status.getMessage();
        }
        return MODEL_CREATE_ERROR_IS_VALID;
    }

    private boolean isValidModelName(String sModelName) {
        if (sModelName == null || sModelName.length() == 0) {
            return false;
        }
        IStatus status = ModelNameUtil.validate((String)sModelName, (String)FILE_EXT, (IContainer)this.newModelParent, (int)13);
        return status.getSeverity() != 4;
    }

    private void setCreateControlsEnabled(boolean b) {
        this.txtRelationalModelName.setEnabled(b);
        this.lblRelationalModelName.setEnabled(b);
    }

    private void disableOKButton() {
        if (this.getOkButton() != null) {
            this.getOkButton().removeSelectionListener((SelectionListener)this.getOKSelectionListener());
            this.getOkButton().setEnabled(false);
        }
    }

    private void enableOKButton() {
        if (this.getOkButton() != null) {
            this.getOkButton().addSelectionListener((SelectionListener)this.getOKSelectionListener());
            this.getOkButton().setEnabled(true);
        }
    }

    private boolean isRelationalModelResource(Object oSelection) {
        boolean bResult = false;
        if (oSelection instanceof IResource) {
            try {
                ModelResource mr;
                IResource resource = (IResource)oSelection;
                if (ModelUtilities.isModelFile((IResource)resource) && (mr = ModelUtil.getModelResource((IFile)((IFile)resource), (boolean)true)).getPrimaryMetamodelDescriptor() != null && mr.getPrimaryMetamodelDescriptor().getNamespaceURI().equals("http://www.metamatrix.com/metamodels/Relational") && mr.getModelType().equals(ModelType.PHYSICAL_LITERAL)) {
                    bResult = true;
                }
            }
            catch (ModelWorkspaceException mwe) {
                ModelerCore.Util.log(4, (Throwable)mwe, mwe.getMessage());
            }
        }
        return bResult;
    }

    private boolean isModelResource(Object oSelection) {
        boolean bResult = false;
        if (oSelection instanceof IResource) {
            try {
                ModelResource mr;
                IResource resource = (IResource)oSelection;
                if (ModelUtilities.isModelFile((IResource)resource) && (mr = ModelUtil.getModelResource((IFile)((IFile)resource), (boolean)true)).getPrimaryMetamodelDescriptor() != null) {
                    bResult = true;
                }
            }
            catch (ModelWorkspaceException mwe) {
                ModelerCore.Util.log(4, (Throwable)mwe, mwe.getMessage());
            }
        }
        return bResult;
    }

    private boolean isContainer(Object oSelection) {
        return oSelection instanceof IContainer || oSelection instanceof IFolder;
    }

    private boolean isPackageInRelationalModel(Object oSelection) {
        return oSelection instanceof EObject && oSelection instanceof Schema;
    }

    protected TreeViewer createTreeViewer(Composite parent) {
        TreeViewer result = super.createTreeViewer(parent);
        result.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                boolean result = true;
                if (element instanceof IProject) {
                    IProject project = (IProject)element;
                    if (!project.isOpen()) {
                        result = false;
                    } else {
                        try {
                            if (!project.hasNature("org.teiid.designer.core.modelNature")) {
                                result = false;
                            } else {
                                String name = project.getName();
                                if (name != null && PluginConstants.HIDDEN_PROJECTS.contains(name)) {
                                    return false;
                                }
                            }
                        }
                        catch (CoreException theException) {
                            ModelerCore.Util.log((Throwable)theException);
                            result = false;
                        }
                    }
                }
                return result;
            }
        });
        result.expandToLevel(2);
        return result;
    }

    private String getFileName(String sModelName) {
        String sResult = sModelName.trim();
        if (!sResult.endsWith(FILE_EXT)) {
            sResult = String.valueOf(sResult) + FILE_EXT;
        }
        return sResult;
    }

    public boolean close() {
        this.getTreeViewer().removeSelectionChangedListener((ISelectionChangedListener)this);
        return super.close();
    }
}

