/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.wizards;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.metamodel.aspect.sql.SqlAspectHelper;
import org.teiid.designer.core.util.NewModelObjectHelperManager;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.transformation.ui.UiConstants;
import org.teiid.designer.transformation.util.TransformationHelper;
import org.teiid.designer.ui.common.widget.InheritanceCheckboxTreeViewer;
import org.teiid.designer.ui.viewsupport.ModelObjectUtilities;
import org.teiid.designer.ui.wizards.ICheckboxTreeViewerListenerController;
import org.teiid.designer.ui.wizards.StructuralCopyModelFeaturePopulator;

public class TransformationCopyModelFeaturePopulator
extends StructuralCopyModelFeaturePopulator
implements UiConstants {
    private Stack copies;
    private Stack curParentIndex;
    private Stack skippingDescendants;
    private List copiedSiblings;

    public TransformationCopyModelFeaturePopulator(IFile sourceFile) {
        super(sourceFile);
    }

    public TransformationCopyModelFeaturePopulator(IFile sourceFile, ICheckboxTreeViewerListenerController listenerController) {
        super(sourceFile, listenerController);
    }

    public void copyModel(ModelResource sourceModelResource, ModelResource targetModelResource, InheritanceCheckboxTreeViewer viewer, Map extraProperties, boolean copyAllDescriptions, IProgressMonitor monitor) {
        throw new UnsupportedOperationException();
    }

    public void copyModel(ModelResource sourceModelResource, ModelResource targetModelResource, Map extraProperties, boolean copyAllDescriptions, IProgressMonitor monitor) throws ModelerCoreException {
        String desc;
        if (copyAllDescriptions && (desc = sourceModelResource.getDescription()) != null) {
            targetModelResource.getModelAnnotation().setDescription(desc);
        }
        List sourceFirstLevelChildren = sourceModelResource.getEObjects();
        int jdbcSourceIndex = -1;
        int i = 0;
        while (i < sourceFirstLevelChildren.size()) {
            EObject nextObj = (EObject)sourceFirstLevelChildren.get(i);
            if (ModelObjectUtilities.isJdbcSource((EObject)nextObj)) {
                jdbcSourceIndex = i;
                break;
            }
            ++i;
        }
        if (jdbcSourceIndex > -1) {
            sourceFirstLevelChildren.remove(jdbcSourceIndex);
        }
        Collection sourceFirstLevelChildrenCopies = null;
        HashMap originalsToCopies = new HashMap();
        sourceFirstLevelChildrenCopies = ModelerCore.getModelEditor().copyAll((Collection)sourceFirstLevelChildren, originalsToCopies);
        Map copiesToOriginals = this.invertMap(originalsToCopies);
        EList targetFirstLevelChildren = targetModelResource.getEmfResource().getContents();
        int numInitialFirstLevelNodes = targetFirstLevelChildren.size();
        targetModelResource.getEmfResource().getContents().addAll(sourceFirstLevelChildrenCopies);
        EList copiedFirstLevelChildrenList = targetModelResource.getEmfResource().getContents();
        ArrayList modifiedCopiedFirstLevelChildrenList = new ArrayList(copiedFirstLevelChildrenList.size() - numInitialFirstLevelNodes);
        int i2 = numInitialFirstLevelNodes;
        while (i2 < copiedFirstLevelChildrenList.size()) {
            modifiedCopiedFirstLevelChildrenList.add(copiedFirstLevelChildrenList.get(i2));
            ++i2;
        }
        this.doTransformations(copiesToOriginals, modifiedCopiedFirstLevelChildrenList, extraProperties);
        if (copyAllDescriptions) {
            this.copyDescriptions(copiesToOriginals, targetModelResource);
        }
    }

    private Map invertMap(Map originalsToCopies) {
        HashMap copiesToOriginals = new HashMap();
        for (Map.Entry me : originalsToCopies.entrySet()) {
            copiesToOriginals.put(me.getValue(), me.getKey());
        }
        return copiesToOriginals;
    }

    private void doTransformations(Map copiesToOriginals, List copiedFirstLevelEObjects, Map extraProperties) {
        ModelerCore.commitTxn();
        ModelerCore.startTxn((boolean)false, (boolean)false, (String)"NewModel Transform - set the SQL", null);
        this.copies = new Stack();
        this.curParentIndex = new Stack();
        this.skippingDescendants = new Stack();
        this.copiedSiblings = copiedFirstLevelEObjects;
        boolean done = false;
        while (!done) {
            this.copies.push(this.copiedSiblings);
            List<Boolean> descendantsToSkip = new ArrayList<Boolean>(this.copiedSiblings.size());
            int index = 0;
            while (index < this.copiedSiblings.size() && !done) {
                EObject curCopy = (EObject)this.copiedSiblings.get(index);
                EObject curOriginal = (EObject)copiesToOriginals.get(curCopy);
                boolean originalIsTable = SqlAspectHelper.isTable((EObject)curOriginal);
                boolean copyIsTable = TransformationHelper.isVirtualSqlTable((Object)curCopy);
                if (originalIsTable && !copyIsTable) {
                    Util.log(4, Util.getString("TransformationCopyModelFeaturePopulator.doTransformationsInconsistencyError", new Object[0]));
                    done = true;
                } else if (copyIsTable && !originalIsTable) {
                    Util.log(4, Util.getString("TransformationCopyModelFeaturePopulator.doTransformationsInconsistencyError", new Object[0]));
                    done = true;
                } else {
                    boolean originalIsProcedure = false;
                    boolean copyIsProcedure = false;
                    if (!originalIsTable) {
                        originalIsProcedure = SqlAspectHelper.isProcedure((EObject)curOriginal);
                        copyIsProcedure = TransformationHelper.isSqlProcedure((Object)curCopy);
                    }
                    if (originalIsProcedure && !copyIsProcedure) {
                        Util.log(4, Util.getString("TransformationCopyModelFeaturePopulator.doTransformationsInconsistencyError", new Object[0]));
                        done = true;
                    } else if (copyIsProcedure && !originalIsProcedure) {
                        Util.log(4, Util.getString("TransformationCopyModelFeaturePopulator.doTransformationsInconsistencyError", new Object[0]));
                        done = true;
                    } else {
                        boolean doTransformation = originalIsTable || originalIsProcedure;
                        Boolean skipDescendants = new Boolean(doTransformation);
                        descendantsToSkip.add(skipDescendants);
                        if (doTransformation) {
                            try {
                                NewModelObjectHelperManager.helpCreate((Object)curCopy, (Map)extraProperties);
                            }
                            catch (ModelerCoreException modelerCoreException) {
                                Util.log(4, Util.getString("TransformationCopyModelFeaturePopulator.doTransformationsHelpCreateError", new Object[0]));
                            }
                            TransformationHelper.createTransformation((EObject)curCopy, (EObject)curOriginal);
                        }
                    }
                }
                ++index;
            }
            this.skippingDescendants.push(descendantsToSkip);
            boolean descendantsFound = this.getNextDescendantNodeOfSiblings(0, descendantsToSkip);
            while (!done && !descendantsFound) {
                if (this.copies.size() == 1) {
                    done = true;
                    continue;
                }
                Integer prevChildIndexInteger = (Integer)this.curParentIndex.pop();
                int prevChildIndex = prevChildIndexInteger;
                this.copies.pop();
                this.copiedSiblings = (List)this.copies.peek();
                this.skippingDescendants.pop();
                descendantsToSkip = (List)this.skippingDescendants.peek();
                index = prevChildIndex + 1;
                descendantsFound = this.getNextDescendantNodeOfSiblings(index, descendantsToSkip);
            }
        }
    }

    private boolean getNextDescendantNodeOfSiblings(int startingIndex, List descendantsToSkip) {
        boolean descendantsFound = false;
        int index = startingIndex;
        int numCopiedSiblings = this.copiedSiblings.size();
        while (index < numCopiedSiblings && !descendantsFound) {
            Boolean curSkipDescendantsBoolean = (Boolean)descendantsToSkip.get(index);
            boolean curSkipDescendants = curSkipDescendantsBoolean;
            if (!curSkipDescendants) {
                EObject curCopy = (EObject)this.copiedSiblings.get(index);
                this.copiedSiblings = curCopy.eContents();
                numCopiedSiblings = this.copiedSiblings.size();
                this.curParentIndex.push(new Integer(index));
                descendantsFound = true;
            }
            ++index;
        }
        return descendantsFound;
    }

    private void copyDescriptions(Map copiesToOriginals, ModelResource targetResource) throws ModelerCoreException {
        for (Object key : copiesToOriginals.keySet()) {
            EObject eObj = (EObject)key;
            EObject originalEObj = (EObject)copiesToOriginals.get(key);
            String description = ModelerCore.getModelEditor().getDescription(originalEObj);
            if (description == null) continue;
            ModelerCore.getModelEditor().setDescription(eObj, description);
        }
    }
}

