/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.wizards;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.util.ModelContents;
import org.teiid.designer.core.util.ModelResourceContainerFactory;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.metamodels.core.Annotation;
import org.teiid.designer.metamodels.core.AnnotationContainer;
import org.teiid.designer.relational.ui.wizards.RelationalObjectProcessor;
import org.teiid.designer.tools.textimport.ui.wizards.AbstractObjectProcessor;
import org.teiid.designer.transformation.ui.UiConstants;
import org.teiid.designer.transformation.ui.textimport.VirtualTableRowObject;
import org.teiid.designer.transformation.ui.util.TransformationDiagramUtil;
import org.teiid.designer.transformation.util.TransformationHelper;

public class VirtualRelationalObjectProcessor
extends AbstractObjectProcessor {
    private static final String I18N_PREFIX = "VirtualRelationalObjectProcessor";
    private static final String SEPARATOR = ".";
    private IProgressMonitor monitor;

    public Collection createRowObjsFromStrings(Collection rowStrings) {
        Iterator iter = rowStrings.iterator();
        String nextStr = null;
        ArrayList<VirtualTableRowObject> stringRows = new ArrayList<VirtualTableRowObject>();
        VirtualTableRowObject nextRow = null;
        while (iter.hasNext()) {
            nextStr = (String)iter.next();
            nextRow = new VirtualTableRowObject(nextStr);
            if (nextRow.isValid()) {
                stringRows.add(nextRow);
                continue;
            }
            this.logParsingError(nextStr);
        }
        return stringRows;
    }

    public void generateObjsFromRowObjs(Object targetResource, Object location, Collection tableRows) {
        int iRow = 0;
        Iterator iter = tableRows.iterator();
        EObject bt = null;
        VirtualTableRowObject nextRow = null;
        String sSize = Integer.toString(tableRows.size());
        while (iter.hasNext()) {
            ++iRow;
            nextRow = (VirtualTableRowObject)iter.next();
            if (this.monitor != null) {
                this.monitor.worked(1);
                this.monitor.subTask(UiConstants.Util.getString("VirtualRelationalObjectProcessor.incrementalProgress", new Object[]{Integer.toString(iRow), sSize, nextRow.getName()}));
            }
            bt = this.createTable(location, nextRow);
            this.createTransformation(bt, nextRow.getSelectSql(), targetResource);
            this.createAnnotation(targetResource, bt, nextRow.getDescription());
            if (this.monitor != null && this.monitor.isCanceled()) break;
        }
    }

    private void createAnnotation(Object targetResource, EObject eObject, String description) {
        if (description != null && description.length() > 0) {
            ModelContents contents = null;
            if (targetResource instanceof ModelResource) {
                contents = ModelerCore.getModelEditor().getModelContents((ModelResource)targetResource);
            } else if (targetResource instanceof Resource) {
                contents = ModelerCore.getModelEditor().getModelContents((Resource)targetResource);
            }
            Annotation newAnnot = ModelResourceContainerFactory.createNewAnnotation((EObject)eObject, (AnnotationContainer)contents.getAnnotationContainer(true));
            newAnnot.setDescription(description);
        }
    }

    public EObject createSchema(ModelResource modelResource, String schemaName) {
        EObject newSchema = RelationalObjectProcessor.createSchema((String)schemaName, null);
        this.addValue(modelResource, newSchema, this.getModelResourceContents(modelResource));
        return newSchema;
    }

    private EObject createTable(Object location, VirtualTableRowObject tableRow) {
        EObject vTarget = null;
        String selectSql = tableRow.getSelectSql();
        if (selectSql != null && selectSql.trim().toUpperCase().startsWith("CREATE")) {
            vTarget = RelationalObjectProcessor.createProcedure((String)tableRow.getName());
            TransformationHelper.createProcResultSet((EObject)vTarget);
        } else {
            vTarget = RelationalObjectProcessor.createBaseTable((String)tableRow.getName(), (boolean)false);
        }
        if (vTarget != null) {
            if (location instanceof ModelResource) {
                this.addValue(location, vTarget, this.getModelResourceContents((ModelResource)location));
            } else if (RelationalObjectProcessor.isSchema((Object)location)) {
                this.addValue(location, vTarget, RelationalObjectProcessor.getTablesEList((Object)location));
            } else if (RelationalObjectProcessor.isCatalog((Object)location)) {
                this.addValue(location, vTarget, RelationalObjectProcessor.getTablesEList((Object)location));
            } else if (location instanceof Resource) {
                this.addValue(location, vTarget, ((Resource)location).getContents());
            }
        }
        return vTarget;
    }

    private void createTransformation(EObject baseTable, String selectSql, Object resource) {
        TransformationHelper.createTransformation((EObject)baseTable, (String)selectSql);
        if (resource instanceof ModelResource) {
            TransformationDiagramUtil.createTransformationDiagram(baseTable, (ModelResource)resource, true);
        }
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }
}

