/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.wizards.file;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.metamodels.relational.aspects.validation.RelationalStringNameValidator;
import org.teiid.designer.query.IQueryFactory;
import org.teiid.designer.query.IQueryService;
import org.teiid.designer.query.proc.ITeiidColumnInfo;
import org.teiid.designer.query.sql.symbol.IElementSymbol;
import org.teiid.designer.transformation.ui.wizards.xmlfile.XmlAttribute;
import org.teiid.designer.transformation.ui.wizards.xmlfile.XmlElement;

public class TeiidColumnInfo
implements ITeiidColumnInfo {
    private static final IPath EMPTY_PATH = new Path("");
    private IElementSymbol nameSymbol;
    private String datatype;
    private int width = 10;
    private boolean forOrdinality;
    private String defaultValue = "";
    private IPath fullXmlPath = EMPTY_PATH;
    private IPath rootXmlPath = EMPTY_PATH;
    private XmlElement xmlElement;
    private XmlAttribute xmlAttribute;
    private boolean noTrim;
    private IStatus status;
    RelationalStringNameValidator validator = new RelationalStringNameValidator(true);

    public TeiidColumnInfo(String name) {
        this(name, "string");
    }

    public TeiidColumnInfo(String name, String datatype) {
        CoreArgCheck.isNotEmpty((String)name, (String)"name is null");
        CoreArgCheck.isNotEmpty((String)datatype, (String)"datatype is null");
        this.initNameSymbol(name);
        this.datatype = datatype;
        this.validate();
    }

    public TeiidColumnInfo(String name, String datatype, int width) {
        this(name, datatype);
        CoreArgCheck.isPositive((int)width, (String)"width is zero or less");
        this.width = width;
    }

    public TeiidColumnInfo(String name, boolean ordinality, String datatype, String defaultValue, String fullXmlPath) {
        this(name, datatype);
        this.forOrdinality = ordinality;
        this.defaultValue = defaultValue == null ? "" : defaultValue;
        this.fullXmlPath = fullXmlPath == null ? EMPTY_PATH : new Path(fullXmlPath);
        this.validate();
    }

    private void initNameSymbol(String name) {
        IQueryService queryService = ModelerCore.getTeiidQueryService();
        IQueryFactory factory = queryService.createQueryFactory();
        this.nameSymbol = factory.createElementSymbol(name.replaceAll("\\.", "_"));
    }

    public String getSymbolName() {
        return this.nameSymbol.toString();
    }

    public String getName() {
        String name = this.nameSymbol.toString();
        return name.replaceAll("\"", "");
    }

    public void setName(String name) {
        CoreArgCheck.isNotNull((Object)name, (String)"name is null");
        this.initNameSymbol(name);
        this.validate();
    }

    public String getDatatype() {
        return this.datatype;
    }

    public void setDatatype(String datatype) {
        CoreArgCheck.isNotNull((Object)datatype, (String)"datatype is null");
        this.datatype = datatype;
        this.validate();
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        CoreArgCheck.isPositive((int)width, (String)"width is less than 1");
        this.width = width;
        this.validate();
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue == null ? "" : defaultValue;
        this.validate();
    }

    public void setRelativePath(String relativePath) {
        this.fullXmlPath = relativePath == null ? this.rootXmlPath : this.rootXmlPath.append(relativePath);
    }

    public String getRelativePath() {
        String rootPath;
        String fullPath;
        if (this.xmlElement != null && (fullPath = this.getFullXmlPath()).startsWith(rootPath = this.rootXmlPath.toString())) {
            return fullPath.substring(rootPath.length(), fullPath.length());
        }
        if (!this.fullXmlPath.isEmpty()) {
            if (!this.rootXmlPath.isEmpty() && this.fullXmlPath.toString().indexOf(this.rootXmlPath.toString()) > -1) {
                return String.valueOf('/') + this.fullXmlPath.removeFirstSegments(this.rootXmlPath.segmentCount()).toString();
            }
            return this.fullXmlPath.toString();
        }
        return "";
    }

    public void setXmlElement(XmlElement element) {
        this.xmlElement = element;
    }

    public void setXmlAttribute(XmlAttribute attribute) {
        this.xmlAttribute = attribute;
        this.xmlElement = attribute.getElement();
    }

    public String getFullXmlPath() {
        if (this.isXmlAttribute()) {
            String theFullPath = null;
            theFullPath = this.xmlElement != null ? String.valueOf(this.xmlElement.getFullPath()) + "/@" + this.xmlAttribute.getName() : this.fullXmlPath.toString();
            return theFullPath;
        }
        if (this.xmlElement != null) {
            return this.xmlElement.getFullPath();
        }
        return this.fullXmlPath.toString();
    }

    public void setFullXmlPath(String fullPath) {
        this.fullXmlPath = fullPath == null ? EMPTY_PATH : new Path(fullPath);
    }

    public void setRootPath(String thePath) {
        if (thePath != null && thePath.length() > 0) {
            Path oldRelativePath = new Path(this.getRelativePath());
            String tmpRoot = thePath;
            if (thePath.endsWith("/")) {
                tmpRoot = tmpRoot.substring(0, thePath.length() - 1);
            }
            String newFullPath = String.valueOf(tmpRoot) + oldRelativePath;
            this.setFullXmlPath(newFullPath);
            this.rootXmlPath = new Path(thePath);
        } else {
            this.rootXmlPath = EMPTY_PATH;
        }
    }

    public XmlElement getXmlElement() {
        return this.xmlElement;
    }

    public XmlAttribute getXmlAttribute() {
        return this.xmlAttribute;
    }

    public boolean isXmlAttribute() {
        return this.xmlAttribute != null;
    }

    public boolean getOrdinality() {
        return this.forOrdinality;
    }

    public void setOrdinality(boolean value) {
        this.forOrdinality = value;
        this.validate();
    }

    public boolean isNoTrim() {
        return this.noTrim;
    }

    public void setNoTrim(boolean noTrim) {
        this.noTrim = noTrim;
    }

    public IStatus getStatus() {
        return this.status;
    }

    public void setStatus(IStatus status) {
        this.status = status;
    }

    private void validate() {
        this.setStatus(Status.OK_STATUS);
    }

    public String toString() {
        StringBuilder text = new StringBuilder();
        text.append("Teiid Metadata Column Info: ");
        text.append("name =").append(this.getName());
        text.append("symbol name = ").append(this.getSymbolName());
        text.append(", datatype =").append(this.getDatatype());
        return text.toString();
    }
}

