/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.wizards.file;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.validation.rules.StringNameValidator;
import org.teiid.designer.metamodels.relational.aspects.validation.RelationalStringNameValidator;
import org.teiid.designer.query.IProcedureService;
import org.teiid.designer.query.IQueryService;
import org.teiid.designer.query.proc.ITeiidColumnInfo;
import org.teiid.designer.query.proc.ITeiidMetadataFileInfo;
import org.teiid.designer.transformation.ui.UiConstants;
import org.teiid.designer.transformation.ui.wizards.file.TeiidColumnInfo;
import org.teiid.designer.transformation.ui.wizards.file.TeiidFileInfo;

public class TeiidMetadataFileInfo
extends TeiidFileInfo
implements UiConstants,
ITeiidMetadataFileInfo {
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix(TeiidMetadataFileInfo.class);
    private static final StringNameValidator validator = new RelationalStringNameValidator(false);
    private int numberOfCachedLines = 20;
    private int numberOfLinesInFile = 0;
    private boolean includeHeader = true;
    private boolean includeQuote = false;
    private boolean includeEscape = false;
    private boolean includeSkip = false;
    private boolean useHeaderForColumnNames = true;
    private boolean includeNoTrim = false;
    private int headerLineNumber = 1;
    private int firstDataRow = 2;
    private boolean delimitedColumns = true;
    private String delimiter = ",";
    private String quote = "\"";
    private String escape = "\\";
    private boolean fixedWidthColumns = false;
    private int numberOfFixedWidthColumns = 10;
    private boolean doProcess;
    private String[] cachedFirstLines;
    private List<ITeiidColumnInfo> columnInfoList;
    private boolean isUrl = false;
    private String fileUrl;
    private String charSet;
    private boolean ignoreReload = false;
    private String charset = "UTF-8";
    private boolean includeTypeLine = false;
    private boolean loaded = false;

    private static String getString(String id) {
        return Util.getString(String.valueOf(I18N_PREFIX) + id, new Object[0]);
    }

    public TeiidMetadataFileInfo(File dataFile) {
        super(dataFile, true);
        CoreArgCheck.isNotNull((Object)dataFile, (String)"dataFile is null");
        this.initialize();
    }

    public TeiidMetadataFileInfo(File dataFile, String charset) {
        super(dataFile, true);
        CoreArgCheck.isNotNull((Object)dataFile, (String)"dataFile is null");
        if (charset != null && charset.length() > 0) {
            this.charset = charset;
        }
        this.initialize();
    }

    public TeiidMetadataFileInfo(TeiidMetadataFileInfo info) {
        super(info.getDataFile(), true);
        this.inject(info);
    }

    public void inject(TeiidMetadataFileInfo info) {
        CoreArgCheck.isNotNull((Object)info.getDataFile(), (String)"dataFile is null");
        CoreArgCheck.isNotEmpty((String)info.getDelimiter(), (String)"delimiter is null");
        CoreArgCheck.isPositive((int)info.getHeaderLineNumber(), (String)"header line number is less than zero");
        this.ignoreReload = true;
        this.delimiter = info.getDelimiter();
        this.quote = info.getQuote();
        this.numberOfFixedWidthColumns = info.getNumberOfFixedWidthColumns();
        this.headerLineNumber = info.getHeaderLineNumber();
        this.fixedWidthColumns = info.isFixedWidthColumns();
        this.delimitedColumns = info.doUseDelimitedColumns();
        this.useHeaderForColumnNames = info.doUseHeaderForColumnNames();
        this.firstDataRow = info.getFirstDataRow();
        this.includeTypeLine = info.getIncludeTypeLine();
        this.includeEscape = info.doIncludeEscape();
        this.includeHeader = info.doIncludeHeader();
        this.includeQuote = info.doIncludeQuote();
        this.includeSkip = info.doIncludeSkip();
        this.includeNoTrim = info.doIncludeNoTrim();
        this.cachedFirstLines = info.cachedFirstLines;
        this.numberOfLinesInFile = info.getNumberOfLinesInFile();
        this.columnInfoList = new ArrayList<ITeiidColumnInfo>();
        for (ITeiidColumnInfo colInfo : info.getColumnInfoList()) {
            this.columnInfoList.add(new TeiidColumnInfo(colInfo.getSymbolName(), colInfo.getDatatype(), colInfo.getWidth()));
        }
        this.setViewTableName(info.getViewTableName());
        this.setStatus(info.getStatus());
        this.ignoreReload = false;
    }

    private void initialize() {
        this.cachedFirstLines = new String[0];
        this.columnInfoList = new ArrayList<ITeiidColumnInfo>();
        this.setViewTableName("new_table");
        this.setStatus(Status.OK_STATUS);
    }

    public int getHeaderLineNumber() {
        return this.headerLineNumber;
    }

    public void setHeaderLineNumber(int headerLineNumber) {
        CoreArgCheck.isPositive((int)headerLineNumber, (String)"header line number is less than zero");
        this.headerLineNumber = headerLineNumber;
        if (this.ignoreReload) {
            return;
        }
        if (this.delimitedColumns) {
            this.defineColumns();
        }
    }

    public int getFirstDataRow() {
        return this.firstDataRow;
    }

    public void setFirstDataRow(int firstDataRow) {
        CoreArgCheck.isPositive((int)firstDataRow, (String)"firstDataRow is not greater than zero");
        this.firstDataRow = firstDataRow;
        if (!this.includeSkip && this.firstDataRow > 0 && this.headerLineNumber > 0 && this.firstDataRow - this.headerLineNumber > 1) {
            this.setIncludeSkip(true);
        } else if (this.firstDataRow > 0 && this.headerLineNumber > 0 && this.firstDataRow - this.headerLineNumber <= 1) {
            this.setIncludeSkip(false);
        }
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        CoreArgCheck.isNotEmpty((String)delimiter, (String)"delimiter is null");
        if (delimiter.equals(this.delimiter)) {
            return;
        }
        this.delimiter = delimiter;
        if (this.ignoreReload) {
            return;
        }
        if (this.delimitedColumns) {
            this.defineColumns();
        }
    }

    public void setQuote(String quote) {
        CoreArgCheck.isNotEmpty((String)quote, (String)"quote is null");
        this.quote = quote;
    }

    public String getQuote() {
        return this.quote;
    }

    public void setEscape(String escape) {
        CoreArgCheck.isNotEmpty((String)escape, (String)"escape is null");
        this.escape = escape;
    }

    public String getEscape() {
        return this.escape;
    }

    public String getHeaderString() {
        if (this.cachedFirstLines.length == 0) {
            return null;
        }
        if (this.headerLineNumber <= this.cachedFirstLines.length) {
            return this.cachedFirstLines[this.headerLineNumber - 1];
        }
        return null;
    }

    private void loadHeader() {
        block26: {
            this.cachedFirstLines = new String[0];
            ArrayList<String> lines = new ArrayList<String>(7);
            if (this.getDataFile() != null && this.getDataFile().exists()) {
                FileInputStream stream = null;
                InputStreamReader reader = null;
                BufferedReader in = null;
                try {
                    try {
                        String str;
                        int iLines = 0;
                        stream = new FileInputStream(this.getDataFile());
                        reader = new InputStreamReader((InputStream)stream, this.charset);
                        in = new BufferedReader(reader);
                        while ((str = in.readLine()) != null) {
                            Collection<String> strings = this.getRowsFromLine(str);
                            if ((iLines += strings.size()) > this.numberOfCachedLines) continue;
                            lines.addAll(strings);
                        }
                        this.numberOfLinesInFile = iLines;
                        this.cachedFirstLines = lines.toArray(new String[0]);
                    }
                    catch (Exception e) {
                        Util.log(4, (Throwable)e, Util.getString(String.valueOf(I18N_PREFIX) + "problemLoadingFileContentsMessage", (Object)this.getDataFile().getName()));
                        try {
                            stream.close();
                        }
                        catch (IOException iOException) {}
                        try {
                            reader.close();
                        }
                        catch (IOException iOException) {}
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                        break block26;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (this.delimitedColumns) {
            this.defineColumns();
        }
        this.loaded = true;
    }

    private Collection<String> getRowsFromLine(String str) {
        ArrayList<String> strings = new ArrayList<String>();
        String theString = str;
        while (theString.length() > 0) {
            if (theString.indexOf("\\r\\n") > -1 || theString.indexOf("\\n") > -1) {
                int lengthLeft;
                int strLen;
                String seg;
                int lf_1_index = theString.indexOf("\\r\\n");
                int lf_2_index = theString.indexOf("\\n");
                if (lf_1_index > -1 && lf_2_index > lf_1_index) {
                    seg = theString.substring(0, lf_1_index);
                    strings.add(seg);
                    strLen = theString.length();
                    lengthLeft = strLen - 1 - (lf_1_index + 4);
                    if (lengthLeft > 0) {
                        theString = theString.substring(lf_1_index + 4, strLen).trim();
                        continue;
                    }
                    theString = "";
                    continue;
                }
                if (lf_2_index <= -1) continue;
                seg = theString.substring(0, lf_2_index);
                strings.add(seg);
                strLen = theString.length();
                lengthLeft = strLen - 1 - (lf_2_index + 2);
                if (lengthLeft <= 0) continue;
                theString = theString.substring(lf_2_index + 2, strLen).trim();
                continue;
            }
            strings.add(theString);
            theString = "";
        }
        return strings;
    }

    public String[] getCachedFirstLines() {
        if (!this.loaded) {
            this.loadHeader();
        }
        return this.cachedFirstLines;
    }

    private String getDataTypeString() {
        if (this.includeTypeLine) {
            if (this.cachedFirstLines.length == 0) {
                return null;
            }
            if (this.headerLineNumber <= this.cachedFirstLines.length) {
                return this.cachedFirstLines[this.headerLineNumber];
            }
        }
        return null;
    }

    public List<ITeiidColumnInfo> getColumnInfoList() {
        if (!this.loaded) {
            this.loadHeader();
        }
        return this.columnInfoList;
    }

    public void removeColumn(ITeiidColumnInfo theInfo) {
        this.columnInfoList.remove(theInfo);
        this.validate();
    }

    public void addColumn(TeiidColumnInfo theInfo) {
        this.columnInfoList.add(theInfo);
        this.validate();
    }

    public void clearColumns() {
        this.columnInfoList.clear();
    }

    private void defineColumns() {
        this.columnInfoList.clear();
        if (this.useHeaderForColumnNames && this.getHeaderString() != null && this.getHeaderString().length() > 0) {
            String dataTypeString;
            ArrayList<String> names = new ArrayList<String>();
            ArrayList<String> datatypes = new ArrayList<String>();
            String delim = this.getDelimiter();
            StringTokenizer strTokeniser = new StringTokenizer(this.getHeaderString(), delim);
            while (strTokeniser.hasMoreTokens()) {
                String nextTok = strTokeniser.nextToken().trim();
                if (nextTok.startsWith("'") || nextTok.startsWith("\"")) {
                    nextTok = nextTok.substring(1, nextTok.length() - 1);
                }
                if (nextTok == null || nextTok.length() <= 0) continue;
                names.add(nextTok);
            }
            if (this.includeTypeLine && (dataTypeString = this.getDataTypeString()) != null) {
                StringTokenizer tokenizer = new StringTokenizer(dataTypeString, delim);
                while (tokenizer.hasMoreTokens()) {
                    String nextTok = tokenizer.nextToken().trim();
                    if (nextTok == null || nextTok.length() <= 0) continue;
                    datatypes.add(nextTok);
                }
            }
            int count = 0;
            for (String name : names) {
                TeiidColumnInfo colInfo = new TeiidColumnInfo(name);
                if (!datatypes.isEmpty() && datatypes.size() == names.size()) {
                    colInfo.setDatatype((String)datatypes.get(count++));
                }
                this.columnInfoList.add(colInfo);
            }
        }
        this.validate();
    }

    @Override
    public void validate() {
        String message;
        if (this.useHeaderForColumnNames && (this.getHeaderString() == null || this.getHeaderString().length() == 0)) {
            this.setStatus((IStatus)new Status(4, "org.teiid.designer.transformation.ui", TeiidMetadataFileInfo.getString("status.noHeaderFound")));
            return;
        }
        if (this.columnInfoList.size() == 1 && (message = validator.checkValidName(this.columnInfoList.iterator().next().getSymbolName())) != null) {
            this.setStatus((IStatus)new Status(4, "org.teiid.designer.transformation.ui", TeiidMetadataFileInfo.getString("status.noHeaderFound")));
            return;
        }
        if (this.includeHeader && this.firstDataRow > 0 && this.firstDataRow <= this.headerLineNumber) {
            this.setStatus((IStatus)new Status(4, "org.teiid.designer.transformation.ui", Util.getString(String.valueOf(I18N_PREFIX) + "status.skippedLinesNotGreaterThanHeader", new Object[]{this.firstDataRow, this.headerLineNumber})));
            return;
        }
        this.setStatus(Status.OK_STATUS);
    }

    public void setDoProcess(boolean doProcess) {
        this.doProcess = doProcess;
    }

    public boolean doProcess() {
        return this.doProcess;
    }

    public void setIncludeHeader(boolean includeHeader) {
        this.includeHeader = includeHeader;
    }

    public boolean doIncludeHeader() {
        return this.includeHeader;
    }

    public void setIncludeSkip(boolean includeSkip) {
        this.includeSkip = includeSkip;
    }

    public boolean doIncludeSkip() {
        return this.includeSkip;
    }

    public void setIncludeEscape(boolean includeEscape) {
        if (this.delimitedColumns) {
            this.includeEscape = includeEscape;
            if (this.includeEscape && this.includeQuote) {
                this.includeQuote = false;
            }
        } else {
            this.includeEscape = false;
        }
    }

    public boolean doIncludeEscape() {
        return this.includeEscape;
    }

    public void setIncludeQuote(boolean includeQuote) {
        if (this.delimitedColumns) {
            this.includeQuote = includeQuote;
            if (this.includeQuote && this.includeEscape) {
                this.includeEscape = false;
            }
        } else {
            this.includeQuote = false;
        }
    }

    public boolean doIncludeQuote() {
        return this.includeQuote;
    }

    public void setIncludeNoTrim(boolean includeNoTrim) {
        this.includeNoTrim = includeNoTrim;
    }

    public boolean doIncludeNoTrim() {
        return this.includeNoTrim;
    }

    public void setDoUseHeaderForColumnNames(boolean useHeaderForColumnNames) {
        this.useHeaderForColumnNames = useHeaderForColumnNames;
    }

    public boolean doUseHeaderForColumnNames() {
        return this.useHeaderForColumnNames;
    }

    public void setFixedWidthColumns(boolean fixedWidthColumns) {
        this.fixedWidthColumns = fixedWidthColumns;
        boolean bl = this.delimitedColumns = !fixedWidthColumns;
        if (fixedWidthColumns) {
            this.includeHeader = false;
            this.useHeaderForColumnNames = false;
        }
    }

    public boolean isFixedWidthColumns() {
        return this.fixedWidthColumns;
    }

    public void setNumberOfFixedWidthColumns(int numberOfFixedWidthColumns) {
        this.numberOfFixedWidthColumns = numberOfFixedWidthColumns;
        if (this.ignoreReload) {
            return;
        }
        if (this.delimitedColumns) {
            this.defineColumns();
        }
    }

    public int getNumberOfFixedWidthColumns() {
        return this.numberOfFixedWidthColumns;
    }

    public void setUseDelimitedColumns(boolean delimitedColumns) {
        boolean oldValue = this.delimitedColumns;
        if (oldValue != delimitedColumns) {
            this.delimitedColumns = delimitedColumns;
            this.useHeaderForColumnNames = !delimitedColumns;
            this.fixedWidthColumns = !delimitedColumns;
        }
    }

    public boolean doUseDelimitedColumns() {
        return this.delimitedColumns;
    }

    public void setNumberOfCachedFileLines(int nLines) {
        this.numberOfCachedLines = nLines;
        this.loadHeader();
    }

    public int getNumberOfCachedFileLines() {
        return this.numberOfCachedLines;
    }

    public int getNumberOfLinesInFile() {
        return this.numberOfLinesInFile;
    }

    public void moveColumnUp(TeiidColumnInfo columnInfo) {
        int startIndex = this.getColumnIndex(columnInfo);
        if (startIndex > 0) {
            ITeiidColumnInfo priorInfo = this.getColumnInfoList().get(startIndex - 1);
            ITeiidColumnInfo[] infos = this.getColumnInfoList().toArray(new ITeiidColumnInfo[0]);
            infos[startIndex - 1] = columnInfo;
            infos[startIndex] = priorInfo;
            ArrayList<ITeiidColumnInfo> colInfos = new ArrayList<ITeiidColumnInfo>(infos.length);
            ITeiidColumnInfo[] iTeiidColumnInfoArray = infos;
            int n = infos.length;
            int n2 = 0;
            while (n2 < n) {
                ITeiidColumnInfo info = iTeiidColumnInfoArray[n2];
                colInfos.add(info);
                ++n2;
            }
            this.columnInfoList = colInfos;
        }
    }

    public void moveColumnDown(TeiidColumnInfo columnInfo) {
        int startIndex = this.getColumnIndex(columnInfo);
        if (startIndex < this.getColumnInfoList().size() - 1) {
            ITeiidColumnInfo afterInfo = this.getColumnInfoList().get(startIndex + 1);
            ITeiidColumnInfo[] infos = this.getColumnInfoList().toArray(new ITeiidColumnInfo[0]);
            infos[startIndex + 1] = columnInfo;
            infos[startIndex] = afterInfo;
            ArrayList<ITeiidColumnInfo> colInfos = new ArrayList<ITeiidColumnInfo>(infos.length);
            ITeiidColumnInfo[] iTeiidColumnInfoArray = infos;
            int n = infos.length;
            int n2 = 0;
            while (n2 < n) {
                ITeiidColumnInfo info = iTeiidColumnInfoArray[n2];
                colInfos.add(info);
                ++n2;
            }
            this.columnInfoList = colInfos;
        }
    }

    public boolean canMoveUp(ITeiidColumnInfo columnInfo) {
        return this.getColumnIndex(columnInfo) > 0;
    }

    public boolean canMoveDown(ITeiidColumnInfo columnInfo) {
        return this.getColumnIndex(columnInfo) < this.getColumnInfoList().size() - 1;
    }

    private int getColumnIndex(ITeiidColumnInfo columnInfo) {
        int i = 0;
        for (ITeiidColumnInfo colInfo : this.getColumnInfoList()) {
            if (colInfo == columnInfo) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public String toString() {
        StringBuilder text = new StringBuilder();
        text.append("Teiid Metadata File Info: ");
        text.append("file name = ").append(this.getDataFile().getName());
        text.append(", delimiter = ").append(this.getDelimiter());
        text.append(", header line # = ").append(this.getHeaderLineNumber());
        text.append(", view table name = ").append(this.getViewTableName());
        return text.toString();
    }

    public String[] parseRow(String rowString) {
        ArrayList<String> values = new ArrayList<String>();
        String leftOver = rowString;
        if (this.fixedWidthColumns) {
            for (ITeiidColumnInfo columnInfo : this.getColumnInfoList()) {
                int width = columnInfo.getWidth();
                if (leftOver.length() >= width) {
                    String value = leftOver.substring(0, width - 1);
                    values.add(value);
                    leftOver = leftOver.substring(width);
                    continue;
                }
                if (leftOver.length() <= 0) break;
                values.add(leftOver);
                break;
            }
        } else {
            String delim = this.getDelimiter();
            char theDelim = this.getDelimiter().charAt(0);
            StringBuilder sb = new StringBuilder();
            int maxChar = rowString.length();
            char[] chars = rowString.toCharArray();
            int i = 0;
            while (i < maxChar) {
                sb.append(chars[i]);
                if (chars[i] == theDelim && chars[i + 1] == theDelim) {
                    sb.append(" ");
                }
                ++i;
            }
            StringTokenizer strTokeniser = new StringTokenizer(sb.toString(), delim);
            while (strTokeniser.hasMoreTokens()) {
                String value = strTokeniser.nextToken().trim();
                if (value.startsWith(this.getQuote())) {
                    value = value.substring(1, value.length() - 1);
                }
                values.add(value);
            }
        }
        return values.toArray(new String[values.size()]);
    }

    public String getSqlStringTemplate() {
        return this.getSqlString("myRelModel");
    }

    public String getSqlString(String relationalModelName) {
        IQueryService queryService = ModelerCore.getTeiidQueryService();
        IProcedureService procedureService = queryService.getProcedureService();
        return procedureService.getSQLStatement((ITeiidMetadataFileInfo)this, relationalModelName);
    }

    public String getCharset() {
        return this.charset;
    }

    public void setIsUrl(boolean value) {
        this.isUrl = value;
    }

    public boolean isUrl() {
        return this.isUrl;
    }

    public void setFileUrl(String theUrlValue) {
        this.fileUrl = theUrlValue;
    }

    public String getFileUrl() {
        return this.fileUrl;
    }

    public void setCharSet(String theCharSet) {
        this.charSet = theCharSet;
    }

    public String getCharSet() {
        return this.charSet;
    }

    public boolean getIncludeTypeLine() {
        return this.includeTypeLine;
    }

    public void setIncludeTypeLine(boolean value) {
        this.includeTypeLine = value;
        if (value) {
            this.firstDataRow = 3;
        }
        this.setIncludeSkip(value);
    }
}

