/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.wizards.file;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.core.designer.util.StringUtilities;
import org.teiid.designer.datatools.connection.DataSourceConnectionHelper;
import org.teiid.designer.transformation.ui.UiConstants;
import org.teiid.designer.transformation.ui.wizards.file.TeiidFlatFileImportOptionsPage;
import org.teiid.designer.transformation.ui.wizards.file.TeiidMetadataImportInfo;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.widget.DefaultScrolledComposite;
import org.teiid.designer.ui.common.widget.Label;
import org.teiid.designer.ui.common.wizard.AbstractWizardPage;

public class TeiidMetadataImportDataSourcePage
extends AbstractWizardPage
implements UiConstants {
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix(TeiidMetadataImportDataSourcePage.class);
    private static final String TITLE = TeiidMetadataImportDataSourcePage.getString("title");
    private final TeiidMetadataImportInfo info;
    private Text jndiNameField;
    private String jndiName;
    private Button autoCreateDataSource;
    private boolean synchronizing;

    private static String getString(String id) {
        return Util.getString(String.valueOf(I18N_PREFIX) + id, new Object[0]);
    }

    private static String getString(String id, Object var) {
        return Util.getString(String.valueOf(I18N_PREFIX) + id, var);
    }

    public TeiidMetadataImportDataSourcePage(TeiidMetadataImportInfo fileInfo) {
        super(TeiidFlatFileImportOptionsPage.class.getSimpleName(), TITLE);
        this.info = fileInfo;
    }

    public void createControl(Composite parent) {
        Composite hostPanel = new Composite(parent, 0);
        hostPanel.setLayout((Layout)new GridLayout(1, false));
        hostPanel.setLayoutData((Object)new GridData(1808));
        DefaultScrolledComposite scrolledComposite = new DefaultScrolledComposite(hostPanel);
        hostPanel.setLayout((Layout)new GridLayout(1, false));
        hostPanel.setLayoutData((Object)new GridData(1808));
        Composite mainPanel = scrolledComposite.getPanel();
        mainPanel.setLayoutData((Object)new GridData(1808));
        mainPanel.setLayout((Layout)new GridLayout(1, false));
        Group theGroup = WidgetFactory.createGroup((Composite)mainPanel, (String)TeiidMetadataImportDataSourcePage.getString("jndiGroup"), (int)0, (int)2, (int)3);
        theGroup.setLayoutData((Object)new GridData(768));
        ((GridLayout)theGroup.getLayout()).marginLeft = 10;
        ((GridLayout)theGroup.getLayout()).marginRight = 10;
        Label label = WidgetFactory.createLabel((Composite)theGroup, (String)TeiidMetadataImportDataSourcePage.getString("jndiLabel"));
        label.setToolTipText(TeiidMetadataImportDataSourcePage.getString("jndiToolTip"));
        boolean serverDefined = DataSourceConnectionHelper.isServerDefined();
        boolean serverActive = DataSourceConnectionHelper.isServerConnected();
        this.jndiNameField = WidgetFactory.createTextField((Composite)theGroup);
        this.jndiNameField.setToolTipText(TeiidMetadataImportDataSourcePage.getString("jndiToolTip"));
        this.jndiName = this.info.getJBossJndiName();
        if (this.jndiName != null && this.jndiName.length() > 0) {
            this.jndiNameField.setText(this.jndiName);
        }
        this.jndiNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (TeiidMetadataImportDataSourcePage.this.synchronizing) {
                    return;
                }
                if (TeiidMetadataImportDataSourcePage.this.jndiNameField.getText() != null && TeiidMetadataImportDataSourcePage.this.jndiNameField.getText().length() > 0) {
                    TeiidMetadataImportDataSourcePage.this.jndiName = TeiidMetadataImportDataSourcePage.this.jndiNameField.getText();
                    TeiidMetadataImportDataSourcePage.this.info.setJBossJndiNameName(TeiidMetadataImportDataSourcePage.this.jndiName);
                } else {
                    TeiidMetadataImportDataSourcePage.this.jndiName = "";
                    TeiidMetadataImportDataSourcePage.this.info.setJBossJndiNameName(null);
                }
            }
        });
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.jndiNameField);
        this.autoCreateDataSource = WidgetFactory.createCheckBox((Composite)theGroup, (String)"Auto-create Data Source");
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo((Control)this.autoCreateDataSource);
        this.autoCreateDataSource.setSelection(this.info.doCreateDataSource());
        if (serverActive) {
            this.autoCreateDataSource.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    TeiidMetadataImportDataSourcePage.this.info.setCreateDataSource(TeiidMetadataImportDataSourcePage.this.autoCreateDataSource.getSelection());
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
        this.autoCreateDataSource.setEnabled(serverActive);
        if (!serverActive) {
            Group serverMessageGroup = WidgetFactory.createGroup((Composite)theGroup, (String)TeiidMetadataImportDataSourcePage.getString("serverUnavailableGroup"), (int)0, (int)2, (int)3);
            serverMessageGroup.setLayoutData((Object)new GridData(768));
            Text msgText = new Text((Composite)serverMessageGroup, 72);
            msgText.setBackground(Display.getCurrent().getSystemColor(19));
            msgText.setForeground(Display.getCurrent().getSystemColor(10));
            GridDataFactory.fillDefaults().span(2, 1).grab(true, false).hint(0, 55).applyTo((Control)serverMessageGroup);
            if (!serverDefined) {
                msgText.setText(TeiidMetadataImportDataSourcePage.getString("noServerDefined"));
            } else {
                msgText.setText(TeiidMetadataImportDataSourcePage.getString("serverNotStarted"));
            }
        }
        scrolledComposite.sizeScrolledPanel();
        this.setControl((Control)hostPanel);
        this.setMessage(TeiidMetadataImportDataSourcePage.getString("initialMessage"));
        this.setPageComplete(true);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.synchronizeUI();
        }
    }

    void synchronizeUI() {
        this.synchronizing = true;
        if (this.info.getJBossJndiName() != null) {
            this.jndiNameField.setText(this.info.getJBossJndiName());
        } else if (this.info.getSourceModelName() != null) {
            this.jndiName = String.valueOf(StringUtilities.removeXmiExtension((String)this.info.getSourceModelName())) + "_DS";
            this.info.setJBossJndiNameName(this.jndiName);
            this.jndiNameField.setText(this.info.getJBossJndiName());
        } else {
            this.jndiNameField.setText("");
        }
        this.synchronizing = false;
    }
}

