/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.wizards.file;

import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.transformation.ui.UiConstants;
import org.teiid.designer.transformation.ui.UiPlugin;
import org.teiid.designer.transformation.ui.wizards.file.TeiidMetadataFileInfo;
import org.teiid.designer.transformation.ui.wizards.file.TeiidMetadataImportInfo;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.util.WizardUtil;
import org.teiid.designer.ui.common.widget.DefaultScrolledComposite;
import org.teiid.designer.ui.common.wizard.AbstractWizardPage;

public class TeiidMetadataImportFormatPage
extends AbstractWizardPage
implements UiConstants {
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix(TeiidMetadataImportFormatPage.class);
    private static final String TITLE = TeiidMetadataImportFormatPage.getString("title");
    private static final String INITIAL_MESSAGE = TeiidMetadataImportFormatPage.getString("initialMessage");
    private final String EMPTY = "";
    private final int GROUP_HEIGHT_190 = 190;
    private TeiidMetadataImportInfo info;
    private TeiidMetadataFileInfo dataFileInfo;
    Text selectedFileText;
    Text numberPreviewLinesText;
    Text numberLinesInFileText;
    ListViewer fileContentsViewer;
    Button delimitedColumnsRB;
    Button fixedWidthColumnsRB;
    boolean creatingControl = false;
    boolean synchronizing = false;

    private static String getString(String id) {
        return Util.getString(String.valueOf(I18N_PREFIX) + id, new Object[0]);
    }

    private static String getString(String id, Object param) {
        return Util.getString(String.valueOf(I18N_PREFIX) + id, param);
    }

    public TeiidMetadataImportFormatPage(TeiidMetadataImportInfo info) {
        super(TeiidMetadataImportFormatPage.class.getSimpleName(), TITLE);
        CoreArgCheck.isNotNull((Object)info, (String)"info");
        this.info = info;
        this.setImageDescriptor(UiPlugin.getDefault().getImageDescriptor("icons/full/wizban/importTeiidMetadataWiz.gif"));
    }

    public void createControl(Composite parent) {
        this.creatingControl = true;
        Composite hostPanel = new Composite(parent, 0);
        hostPanel.setLayout((Layout)new GridLayout(1, false));
        hostPanel.setLayoutData((Object)new GridData(1808));
        DefaultScrolledComposite scrolledComposite = new DefaultScrolledComposite(hostPanel);
        hostPanel.setLayout((Layout)new GridLayout(1, false));
        hostPanel.setLayoutData((Object)new GridData(1808));
        Composite mainPanel = scrolledComposite.getPanel();
        mainPanel.setLayoutData((Object)new GridData(1808));
        mainPanel.setLayout((Layout)new GridLayout(1, false));
        Composite upperPanel = WidgetFactory.createPanel((Composite)mainPanel, (int)0, (int)768, (int)2, (int)2);
        upperPanel.setLayout((Layout)new GridLayout(2, false));
        this.setMessage(INITIAL_MESSAGE);
        Label selectedFileLabel = new Label(upperPanel, 0);
        selectedFileLabel.setText(TeiidMetadataImportFormatPage.getString("selectedFile"));
        this.selectedFileText = new Text(upperPanel, 2048);
        this.selectedFileText.setBackground(Display.getCurrent().getSystemColor(19));
        this.selectedFileText.setForeground(Display.getCurrent().getSystemColor(10));
        this.selectedFileText.setLayoutData((Object)new GridData(768));
        this.selectedFileText.setEditable(false);
        this.createFilePreviewOptionsGroup(mainPanel);
        this.createColumnOptionsRadioGroup(mainPanel);
        this.createFileContentsGroup(mainPanel);
        scrolledComposite.sizeScrolledPanel();
        this.setControl((Control)hostPanel);
        this.creatingControl = false;
        this.setPageComplete(false);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            TeiidMetadataFileInfo fileInfo = null;
            for (TeiidMetadataFileInfo theFileInfo : this.info.getFileInfos()) {
                if (!theFileInfo.doProcess()) continue;
                fileInfo = theFileInfo;
                break;
            }
            if (fileInfo != null) {
                this.dataFileInfo = fileInfo;
                this.loadFileContentsViewers();
            }
            this.synchronizeUI();
            this.validatePage();
        }
    }

    private boolean validatePage() {
        if (this.dataFileInfo == null) {
            return false;
        }
        if (!this.dataFileInfo.getStatus().isOK() && this.dataFileInfo.getStatus().getSeverity() != 2) {
            this.setThisPageComplete(this.dataFileInfo.getStatus().getMessage(), 4);
            return false;
        }
        this.setThisPageComplete("", 0);
        return true;
    }

    private void setThisPageComplete(String message, int severity) {
        WizardUtil.setPageComplete((WizardPage)this, (String)message, (int)severity);
    }

    private void synchronizeUI() {
        this.synchronizing = true;
        if (this.dataFileInfo == null) {
            return;
        }
        String charset = this.info.getFileInfo(this.dataFileInfo.getDataFile()).getCharset();
        if (!charset.equals(this.dataFileInfo.getCharset())) {
            this.dataFileInfo = this.info.getFileInfo(this.dataFileInfo.getDataFile());
            this.loadFileContentsViewers();
        }
        this.selectedFileText.setText(this.dataFileInfo.getDataFile().getName());
        boolean isDelimitedOption = this.dataFileInfo.doUseDelimitedColumns();
        String numLines = Integer.toString(this.dataFileInfo.getNumberOfCachedFileLines());
        if (!numLines.equals(this.numberPreviewLinesText.getText())) {
            this.numberPreviewLinesText.setText(numLines);
        }
        this.delimitedColumnsRB.setSelection(isDelimitedOption);
        this.fixedWidthColumnsRB.setSelection(!isDelimitedOption);
        this.numberLinesInFileText.setText(Integer.toString(this.dataFileInfo.getNumberOfLinesInFile()));
        this.synchronizing = false;
    }

    private void createColumnOptionsRadioGroup(Composite parent) {
        Group theGroup = WidgetFactory.createGroup((Composite)parent, (String)TeiidMetadataImportFormatPage.getString("columnsFormatGroup"), (int)0, (int)1, (int)2);
        theGroup.setLayoutData((Object)new GridData(768));
        this.delimitedColumnsRB = WidgetFactory.createRadioButton((Composite)theGroup, (String)TeiidMetadataImportFormatPage.getString("characterDelimited"));
        this.delimitedColumnsRB.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (!TeiidMetadataImportFormatPage.this.synchronizing && !TeiidMetadataImportFormatPage.this.creatingControl && event.getSource() == TeiidMetadataImportFormatPage.this.delimitedColumnsRB && TeiidMetadataImportFormatPage.this.delimitedColumnsRB.getSelection() != TeiidMetadataImportFormatPage.this.dataFileInfo.doUseDelimitedColumns()) {
                    boolean result;
                    TeiidMetadataImportFormatPage.this.dataFileInfo.setUseDelimitedColumns(TeiidMetadataImportFormatPage.this.delimitedColumnsRB.getSelection());
                    TeiidMetadataImportFormatPage.this.dataFileInfo.setFixedWidthColumns(!TeiidMetadataImportFormatPage.this.delimitedColumnsRB.getSelection());
                    if (TeiidMetadataImportFormatPage.this.dataFileInfo.getColumnInfoList().size() > 0 && (result = MessageDialog.openQuestion((Shell)TeiidMetadataImportFormatPage.this.getShell(), (String)TeiidMetadataImportFormatPage.getString("formatChangedTitle"), (String)TeiidMetadataImportFormatPage.getString("formateChangedMessage")))) {
                        TeiidMetadataImportFormatPage.this.dataFileInfo.clearColumns();
                    }
                    TeiidMetadataImportFormatPage.this.handleInfoChanged(false);
                }
            }
        });
        this.fixedWidthColumnsRB = WidgetFactory.createRadioButton((Composite)theGroup, (String)TeiidMetadataImportFormatPage.getString("fixedWidth"));
        this.fixedWidthColumnsRB.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (!TeiidMetadataImportFormatPage.this.synchronizing && !TeiidMetadataImportFormatPage.this.creatingControl && event.getSource() == TeiidMetadataImportFormatPage.this.fixedWidthColumnsRB && TeiidMetadataImportFormatPage.this.fixedWidthColumnsRB.getSelection() != TeiidMetadataImportFormatPage.this.dataFileInfo.isFixedWidthColumns()) {
                    boolean result;
                    TeiidMetadataImportFormatPage.this.dataFileInfo.setFixedWidthColumns(TeiidMetadataImportFormatPage.this.fixedWidthColumnsRB.getSelection());
                    TeiidMetadataImportFormatPage.this.dataFileInfo.setUseDelimitedColumns(!TeiidMetadataImportFormatPage.this.fixedWidthColumnsRB.getSelection());
                    if (TeiidMetadataImportFormatPage.this.dataFileInfo.getColumnInfoList().size() > 0 && (result = MessageDialog.openQuestion((Shell)TeiidMetadataImportFormatPage.this.getShell(), (String)TeiidMetadataImportFormatPage.getString("formatChangedTitle"), (String)TeiidMetadataImportFormatPage.getString("formateChangedMessage")))) {
                        TeiidMetadataImportFormatPage.this.dataFileInfo.clearColumns();
                    }
                    TeiidMetadataImportFormatPage.this.handleInfoChanged(false);
                }
            }
        });
        this.delimitedColumnsRB.setSelection(true);
    }

    private void createFilePreviewOptionsGroup(Composite parent) {
        Group theGroup = WidgetFactory.createGroup((Composite)parent, (String)TeiidMetadataImportFormatPage.getString("filePreviewOptionsGroup"), (int)0, (int)1, (int)5);
        theGroup.setLayoutData((Object)new GridData(768));
        Label numberLinesInFileLabel = new Label((Composite)theGroup, 0);
        numberLinesInFileLabel.setText(TeiidMetadataImportFormatPage.getString("numberOfLinesLabel"));
        this.numberLinesInFileText = WidgetFactory.createTextField((Composite)theGroup, (int)0);
        this.numberLinesInFileText.setEditable(false);
        this.numberLinesInFileText.setBackground(Display.getCurrent().getSystemColor(19));
        GridData gd = new GridData();
        gd.minimumWidth = 50;
        Label spacer = new Label((Composite)theGroup, 0);
        spacer.setText("                    ");
        Label prefixLabel = new Label((Composite)theGroup, 0);
        prefixLabel.setText(TeiidMetadataImportFormatPage.getString("numberOfPreviewLines"));
        prefixLabel.setLayoutData((Object)new GridData());
        this.numberPreviewLinesText = WidgetFactory.createTextField((Composite)theGroup, (int)0);
        gd = new GridData();
        gd.minimumWidth = 50;
        this.numberPreviewLinesText.setLayoutData((Object)gd);
        this.numberPreviewLinesText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                if (!TeiidMetadataImportFormatPage.this.synchronizing) {
                    if (!TeiidMetadataImportFormatPage.this.numberPreviewLinesText.getText().isEmpty()) {
                        try {
                            int nLines = Integer.parseInt(TeiidMetadataImportFormatPage.this.numberPreviewLinesText.getText());
                            if (nLines == 0) {
                                TeiidMetadataImportFormatPage.this.setErrorMessage(TeiidMetadataImportFormatPage.getString("numberOfLinesCannotBeNullOrZero"));
                                return;
                            }
                            if (nLines != TeiidMetadataImportFormatPage.this.dataFileInfo.getNumberOfCachedFileLines()) {
                                TeiidMetadataImportFormatPage.this.dataFileInfo.setNumberOfCachedFileLines(nLines);
                                TeiidMetadataImportFormatPage.this.handleInfoChanged(true);
                            }
                            TeiidMetadataImportFormatPage.this.setErrorMessage(null);
                        }
                        catch (NumberFormatException numberFormatException) {
                            TeiidMetadataImportFormatPage.this.setErrorMessage(TeiidMetadataImportFormatPage.getString("numberOfLinesMustBeInteger", TeiidMetadataImportFormatPage.this.numberPreviewLinesText.getText()));
                            return;
                        }
                    } else {
                        TeiidMetadataImportFormatPage.this.setErrorMessage(TeiidMetadataImportFormatPage.getString("numberOfLinesCannotBeNullOrZero"));
                        return;
                    }
                }
            }
        });
    }

    private void createFileContentsGroup(Composite parent) {
        Group theGroup = WidgetFactory.createGroup((Composite)parent, (String)TeiidMetadataImportFormatPage.getString("fileContentsGroup"), (int)0, (int)1, (int)4);
        GridData groupGD = new GridData(1808);
        groupGD.heightHint = 190;
        groupGD.widthHint = 400;
        theGroup.setLayoutData((Object)groupGD);
        this.fileContentsViewer = new ListViewer((Composite)theGroup, 2816);
        GridData data = new GridData(1808);
        data.horizontalSpan = 4;
        this.fileContentsViewer.getControl().setFont(JFaceResources.getTextFont());
        this.fileContentsViewer.getControl().setLayoutData((Object)data);
        if (this.dataFileInfo != null) {
            String[] stringArray = this.dataFileInfo.getCachedFirstLines();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String row = stringArray[n2];
                if (row != null) {
                    this.fileContentsViewer.add((Object)row);
                }
                ++n2;
            }
        }
        MenuManager columnMenuManager = new MenuManager();
        this.fileContentsViewer.getControl().setMenu(columnMenuManager.createContextMenu((Control)parent));
    }

    private void handleInfoChanged(boolean reloadFileContents) {
        if (this.synchronizing) {
            return;
        }
        this.synchronizeUI();
        if (reloadFileContents) {
            this.loadFileContentsViewers();
        }
        this.validatePage();
    }

    private void loadFileContentsViewers() {
        this.fileContentsViewer.getList().removeAll();
        String[] stringArray = this.dataFileInfo.getCachedFirstLines();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String row = stringArray[n2];
            if (row != null) {
                this.fileContentsViewer.add((Object)row);
            }
            ++n2;
        }
    }
}

