/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.wizards.file;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.query.proc.ITeiidMetadataFileInfo;
import org.teiid.designer.transformation.ui.UiConstants;
import org.teiid.designer.transformation.ui.wizards.file.TeiidMetadataFileInfo;
import org.teiid.designer.transformation.ui.wizards.xmlfile.TeiidXmlFileInfo;
import org.teiid.designer.ui.viewsupport.ModelNameUtil;

public class TeiidMetadataImportInfo
implements UiConstants {
    public static final int FILE_MODE_FLAT_FILE_LOCAL = 0;
    public static final int FILE_MODE_FLAT_FILE_URL = 1;
    public static final int FILE_MODE_TEIID_XML_FILE = 2;
    public static final int FILE_MODE_TEIID_XML_URL = 3;
    public static final int REST_MODE_URL = 4;
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix(TeiidMetadataImportInfo.class);
    private Map<File, TeiidMetadataFileInfo> fileInfoMap;
    private Map<File, TeiidXmlFileInfo> xmlFileInfoMap;
    private TeiidXmlFileInfo sourceXmlFileInfo;
    private IProject targetProject;
    private String sourceModelName;
    private IPath sourceModelLocation;
    private boolean sourceModelExists;
    private String viewModelName;
    private IPath viewModelLocation;
    private boolean viewModelExists;
    private IConnectionProfile connectionProfile;
    private String jbossJndiName;
    private boolean autoCreateDataSource = true;
    private IStatus status;
    private IStatus NO_FILES_STATUS;
    private int fileMode;
    private String fileFilterText;

    private static String getString(String id) {
        return Util.getString(String.valueOf(I18N_PREFIX) + id, new Object[0]);
    }

    public TeiidMetadataImportInfo() {
        this.initialize();
    }

    private void initialize() {
        this.fileInfoMap = new HashMap<File, TeiidMetadataFileInfo>();
        this.xmlFileInfoMap = new HashMap<File, TeiidXmlFileInfo>();
        this.status = this.NO_FILES_STATUS = new Status(4, "org.teiid.designer.transformation.ui", TeiidMetadataImportInfo.getString("noDataFilesInDataFolder"));
    }

    public String getSourceModelName() {
        return this.sourceModelName;
    }

    public void setSourceModelName(String sourceModelName) {
        this.sourceModelName = sourceModelName;
    }

    public IPath getSourceModelLocation() {
        return this.sourceModelLocation;
    }

    public void setSourceModelLocation(IPath location) {
        CoreArgCheck.isNotNull((Object)location, (String)"location is null");
        this.sourceModelLocation = location;
        this.validate();
    }

    public void setSourceModelExists(boolean sourceModelExists) {
        this.sourceModelExists = sourceModelExists;
    }

    public boolean sourceModelExists() {
        return this.sourceModelExists;
    }

    public String getViewModelName() {
        if (this.viewModelName != null && !this.viewModelName.toUpperCase().endsWith(".XMI")) {
            return String.valueOf(this.viewModelName) + ".xmi";
        }
        return this.viewModelName;
    }

    public void setViewModelName(String viewModelName) {
        this.viewModelName = viewModelName;
    }

    public IPath getViewModelLocation() {
        return this.viewModelLocation;
    }

    public String getJBossJndiName() {
        return this.jbossJndiName;
    }

    public void setJBossJndiNameName(String jndiName) {
        this.jbossJndiName = jndiName;
    }

    public boolean doCreateDataSource() {
        return this.autoCreateDataSource;
    }

    public void setCreateDataSource(boolean value) {
        this.autoCreateDataSource = value;
    }

    public void setViewModelLocation(IPath location) {
        CoreArgCheck.isNotNull((Object)location, (String)"location is null");
        this.viewModelLocation = location;
        this.validate();
    }

    public void setViewModelExists(boolean viewModelExists) {
        this.viewModelExists = viewModelExists;
    }

    public boolean viewModelExists() {
        return this.viewModelExists;
    }

    public void addFileInfo(TeiidMetadataFileInfo fileInfo) {
        this.fileInfoMap.put(fileInfo.getDataFile(), fileInfo);
        this.validate();
    }

    public TeiidMetadataFileInfo getFileInfo(File file) {
        return this.fileInfoMap.get(file);
    }

    public void addXmlFileInfo(TeiidXmlFileInfo fileInfo) {
        this.xmlFileInfoMap.put(fileInfo.getDataFile(), fileInfo);
        this.validate();
    }

    public TeiidXmlFileInfo getXmlFileInfo(File file) {
        return this.xmlFileInfoMap.get(file);
    }

    public void setSourceXmlFileInfo(TeiidXmlFileInfo fileInfo) {
        this.sourceXmlFileInfo = fileInfo;
        this.validate();
    }

    public TeiidXmlFileInfo getSourceXmlFileInfo() {
        return this.sourceXmlFileInfo;
    }

    public void setSourceXmlFileInfo() {
        for (TeiidXmlFileInfo fileInfo : this.getXmlFileInfos()) {
            if (!fileInfo.doProcess()) continue;
            this.setSourceXmlFileInfo(fileInfo);
            break;
        }
    }

    public void setDoProcess(File file, boolean doProcess) {
        TeiidMetadataFileInfo info2;
        for (TeiidMetadataFileInfo info2 : this.getFileInfos()) {
            info2.setDoProcess(false);
        }
        info2 = this.getFileInfo(file);
        if (info2 != null) {
            info2.setDoProcess(doProcess);
        }
        this.validate();
    }

    public void setDoProcessXml(File file, boolean doProcess) {
        TeiidXmlFileInfo info2;
        for (TeiidXmlFileInfo info2 : this.getXmlFileInfos()) {
            info2.setDoProcess(false);
        }
        info2 = this.getXmlFileInfo(file);
        if (info2 != null) {
            info2.setDoProcess(doProcess);
            if (doProcess) {
                String initialName;
                if (this.getSourceModelName() == null) {
                    initialName = "SourceModel";
                    if (this.getSourceModelLocation() != null) {
                        initialName = ModelNameUtil.getNewUniqueModelName((String)initialName, (IContainer)this.getTargetProject());
                    }
                    this.setSourceModelName(initialName);
                }
                if (this.getViewModelName() == null) {
                    initialName = "ViewModel";
                    if (this.getViewModelLocation() != null) {
                        initialName = ModelNameUtil.getNewUniqueModelName((String)initialName, (IContainer)this.getTargetProject());
                    }
                    this.setViewModelName(initialName);
                }
            }
        }
        this.validate();
    }

    public IProject getTargetProject() {
        return this.targetProject;
    }

    public boolean setTargetProject(IProject project) {
        if (this.targetProject != null && this.targetProject == project) {
            return false;
        }
        this.targetProject = project;
        if (this.targetProject != null) {
            this.setViewModelLocation((IPath)new Path(this.targetProject.getName()));
            this.setSourceModelLocation((IPath)new Path(this.targetProject.getName()));
        }
        return true;
    }

    public TeiidMetadataFileInfo getCheckedFileInfo() {
        for (TeiidMetadataFileInfo info : this.getFileInfos()) {
            if (!info.doProcess()) continue;
            return info;
        }
        return null;
    }

    public IConnectionProfile getConnectionProfile() {
        return this.connectionProfile;
    }

    public void setConnectionProfile(IConnectionProfile connectionProfile) {
        this.connectionProfile = connectionProfile;
    }

    public IStatus getStatus() {
        return this.status;
    }

    public void setStatus(IStatus status) {
        this.status = status;
    }

    public Collection<TeiidMetadataFileInfo> getFileInfos() {
        return this.fileInfoMap.values();
    }

    public Collection<TeiidXmlFileInfo> getXmlFileInfos() {
        return this.xmlFileInfoMap.values();
    }

    public void clearFileInfos() {
        this.fileInfoMap.clear();
    }

    public void clearXmlFileInfos() {
        this.xmlFileInfoMap.clear();
    }

    public void validate() {
        this.setStatus(Status.OK_STATUS);
        if (this.isFlatFileLocalMode() || this.isFlatFileUrlMode()) {
            if (this.fileInfoMap.isEmpty()) {
                this.setStatus((IStatus)new Status(4, "org.teiid.designer.transformation.ui", TeiidMetadataImportInfo.getString("noDataFilesFound")));
                return;
            }
            boolean noneProcessed = true;
            for (ITeiidMetadataFileInfo iTeiidMetadataFileInfo : this.fileInfoMap.values()) {
                if (!iTeiidMetadataFileInfo.doProcess()) continue;
                noneProcessed = false;
            }
            if (noneProcessed) {
                this.setStatus((IStatus)new Status(4, "org.teiid.designer.transformation.ui", TeiidMetadataImportInfo.getString("noDataFilesSelected")));
                return;
            }
            for (TeiidMetadataFileInfo teiidMetadataFileInfo : this.fileInfoMap.values()) {
                if (!teiidMetadataFileInfo.doProcess() || teiidMetadataFileInfo.getStatus().getSeverity() <= 2) continue;
                this.setStatus((IStatus)new Status(4, "org.teiid.designer.transformation.ui", Util.getString(String.valueOf(I18N_PREFIX) + "errorInImportConfiguration", (Object)teiidMetadataFileInfo.getDataFile().getName())));
                return;
            }
            this.setStatus(Status.OK_STATUS);
        } else {
            if (this.xmlFileInfoMap.isEmpty()) {
                this.setStatus((IStatus)new Status(4, "org.teiid.designer.transformation.ui", TeiidMetadataImportInfo.getString("noXmlDataFilesFound")));
                return;
            }
            boolean noneProcessed = true;
            for (TeiidXmlFileInfo teiidXmlFileInfo : this.xmlFileInfoMap.values()) {
                if (!teiidXmlFileInfo.doProcess()) continue;
                noneProcessed = false;
            }
            if (noneProcessed) {
                this.setStatus((IStatus)new Status(4, "org.teiid.designer.transformation.ui", TeiidMetadataImportInfo.getString("noXmlDataFilesSelected")));
                return;
            }
            for (TeiidXmlFileInfo teiidXmlFileInfo : this.xmlFileInfoMap.values()) {
                if (!teiidXmlFileInfo.doProcess() || teiidXmlFileInfo.getStatus().getSeverity() <= 2) continue;
                this.setStatus((IStatus)new Status(4, "org.teiid.designer.transformation.ui", Util.getString(String.valueOf(I18N_PREFIX) + "errorInXmlImportConfiguration", (Object)teiidXmlFileInfo.getDataFile().getName())));
                return;
            }
            this.setStatus(Status.OK_STATUS);
        }
        if (this.getStatus().isOK() && this.viewModelLocation != null && this.sourceModelLocation != null && this.viewModelLocation.segmentCount() > 0 && this.sourceModelLocation.segmentCount() > 0 && !this.viewModelLocation.segment(0).equals(this.sourceModelLocation.segment(0))) {
            this.setStatus((IStatus)new Status(4, "org.teiid.designer.transformation.ui", Util.getString(String.valueOf(I18N_PREFIX) + "errorFileLocationsInDifferentProjects", new Object[0])));
        }
    }

    public boolean isFlatFileLocalMode() {
        return this.fileMode == 0;
    }

    public boolean isFlatFileUrlMode() {
        return this.fileMode == 1;
    }

    public boolean isXmlLocalFileMode() {
        return this.fileMode == 2;
    }

    public boolean isXmlUrlFileMode() {
        return this.fileMode == 3;
    }

    public boolean isRestUrlFileMode() {
        return this.fileMode == 4;
    }

    public void setFileMode(int mode) {
        this.fileMode = mode;
    }

    public int getFileMode() {
        return this.fileMode;
    }

    public void setFileFilterText(String filterText) {
        this.fileFilterText = filterText;
    }

    public String getFileFilterText() {
        return this.fileFilterText;
    }

    public String toString() {
        StringBuilder text = new StringBuilder();
        text.append("Teiid Metadata Import Info: ");
        text.append(" connection profile = ").append(this.getConnectionProfile().getName());
        text.append(", source model = ").append(this.getSourceModelName());
        text.append(", source model location = ").append(this.getViewModelLocation().toString());
        text.append(", view model = ").append(this.getViewModelName());
        text.append(", view model location= ").append(this.getSourceModelLocation().toString());
        return text.toString();
    }
}

