/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.wizards.file;

import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.core.designer.util.StringUtilities;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.core.workspace.ModelWorkspaceItem;
import org.teiid.designer.core.workspace.ModelWorkspaceManager;
import org.teiid.designer.datatools.connection.ConnectionInfoHelper;
import org.teiid.designer.datatools.connection.DataSourceConnectionHelper;
import org.teiid.designer.datatools.profiles.flatfile.FlatFileConnectionInfoProvider;
import org.teiid.designer.datatools.profiles.flatfile.FlatFileUrlConnectionInfoProvider;
import org.teiid.designer.datatools.profiles.ws.WSConnectionInfoProvider;
import org.teiid.designer.datatools.ui.DatatoolsUiConstants;
import org.teiid.designer.runtime.spi.ITeiidServer;
import org.teiid.designer.transformation.ui.UiConstants;
import org.teiid.designer.transformation.ui.wizards.file.FlatFileRelationalModelFactory;
import org.teiid.designer.transformation.ui.wizards.file.FlatFileViewModelFactory;
import org.teiid.designer.transformation.ui.wizards.file.TeiidMetadataFileInfo;
import org.teiid.designer.transformation.ui.wizards.file.TeiidMetadataImportInfo;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.editors.ModelEditor;
import org.teiid.designer.ui.editors.ModelEditorManager;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class TeiidMetadataImportProcessor
implements UiConstants {
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix(TeiidMetadataImportProcessor.class);
    protected static final String DEFAULT_EXTENSION_LCASE = ".xmi";
    protected static String FILE_DS_TYPE = "file";
    protected static String WS_DS_TYPE = "webservice";
    TeiidMetadataImportInfo info;
    ModelResource sourceModel;
    ModelResource viewModel;
    IStatus createStatus;
    Shell shell;

    private static String getString(String id) {
        return Util.getString(String.valueOf(I18N_PREFIX) + id, new Object[0]);
    }

    private static String getString(String id, Object param) {
        return Util.getString(String.valueOf(I18N_PREFIX) + id, param);
    }

    public TeiidMetadataImportProcessor(TeiidMetadataImportInfo info, Shell shell) {
        this.info = info;
        this.shell = shell;
        this.createStatus = Status.OK_STATUS;
    }

    public IStatus execute() {
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor theMonitor) {
                theMonitor.beginTask(TeiidMetadataImportProcessor.getString("task.creatingSourceModel", TeiidMetadataImportProcessor.this.info.getSourceModelName()), 100);
                if (TeiidMetadataImportProcessor.this.info.sourceModelExists()) {
                    TeiidMetadataImportProcessor.this.createStatus = TeiidMetadataImportProcessor.this.createProceduresInExistingSourceModelInTxn(theMonitor);
                } else {
                    TeiidMetadataImportProcessor.this.createStatus = TeiidMetadataImportProcessor.this.createSourceModelInTxn(theMonitor);
                    if (TeiidMetadataImportProcessor.this.createStatus.isOK()) {
                        TeiidMetadataImportProcessor.this.createStatus = TeiidMetadataImportProcessor.this.createProceduresInExistingSourceModelInTxn(theMonitor);
                    }
                }
                TeiidMetadataImportProcessor.this.createStatus = TeiidMetadataImportProcessor.this.info.viewModelExists() ? TeiidMetadataImportProcessor.this.createViewsInExistingModelInTxn(theMonitor) : TeiidMetadataImportProcessor.this.createViewModelInTxn(theMonitor);
                theMonitor.worked(50);
                if (TeiidMetadataImportProcessor.this.createStatus.isOK()) {
                    TeiidMetadataImportProcessor.this.handleCreateDataSource();
                }
                theMonitor.done();
            }
        };
        try {
            new ProgressMonitorDialog(this.shell).run(false, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException e) {
            UiConstants.Util.log(e.getTargetException());
        }
        catch (Exception err) {
            Throwable t = err;
            if (err instanceof InvocationTargetException) {
                t = err.getCause();
            }
            WidgetUtil.showError((Throwable)t);
        }
        return this.createStatus;
    }

    private IStatus createSourceModelInTxn(IProgressMonitor monitor) {
        boolean requiredStart = ModelerCore.startTxn((boolean)true, (boolean)true, (String)"Import Teiid Metadata Create Source Model", (Object)this);
        boolean succeeded = false;
        try {
            try {
                this.sourceModel = this.createRelationalFileSourceModel();
                monitor.worked(10);
                if (this.info.getConnectionProfile() != null) {
                    this.addConnectionProfileInfoToModel(this.sourceModel, this.info);
                }
                monitor.subTask(TeiidMetadataImportProcessor.getString("task.savingSourceModel", this.sourceModel.getItemName()));
                try {
                    ModelUtilities.saveModelResource((ModelResource)this.sourceModel, (IProgressMonitor)monitor, (boolean)false, (Object)this);
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e);
                }
                monitor.worked(10);
                if (this.createStatus.isOK() && this.sourceModel != null) {
                    ModelEditorManager.openInEditMode((Object)this.sourceModel, (boolean)true, (int)0);
                }
                succeeded = true;
            }
            catch (Exception e) {
                Status status = new Status(4, "org.teiid.designer.transformation.ui", TeiidMetadataImportProcessor.getString("exceptionMessage_2", this.info.getSourceModelName()), (Throwable)e);
                UiConstants.Util.log((IStatus)status);
                MessageDialog.openError((Shell)this.shell, (String)TeiidMetadataImportProcessor.getString("exceptionMessage_2", this.info.getSourceModelName()), (String)e.getMessage());
                Status status2 = status;
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
                return status2;
            }
        }
        finally {
            if (requiredStart) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
        monitor.worked(10);
        if (this.createStatus.isOK() && this.sourceModel != null) {
            ModelEditorManager.openInEditMode((Object)this.sourceModel, (boolean)true, (int)0);
        }
        monitor.worked(10);
        return Status.OK_STATUS;
    }

    protected void addConnectionProfileInfoToModel(ModelResource sourceModel, TeiidMetadataImportInfo info) throws ModelWorkspaceException {
        if (info.getConnectionProfile() != null) {
            String jndiName;
            Object provider = null;
            if (this.getInfo().isFlatFileLocalMode()) {
                provider = new FlatFileConnectionInfoProvider();
            } else if (this.getInfo().isFlatFileUrlMode()) {
                provider = "org.teiid.designer.datatools.profiles.ws.WSConnectionProfile".equalsIgnoreCase(info.getConnectionProfile().getProviderId()) ? new WSConnectionInfoProvider() : new FlatFileUrlConnectionInfoProvider();
            }
            if (provider != null) {
                provider.setConnectionInfo(sourceModel, info.getConnectionProfile());
            }
            if (!StringUtilities.isEmpty((String)(jndiName = info.getJBossJndiName()))) {
                ConnectionInfoHelper helper = new ConnectionInfoHelper();
                helper.setJNDIName(sourceModel, jndiName);
            }
        }
    }

    private IStatus createViewsInExistingModelInTxn(IProgressMonitor monitor) {
        boolean requiredStart = ModelerCore.startTxn((boolean)true, (boolean)true, (String)"Import Teiid Metadata Create View Tables", (Object)this);
        boolean succeeded = false;
        try {
            try {
                monitor.subTask(String.valueOf(TeiidMetadataImportProcessor.getString("task.creatingViewTablesInViewModel")) + this.info.getViewModelName());
                this.viewModel = this.createViewsInExistingModel(this.sourceModel.getPath().removeFileExtension().lastSegment());
                monitor.worked(10);
                succeeded = true;
            }
            catch (Exception e) {
                Status status = new Status(4, "org.teiid.designer.transformation.ui", TeiidMetadataImportProcessor.getString("exceptionMessage_3", this.info.getViewModelName()), (Throwable)e);
                UiConstants.Util.log((IStatus)status);
                MessageDialog.openError((Shell)this.shell, (String)TeiidMetadataImportProcessor.getString("exceptionMessage_3", this.info.getViewModelName()), (String)e.getMessage());
                Status status2 = status;
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
                return status2;
            }
        }
        finally {
            if (requiredStart) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
        return Status.OK_STATUS;
    }

    private IStatus createViewModelInTxn(IProgressMonitor monitor) {
        ModelResource viewModel = null;
        boolean requiredStart = ModelerCore.startTxn((boolean)true, (boolean)true, (String)"Import Teiid Metadata Create View Model", (Object)this);
        boolean succeeded = false;
        try {
            try {
                monitor.subTask(String.valueOf(TeiidMetadataImportProcessor.getString("task.creatingViewTablesInNewViewModel")) + this.info.getViewModelName());
                viewModel = this.createViewsInNewModel(this.sourceModel.getPath().removeFileExtension().lastSegment());
                monitor.worked(40);
                if (this.createStatus.isOK() && this.sourceModel != null) {
                    try {
                        ModelUtilities.saveModelResource((ModelResource)viewModel, (IProgressMonitor)monitor, (boolean)false, (Object)this);
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                }
                monitor.worked(10);
                if (this.createStatus.isOK() && viewModel != null) {
                    ModelEditorManager.openInEditMode((Object)viewModel, (boolean)true, (int)0);
                }
                succeeded = true;
            }
            catch (Exception e) {
                Status status = new Status(4, "org.teiid.designer.transformation.ui", TeiidMetadataImportProcessor.getString("exceptionMessage_4", this.info.getViewModelName()), (Throwable)e);
                UiConstants.Util.log((IStatus)status);
                MessageDialog.openError((Shell)this.shell, (String)TeiidMetadataImportProcessor.getString("exceptionMessage_4", this.info.getViewModelName()), (String)e.getMessage());
                Status status2 = status;
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
                return status2;
            }
        }
        finally {
            if (requiredStart) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
        return Status.OK_STATUS;
    }

    protected ModelResource createViewsInExistingModel(String relationalModelName) throws ModelerCoreException {
        if (this.info.getViewModelLocation() != null && this.info.getViewModelName() != null) {
            IFile viewIFile = null;
            if (this.viewModel != null) {
                viewIFile = (IFile)this.viewModel.getCorrespondingResource();
            } else {
                IPath modelPath = this.info.getViewModelLocation().append(this.info.getViewModelName());
                if (!modelPath.toString().toUpperCase().endsWith(".XMI")) {
                    modelPath = modelPath.addFileExtension(DEFAULT_EXTENSION_LCASE);
                }
                ModelWorkspaceItem item = ModelWorkspaceManager.getModelWorkspaceManager().findModelWorkspaceItem(modelPath, 1);
                viewIFile = (IFile)item.getCorrespondingResource();
            }
            ModelEditor editor = ModelEditorManager.getModelEditorForFile((IFile)viewIFile, (boolean)true);
            if (editor != null) {
                boolean isDirty = editor.isDirty();
                FlatFileViewModelFactory factory = new FlatFileViewModelFactory();
                for (TeiidMetadataFileInfo info : this.info.getFileInfos()) {
                    if (!info.doProcess()) continue;
                    factory.createViewTable(editor.getModelResource(), info, relationalModelName);
                }
                editor.getModelResource().save(null, true);
                if (!isDirty && editor.isDirty()) {
                    editor.doSave((IProgressMonitor)new NullProgressMonitor());
                }
                return editor.getModelResource();
            }
        }
        return null;
    }

    private ModelResource createRelationalFileSourceModel() throws ModelerCoreException {
        FlatFileRelationalModelFactory factory = new FlatFileRelationalModelFactory();
        String modelName = this.info.getSourceModelName();
        if (!modelName.toLowerCase().endsWith(DEFAULT_EXTENSION_LCASE)) {
            modelName = String.valueOf(modelName) + DEFAULT_EXTENSION_LCASE;
        }
        return factory.createRelationalModel(this.info.getSourceModelLocation(), modelName);
    }

    protected ModelResource createViewsInNewModel(String sourceModelName) throws ModelerCoreException {
        FlatFileViewModelFactory factory = new FlatFileViewModelFactory();
        String modelName = this.info.getViewModelName();
        if (!modelName.toLowerCase().endsWith(DEFAULT_EXTENSION_LCASE)) {
            modelName = String.valueOf(modelName) + DEFAULT_EXTENSION_LCASE;
        }
        ModelResource modelResource = factory.createViewRelationalModel(this.info.getViewModelLocation(), modelName);
        for (TeiidMetadataFileInfo info : this.info.getFileInfos()) {
            if (!info.doProcess()) continue;
            factory.createViewTable(modelResource, info, sourceModelName);
        }
        return modelResource;
    }

    private IStatus createProceduresInExistingSourceModelInTxn(IProgressMonitor monitor) {
        boolean requiredStart = ModelerCore.startTxn((boolean)true, (boolean)true, (String)"Import Teiid Metadata Create View Tables", (Object)this);
        boolean succeeded = false;
        try {
            try {
                monitor.subTask(String.valueOf(TeiidMetadataImportProcessor.getString("task.creatingProceduresInSourceModel")) + this.info.getSourceModelName());
                this.sourceModel = this.addProcedureToRelationalSourceModel();
                monitor.worked(10);
                succeeded = true;
            }
            catch (Exception e) {
                Status status = new Status(4, "org.teiid.designer.transformation.ui", TeiidMetadataImportProcessor.getString("exceptionMessage_3", this.info.getViewModelName()), (Throwable)e);
                UiConstants.Util.log((IStatus)status);
                MessageDialog.openError((Shell)this.shell, (String)TeiidMetadataImportProcessor.getString("exceptionMessage_3", this.info.getViewModelName()), (String)e.getMessage());
                Status status2 = status;
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
                return status2;
            }
        }
        finally {
            if (requiredStart) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
        return Status.OK_STATUS;
    }

    protected ModelResource addProcedureToRelationalSourceModel() throws ModelerCoreException {
        if (this.info.getSourceModelLocation() != null && this.info.getSourceModelName() != null) {
            IFile sourceIFile = null;
            if (this.sourceModel != null) {
                sourceIFile = (IFile)this.sourceModel.getCorrespondingResource();
            } else {
                IPath modelPath = this.info.getSourceModelLocation().append(this.info.getSourceModelName());
                if (!modelPath.toString().toUpperCase().endsWith(".XMI")) {
                    modelPath = modelPath.addFileExtension("xmi");
                }
                ModelWorkspaceItem item = ModelWorkspaceManager.getModelWorkspaceManager().findModelWorkspaceItem(modelPath, 1);
                sourceIFile = (IFile)item.getCorrespondingResource();
            }
            ModelEditor editor = ModelEditorManager.getModelEditorForFile((IFile)sourceIFile, (boolean)true);
            if (editor != null) {
                ModelResource mr = editor.getModelResource();
                boolean isDirty = editor.isDirty();
                FlatFileRelationalModelFactory factory = new FlatFileRelationalModelFactory();
                if (this.info.isFlatFileLocalMode() || this.info.isXmlLocalFileMode()) {
                    factory.addMissingProcedure(mr, "getTextFiles");
                } else if (this.info.isFlatFileUrlMode()) {
                    factory.addMissingProcedure(mr, "invokeHttp");
                }
                mr.save(null, true);
                if (!isDirty && editor.isDirty()) {
                    editor.doSave((IProgressMonitor)new NullProgressMonitor());
                }
                return mr;
            }
        }
        return null;
    }

    protected void handleCreateDataSource() {
        if (this.info.doCreateDataSource() && DataSourceConnectionHelper.isServerConnected()) {
            ITeiidServer teiidServer = DataSourceConnectionHelper.getServer();
            String dsName = this.info.getJBossJndiName();
            String jndiName = this.info.getJBossJndiName();
            DataSourceConnectionHelper helper = new DataSourceConnectionHelper(this.sourceModel, this.info.getConnectionProfile());
            Properties connProps = helper.getModelConnectionProperties();
            String dsType = helper.getDataSourceType();
            try {
                teiidServer.getOrCreateDataSource(dsName, jndiName, dsType, connProps);
            }
            catch (Exception e) {
                DatatoolsUiConstants.UTIL.log((Throwable)e);
            }
        }
    }

    public TeiidMetadataImportInfo getInfo() {
        return this.info;
    }

    protected ModelResource getSourceModel() {
        return this.sourceModel;
    }
}

