/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.wizards.file;

import java.io.File;
import java.util.Iterator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.core.designer.util.StringUtilities;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.core.workspace.ModelWorkspaceItem;
import org.teiid.designer.core.workspace.ModelWorkspaceManager;
import org.teiid.designer.metamodels.relational.BaseTable;
import org.teiid.designer.metamodels.relational.aspects.validation.RelationalStringNameValidator;
import org.teiid.designer.transformation.ui.UiConstants;
import org.teiid.designer.transformation.ui.UiPlugin;
import org.teiid.designer.transformation.ui.wizards.file.TeiidFileInfo;
import org.teiid.designer.transformation.ui.wizards.file.TeiidMetadataFileInfo;
import org.teiid.designer.transformation.ui.wizards.file.TeiidMetadataImportInfo;
import org.teiid.designer.transformation.ui.wizards.xmlfile.TeiidXmlFileInfo;
import org.teiid.designer.ui.common.product.ProductCustomizerMgr;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.common.util.WizardUtil;
import org.teiid.designer.ui.common.widget.DefaultScrolledComposite;
import org.teiid.designer.ui.common.wizard.AbstractWizardPage;
import org.teiid.designer.ui.explorer.ModelExplorerContentProvider;
import org.teiid.designer.ui.explorer.ModelExplorerLabelProvider;
import org.teiid.designer.ui.viewsupport.ModelIdentifier;
import org.teiid.designer.ui.viewsupport.ModelNameUtil;
import org.teiid.designer.ui.viewsupport.ModelObjectUtilities;
import org.teiid.designer.ui.viewsupport.ModelProjectSelectionStatusValidator;
import org.teiid.designer.ui.viewsupport.ModelResourceSelectionValidator;
import org.teiid.designer.ui.viewsupport.ModelUtilities;
import org.teiid.designer.ui.viewsupport.ModelWorkspaceViewerFilter;
import org.teiid.designer.ui.viewsupport.ModelingResourceFilter;

public class TeiidMetadataImportViewModelPage
extends AbstractWizardPage
implements UiConstants {
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix(TeiidMetadataImportViewModelPage.class);
    private static final String TITLE = TeiidMetadataImportViewModelPage.getString("title");
    private static final String INITIAL_MESSAGE = TeiidMetadataImportViewModelPage.getString("initialMessage");
    private static final String DEFAULT_EXTENSION = ".xmi";
    RelationalStringNameValidator validator = new RelationalStringNameValidator(true);
    private Text viewModelContainerText;
    private Text viewModelFileText;
    private Text viewHelpText;
    private IPath viewModelFilePath;
    private Text viewTableNameText;
    private TeiidMetadataImportInfo info;
    Text selectedFileText;
    private TeiidFileInfo fileInfo;
    boolean creatingControl = false;
    boolean synchronizing = false;
    final ViewerFilter virtualModelFilter = new ModelWorkspaceViewerFilter(true){

        public boolean select(Viewer viewer, Object parent, Object element) {
            boolean doSelect = false;
            if (element instanceof IResource) {
                boolean projectOpen = ((IResource)element).getProject().isOpen();
                if (projectOpen) {
                    if (element instanceof IProject) {
                        try {
                            doSelect = ((IProject)element).hasNature("org.teiid.designer.core.modelNature");
                        }
                        catch (CoreException e) {
                            ModelerCore.Util.log((Throwable)e);
                        }
                    } else if (element instanceof IContainer) {
                        doSelect = true;
                    } else if (element instanceof IFile && ModelUtil.isModelFile((IResource)((IFile)element))) {
                        ModelResource theModel = null;
                        try {
                            theModel = ModelUtil.getModelResource((IFile)((IFile)element), (boolean)true);
                        }
                        catch (Exception ex) {
                            ModelerCore.Util.log((Throwable)ex);
                        }
                        if (theModel != null && ModelIdentifier.isRelationalViewModel((ModelResource)theModel)) {
                            doSelect = true;
                        }
                    }
                }
            } else if (element instanceof IContainer) {
                doSelect = true;
            }
            return doSelect;
        }
    };

    private static String getString(String id) {
        return Util.getString(String.valueOf(I18N_PREFIX) + id, new Object[0]);
    }

    private static String getString(String id, Object param) {
        return Util.getString(String.valueOf(I18N_PREFIX) + id, param);
    }

    public TeiidMetadataImportViewModelPage(TeiidMetadataImportInfo info) {
        super(TeiidMetadataImportViewModelPage.class.getSimpleName(), TITLE);
        CoreArgCheck.isNotNull((Object)info, (String)"info");
        this.info = info;
        this.setImageDescriptor(UiPlugin.getDefault().getImageDescriptor("icons/full/wizban/importTeiidMetadataWiz.gif"));
    }

    public void createControl(Composite parent) {
        this.creatingControl = true;
        Composite hostPanel = new Composite(parent, 0);
        hostPanel.setLayout((Layout)new GridLayout(1, false));
        hostPanel.setLayoutData((Object)new GridData(1808));
        DefaultScrolledComposite scrolledComposite = new DefaultScrolledComposite(hostPanel);
        hostPanel.setLayout((Layout)new GridLayout(1, false));
        hostPanel.setLayoutData((Object)new GridData(1808));
        Composite mainPanel = scrolledComposite.getPanel();
        mainPanel.setLayoutData((Object)new GridData(1808));
        mainPanel.setLayout((Layout)new GridLayout(1, false));
        this.setMessage(INITIAL_MESSAGE);
        Label selectedFileLabel = new Label(mainPanel, 0);
        selectedFileLabel.setText(TeiidMetadataImportViewModelPage.getString("selectedXmlFile"));
        this.selectedFileText = new Text(mainPanel, 2052);
        this.selectedFileText.setBackground(Display.getCurrent().getSystemColor(19));
        this.selectedFileText.setForeground(Display.getCurrent().getSystemColor(10));
        this.selectedFileText.setLayoutData((Object)new GridData(768));
        this.selectedFileText.setEditable(false);
        new Label(mainPanel, 0);
        new Label(mainPanel, 0);
        this.createViewModelGroup(mainPanel);
        this.setViewHelpMessage();
        scrolledComposite.sizeScrolledPanel();
        this.setControl((Control)mainPanel);
        this.creatingControl = false;
        this.setPageComplete(false);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            if (this.info.isFlatFileLocalMode() || this.info.isFlatFileUrlMode()) {
                for (TeiidMetadataFileInfo theFileInfo : this.info.getFileInfos()) {
                    if (!theFileInfo.doProcess()) continue;
                    this.fileInfo = theFileInfo;
                    break;
                }
            } else {
                for (TeiidXmlFileInfo xmlInfo : this.info.getXmlFileInfos()) {
                    if (!xmlInfo.doProcess()) continue;
                    this.fileInfo = xmlInfo;
                    break;
                }
            }
            this.synchronizeUI();
            this.setViewHelpMessage();
            this.validatePage();
        }
    }

    private void createViewModelGroup(Composite parent) {
        Group viewGroup = WidgetFactory.createGroup((Composite)parent, (String)TeiidMetadataImportViewModelPage.getString("viewModelDefinitionGroup"), (int)0, (int)2, (int)3);
        GridData gd_vg = new GridData(768);
        gd_vg.horizontalSpan = 2;
        viewGroup.setLayoutData((Object)gd_vg);
        ((GridData)viewGroup.getLayoutData()).minimumWidth = 400;
        Label locationLabel = new Label((Composite)viewGroup, 0);
        locationLabel.setText(TeiidMetadataImportViewModelPage.getString("location"));
        this.viewModelContainerText = new Text((Composite)viewGroup, 2052);
        GridData gridData = new GridData(768);
        this.viewModelContainerText.setLayoutData((Object)gridData);
        this.viewModelContainerText.setBackground(Display.getCurrent().getSystemColor(19));
        this.viewModelContainerText.setEditable(false);
        Button browseButton = new Button((Composite)viewGroup, 8);
        gridData = new GridData();
        browseButton.setLayoutData((Object)gridData);
        browseButton.setText(TeiidMetadataImportViewModelPage.getString("browse"));
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TeiidMetadataImportViewModelPage.this.handleViewModelLocationBrowse();
            }
        });
        Label fileLabel = new Label((Composite)viewGroup, 0);
        fileLabel.setText(TeiidMetadataImportViewModelPage.getString("name"));
        this.viewModelFileText = new Text((Composite)viewGroup, 2052);
        gridData = new GridData(768);
        this.viewModelFileText.setLayoutData((Object)gridData);
        this.viewModelFileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TeiidMetadataImportViewModelPage.this.handleViewModelTextChanged();
            }
        });
        browseButton = new Button((Composite)viewGroup, 8);
        gridData = new GridData();
        browseButton.setLayoutData((Object)gridData);
        browseButton.setText(TeiidMetadataImportViewModelPage.getString("browse"));
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TeiidMetadataImportViewModelPage.this.handleViewModelBrowse();
            }
        });
        new Label((Composite)viewGroup, 0);
        Group helpGroup = WidgetFactory.createGroup((Composite)viewGroup, (String)TeiidMetadataImportViewModelPage.getString("modelStatus"), (int)2, (int)2);
        helpGroup.setLayoutData((Object)new GridData(768));
        this.viewHelpText = new Text((Composite)helpGroup, 72);
        this.viewHelpText.setBackground(Display.getCurrent().getSystemColor(19));
        this.viewHelpText.setForeground(Display.getCurrent().getSystemColor(10));
        GridData gd = new GridData(768);
        gd.heightHint = 40;
        gd.horizontalSpan = 3;
        this.viewHelpText.setLayoutData((Object)gd);
        new Label((Composite)viewGroup, 0);
        Label viewTableLabel = new Label((Composite)viewGroup, 0);
        viewTableLabel.setText(TeiidMetadataImportViewModelPage.getString("newViewTableName"));
        this.viewTableNameText = new Text((Composite)viewGroup, 2052);
        gridData = new GridData(768);
        this.viewTableNameText.setLayoutData((Object)gridData);
        this.viewTableNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TeiidMetadataImportViewModelPage.this.handleViewTableTextChanged();
            }
        });
    }

    void handleViewModelLocationBrowse() {
        IContainer folder = WidgetUtil.showFolderSelectionDialog((IContainer)ModelerCore.getWorkspace().getRoot(), (ViewerFilter)new ModelingResourceFilter(), (ISelectionStatusValidator)new ModelProjectSelectionStatusValidator());
        if (folder != null && this.viewModelContainerText != null) {
            this.info.setViewModelLocation(folder.getFullPath().makeRelative());
        }
        if (folder != null && this.viewModelContainerText != null) {
            this.info.setViewModelLocation(folder.getFullPath().makeRelative());
            this.viewModelFilePath = this.info.getViewModelLocation();
            this.viewModelContainerText.setText(this.info.getViewModelLocation().makeRelative().toString());
        } else {
            this.info.setViewModelLocation((IPath)new Path(""));
            this.viewModelContainerText.setText("");
        }
        if (this.viewModelFileText.getText() != null && this.viewModelFileText.getText().length() > -1) {
            this.info.setViewModelExists(this.viewModelExists());
        }
        this.validatePage();
    }

    void handleViewModelBrowse() {
        Object[] selections = WidgetUtil.showWorkspaceObjectSelectionDialog((String)TeiidMetadataImportViewModelPage.getString("selectViewModelTitle"), (String)TeiidMetadataImportViewModelPage.getString("selectViewModelMessage"), (boolean)false, null, (ViewerFilter)this.virtualModelFilter, (ISelectionStatusValidator)new ModelResourceSelectionValidator(false), (ILabelProvider)new ModelExplorerLabelProvider(), (ITreeContentProvider)new ModelExplorerContentProvider());
        if (selections != null && selections.length == 1 && this.viewModelFileText != null && selections[0] instanceof IFile) {
            IFile modelFile = (IFile)selections[0];
            IPath folderPath = modelFile.getFullPath().removeLastSegments(1);
            String modelName = modelFile.getFullPath().lastSegment();
            this.info.setViewModelExists(true);
            this.info.setViewModelLocation(folderPath);
            this.info.setViewModelName(modelName);
        }
        if (this.info.getViewModelName() != null) {
            this.viewModelFilePath = this.info.getViewModelLocation();
            this.viewModelContainerText.setText(this.info.getViewModelLocation().makeRelative().toString());
            this.viewModelFileText.setText(this.info.getViewModelName());
        } else {
            this.viewModelFileText.setText("");
        }
        this.validatePage();
    }

    void handleViewModelTextChanged() {
        if (this.synchronizing) {
            return;
        }
        String newName = "";
        if (this.viewModelFileText.getText() != null) {
            if (this.viewModelFileText.getText().length() == 0) {
                this.info.setViewModelName(newName);
                this.info.setViewModelExists(false);
            } else {
                newName = this.viewModelFileText.getText();
                this.info.setViewModelName(newName);
                this.info.setViewModelExists(this.viewModelExists());
            }
        }
        this.validatePage();
    }

    void handleViewTableTextChanged() {
        if (this.synchronizing) {
            return;
        }
        String newName = "";
        if (this.viewTableNameText.getText() != null && this.viewTableNameText.getText().length() > -1) {
            newName = this.viewTableNameText.getText();
            this.fileInfo.setViewTableName(newName);
        } else {
            this.fileInfo.setViewTableName("");
        }
        this.synchronizeUI();
        this.validatePage();
    }

    private boolean validatePage() {
        String sourceFilename;
        this.setViewHelpMessage();
        String container = this.viewModelContainerText.getText();
        if (CoreStringUtil.isEmpty((String)container)) {
            this.setThisPageComplete(TeiidMetadataImportViewModelPage.getString("viewFileLocationMustBeSpecified"), 3);
            return false;
        }
        IProject project = this.getTargetProject();
        if (project == null) {
            this.setThisPageComplete(TeiidMetadataImportViewModelPage.getString("viewFileLocationMustBeSpecified"), 3);
            return false;
        }
        if (!project.isOpen()) {
            this.setThisPageComplete(TeiidMetadataImportViewModelPage.getString("targetProjectIsClosed"), 3);
            return false;
        }
        try {
            if (project.getNature("org.teiid.designer.core.modelNature") == null) {
                this.setThisPageComplete(TeiidMetadataImportViewModelPage.getString("targetProjectIsNotDesignerNature"), 3);
                return false;
            }
        }
        catch (CoreException coreException) {
            this.setThisPageComplete(TeiidMetadataImportViewModelPage.getString("targetProjectHasNoNature"), 3);
            return false;
        }
        String fileText = this.viewModelFileText.getText().trim();
        IStatus status = ModelNameUtil.validate((String)fileText, (String)DEFAULT_EXTENSION, null, (int)5);
        if (status.getSeverity() == 4) {
            this.setThisPageComplete(String.valueOf(ModelNameUtil.MESSAGES.INVALID_VIEW_MODEL_NAME) + status.getMessage(), 3);
            return false;
        }
        String viewFileName = this.getViewFileName();
        if (viewFileName.equalsIgnoreCase(sourceFilename = this.getSourceFileName())) {
            this.setThisPageComplete(TeiidMetadataImportViewModelPage.getString("sourceAndViewFilesCannotHaveSameName"), 3);
            return false;
        }
        String invalidMessage = this.validator.checkValidName(this.fileInfo.getViewTableName());
        if (invalidMessage != null) {
            this.setThisPageComplete(TeiidMetadataImportViewModelPage.getString("viewTableNameInvalid", invalidMessage), 3);
            return false;
        }
        if (this.viewAlreadyExists()) {
            this.setThisPageComplete(TeiidMetadataImportViewModelPage.getString("viewTableAlreadyExists", this.fileInfo.getViewTableName()), 3);
            return false;
        }
        if (this.fileInfo.getViewTableName() == null || this.fileInfo.getViewTableName().length() == 0) {
            this.setThisPageComplete(TeiidMetadataImportViewModelPage.getString("viewTableNameNullOrEmpty"), 3);
            return false;
        }
        if (this.info.getStatus().getSeverity() == 4) {
            this.setThisPageComplete(this.info.getStatus().getMessage(), 3);
            return false;
        }
        this.setThisPageComplete("", 0);
        return true;
    }

    private void setViewHelpMessage() {
        if (this.creatingControl) {
            return;
        }
        if (this.info.viewModelExists()) {
            this.viewHelpText.setText(Util.getString(String.valueOf(I18N_PREFIX) + "existingViewModelMessage", (Object)this.info.getViewModelName()));
        } else if (this.info.getViewModelName() == null || this.info.getViewModelName().length() == 0) {
            this.viewHelpText.setText(Util.getString(String.valueOf(I18N_PREFIX) + "viewModelUndefined", new Object[0]));
        } else {
            this.viewHelpText.setText(Util.getString(String.valueOf(I18N_PREFIX) + "newViewModelMessage", (Object)this.info.getViewModelName()));
        }
    }

    private IProject getTargetProject() {
        IWorkspaceRoot root;
        IResource resource;
        IProject result = null;
        String containerName = this.getViewContainerName();
        if (!CoreStringUtil.isEmpty((String)containerName) && (resource = (root = ModelerCore.getWorkspace().getRoot()).findMember((IPath)new Path(containerName))).exists()) {
            result = resource.getProject();
        }
        return result;
    }

    private void setThisPageComplete(String message, int severity) {
        WizardUtil.setPageComplete((WizardPage)this, (String)message, (int)severity);
    }

    private boolean viewModelExists() {
        ModelWorkspaceItem item;
        if (this.viewModelFilePath == null) {
            return false;
        }
        IPath modelPath = new Path(this.viewModelFilePath.toOSString()).append(this.viewModelFileText.getText());
        if (!modelPath.toString().toUpperCase().endsWith(".XMI")) {
            modelPath = modelPath.addFileExtension("xmi");
        }
        return (item = ModelWorkspaceManager.getModelWorkspaceManager().findModelWorkspaceItem(modelPath, 1)) != null;
    }

    private void synchronizeUI() {
        this.synchronizing = true;
        File dataFile = this.fileInfo.getDataFile();
        String fileName = dataFile.getName();
        this.selectedFileText.setText(fileName);
        if (this.info.getViewModelLocation() != null) {
            this.viewModelContainerText.setText(this.info.getViewModelLocation().makeRelative().toString());
            this.viewModelFilePath = this.info.getViewModelLocation();
        } else {
            this.viewModelContainerText.setText("");
        }
        if (this.info.getViewModelName() != null) {
            String viewModelName = this.info.getViewModelName();
            this.viewModelFileText.setText(viewModelName);
        } else {
            this.viewModelFileText.setText("");
        }
        String viewTableName = this.fileInfo.getViewTableName();
        if (viewTableName != null) {
            if (!StringUtilities.equalsIgnoreCase((String)viewTableName, (String)this.viewTableNameText.getText())) {
                this.viewTableNameText.setText(viewTableName);
            }
        } else {
            this.viewTableNameText.setText("");
        }
        this.synchronizing = false;
    }

    private String getHiddenProjectPath() {
        String result = null;
        IProject hiddenProj = ProductCustomizerMgr.getInstance().getProductCharacteristics().getHiddenProject(false);
        if (hiddenProj != null) {
            result = hiddenProj.getFullPath().makeRelative().toString();
        }
        return result;
    }

    private String getViewContainerName() {
        String result = null;
        result = ProductCustomizerMgr.getInstance().getProductCharacteristics().isHiddenProjectCentric() ? this.getHiddenProjectPath() : this.viewModelContainerText.getText().trim();
        return result;
    }

    private String getViewFileName() {
        String result = this.viewModelFileText.getText().trim();
        if (!result.endsWith(DEFAULT_EXTENSION)) {
            result = String.valueOf(result) + DEFAULT_EXTENSION;
        }
        return result;
    }

    private String getSourceFileName() {
        String result = this.info.getSourceModelName().trim();
        if (!result.endsWith(DEFAULT_EXTENSION)) {
            result = String.valueOf(result) + DEFAULT_EXTENSION;
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean viewAlreadyExists() {
        IFile viewModel;
        ModelResource smr;
        if (!this.info.viewModelExists()) {
            return false;
        }
        IPath modelPath = new Path(this.viewModelFilePath.toOSString()).append(this.viewModelFileText.getText());
        if (!modelPath.toString().toUpperCase().endsWith(".XMI")) {
            modelPath = modelPath.addFileExtension(DEFAULT_EXTENSION);
        }
        if ((smr = ModelUtilities.getModelResourceForIFile((IFile)(viewModel = ModelerCore.getWorkspace().getRoot().getFile(modelPath)), (boolean)false)) == null) return false;
        try {
            Object obj;
            EObject eObj;
            String existingName = this.fileInfo.getViewTableName();
            Iterator iterator = smr.getAllRootEObjects().iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!((eObj = (EObject)(obj = iterator.next())) instanceof BaseTable) || !existingName.equalsIgnoreCase(ModelObjectUtilities.getName((EObject)eObj)));
            return true;
        }
        catch (ModelWorkspaceException err) {
            Util.log((Throwable)err);
        }
        return false;
    }
}

