/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.wizards.file;

import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.transformation.ui.UiConstants;
import org.teiid.designer.transformation.ui.UiPlugin;
import org.teiid.designer.transformation.ui.wizards.file.TeiidMetadataFileInfo;
import org.teiid.designer.ui.common.util.WidgetFactory;

public class TextTableFunctionOptionsDialog
extends TitleAreaDialog {
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix(TextTableFunctionOptionsDialog.class);
    private final String TITLE = TextTableFunctionOptionsDialog.getString("title");
    private TeiidMetadataFileInfo dataFileInfo;
    Text quoteText;
    Text escapeText;
    Button useHeaderInSQLCB;
    Button includeQuoteCB;
    Button includeEscapeCB;
    Button includeSkipCB;
    Button includeNoTrimCB;
    boolean synchronizing = false;

    private static String getString(String id) {
        return UiConstants.Util.getString(String.valueOf(I18N_PREFIX) + id, new Object[0]);
    }

    public TextTableFunctionOptionsDialog(Shell parent, TeiidMetadataFileInfo fileInfo) {
        super(parent);
        this.dataFileInfo = fileInfo;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.TITLE);
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x10 | 0x400);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(this.TITLE);
        this.setTitleImage(UiPlugin.getDefault().getImage("icons/full/wizban/importTeiidMetadataWiz.gif"));
        this.setMessage(TextTableFunctionOptionsDialog.getString("titleMessage"));
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        composite.setLayout((Layout)gridLayout);
        gridLayout.numColumns = 1;
        GridData gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.widthHint = 500;
        composite.setLayoutData((Object)gridData);
        this.createOptionsGroup(composite);
        return composite;
    }

    private void createOptionsGroup(Composite parent) {
        Group theGroup = WidgetFactory.createGroup((Composite)parent, (String)TextTableFunctionOptionsDialog.getString("teiidTextTableGroup"), (int)0, (int)1, (int)2);
        GridData groupGD = new GridData(768);
        groupGD.horizontalSpan = 1;
        theGroup.setLayoutData((Object)groupGD);
        this.useHeaderInSQLCB = WidgetFactory.createCheckBox((Composite)theGroup, (String)TextTableFunctionOptionsDialog.getString("includeHeader"), (int)0, (int)2);
        this.useHeaderInSQLCB.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (!TextTableFunctionOptionsDialog.this.synchronizing) {
                    TextTableFunctionOptionsDialog.this.dataFileInfo.setIncludeHeader(TextTableFunctionOptionsDialog.this.useHeaderInSQLCB.getSelection());
                    TextTableFunctionOptionsDialog.this.dataFileInfo.setDoUseHeaderForColumnNames(TextTableFunctionOptionsDialog.this.useHeaderInSQLCB.getSelection());
                    TextTableFunctionOptionsDialog.this.synchronizeUI();
                }
            }
        });
        this.useHeaderInSQLCB.setToolTipText(TextTableFunctionOptionsDialog.getString("includeHeaderTooltip"));
        this.useHeaderInSQLCB.setLayoutData((Object)new GridData());
        new Label((Composite)theGroup, 0);
        this.includeSkipCB = WidgetFactory.createCheckBox((Composite)theGroup, (String)TextTableFunctionOptionsDialog.getString("includeSkip"), (int)0, (int)2);
        this.includeSkipCB.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (!TextTableFunctionOptionsDialog.this.synchronizing) {
                    TextTableFunctionOptionsDialog.this.dataFileInfo.setIncludeSkip(TextTableFunctionOptionsDialog.this.includeSkipCB.getSelection());
                    TextTableFunctionOptionsDialog.this.synchronizeUI();
                }
            }
        });
        this.includeSkipCB.setToolTipText(TextTableFunctionOptionsDialog.getString("includeSkipTooltip"));
        this.includeSkipCB.setLayoutData((Object)new GridData());
        new Label((Composite)theGroup, 0);
        this.includeQuoteCB = WidgetFactory.createCheckBox((Composite)theGroup, (String)TextTableFunctionOptionsDialog.getString("includeQuote"), (int)0, (int)1);
        this.includeQuoteCB.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (!TextTableFunctionOptionsDialog.this.synchronizing) {
                    TextTableFunctionOptionsDialog.this.dataFileInfo.setIncludeQuote(TextTableFunctionOptionsDialog.this.includeQuoteCB.getSelection());
                    TextTableFunctionOptionsDialog.this.synchronizeUI();
                }
            }
        });
        this.quoteText = WidgetFactory.createTextField((Composite)theGroup, (int)0);
        GridData gd = new GridData(32);
        gd.minimumWidth = 50;
        gd.horizontalSpan = 1;
        gd.grabExcessHorizontalSpace = true;
        this.quoteText.setLayoutData((Object)gd);
        this.quoteText.setTextLimit(1);
        this.quoteText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                if (!TextTableFunctionOptionsDialog.this.synchronizing) {
                    if (!TextTableFunctionOptionsDialog.this.quoteText.getText().isEmpty()) {
                        if (!TextTableFunctionOptionsDialog.this.quoteText.getText().substring(0, 1).equals(TextTableFunctionOptionsDialog.this.dataFileInfo.getQuote())) {
                            TextTableFunctionOptionsDialog.this.dataFileInfo.setQuote(TextTableFunctionOptionsDialog.this.quoteText.getText().substring(0, 1));
                            TextTableFunctionOptionsDialog.this.synchronizeUI();
                        }
                        TextTableFunctionOptionsDialog.this.setErrorMessage(null);
                    } else {
                        TextTableFunctionOptionsDialog.this.setErrorMessage(TextTableFunctionOptionsDialog.getString("quoteCannotBeNull"));
                        return;
                    }
                }
            }
        });
        this.includeQuoteCB.setToolTipText(TextTableFunctionOptionsDialog.getString("includeQuoteTooltip"));
        this.includeEscapeCB = WidgetFactory.createCheckBox((Composite)theGroup, (String)TextTableFunctionOptionsDialog.getString("includeEscape"), (int)0, (int)1);
        this.includeEscapeCB.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (!TextTableFunctionOptionsDialog.this.synchronizing) {
                    TextTableFunctionOptionsDialog.this.dataFileInfo.setIncludeEscape(TextTableFunctionOptionsDialog.this.includeEscapeCB.getSelection());
                    TextTableFunctionOptionsDialog.this.synchronizeUI();
                }
            }
        });
        this.escapeText = WidgetFactory.createTextField((Composite)theGroup, (int)0);
        gd = new GridData(32);
        gd.minimumWidth = 50;
        gd.horizontalSpan = 1;
        gd.grabExcessHorizontalSpace = true;
        this.escapeText.setLayoutData((Object)gd);
        this.escapeText.setTextLimit(1);
        this.escapeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                if (!TextTableFunctionOptionsDialog.this.synchronizing) {
                    if (!TextTableFunctionOptionsDialog.this.escapeText.getText().isEmpty()) {
                        if (!TextTableFunctionOptionsDialog.this.escapeText.getText().substring(0, 1).equals(TextTableFunctionOptionsDialog.this.dataFileInfo.getEscape())) {
                            TextTableFunctionOptionsDialog.this.dataFileInfo.setEscape(TextTableFunctionOptionsDialog.this.escapeText.getText().substring(0, 1));
                            TextTableFunctionOptionsDialog.this.synchronizeUI();
                        }
                        TextTableFunctionOptionsDialog.this.setErrorMessage(null);
                    } else {
                        TextTableFunctionOptionsDialog.this.setErrorMessage(TextTableFunctionOptionsDialog.getString("escapeCannotBeNull"));
                        return;
                    }
                }
            }
        });
        this.includeEscapeCB.setToolTipText(TextTableFunctionOptionsDialog.getString("includeEscapeTooltip"));
        this.includeNoTrimCB = WidgetFactory.createCheckBox((Composite)theGroup, (String)TextTableFunctionOptionsDialog.getString("includeNoTrim"), (int)0, (int)2);
        this.includeNoTrimCB.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (!TextTableFunctionOptionsDialog.this.synchronizing) {
                    TextTableFunctionOptionsDialog.this.dataFileInfo.setIncludeNoTrim(TextTableFunctionOptionsDialog.this.includeNoTrimCB.getSelection());
                    TextTableFunctionOptionsDialog.this.synchronizeUI();
                }
            }
        });
        this.includeNoTrimCB.setToolTipText(TextTableFunctionOptionsDialog.getString("includeNoTrimTooltip"));
        this.includeNoTrimCB.setLayoutData((Object)new GridData());
        new Label((Composite)theGroup, 0);
    }

    public void create() {
        super.create();
        this.getButton(0).setEnabled(true);
        this.synchronizeUI();
    }

    private void synchronizeUI() {
        this.useHeaderInSQLCB.setSelection(this.dataFileInfo.doIncludeHeader());
        this.includeSkipCB.setSelection(this.dataFileInfo.doIncludeSkip());
        this.includeQuoteCB.setSelection(this.dataFileInfo.doIncludeQuote());
        this.includeEscapeCB.setSelection(this.dataFileInfo.doIncludeEscape());
        this.includeNoTrimCB.setSelection(this.dataFileInfo.doIncludeNoTrim());
        this.quoteText.setText(this.dataFileInfo.getQuote());
        this.escapeText.setText(this.dataFileInfo.getEscape());
    }

    protected void okPressed() {
        super.okPressed();
    }
}

