/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.wizards.functions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.metamodels.core.ModelType;
import org.teiid.designer.relational.model.RelationalViewProcedure;
import org.teiid.designer.transformation.ui.UiConstants;
import org.teiid.designer.transformation.ui.wizards.functions.ConvertFunctionModelHelper;
import org.teiid.designer.ui.common.graphics.GlobalUiColorManager;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.viewsupport.StatusInfo;
import org.teiid.designer.ui.viewsupport.ModelSelectorDialog;
import org.teiid.designer.ui.viewsupport.ModelSelectorInfo;
import org.teiid.designer.ui.viewsupport.ModelWorkspaceViewerFilter;

public class ConvertFunctionModelDialog
extends TitleAreaDialog {
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix(ConvertFunctionModelDialog.class);
    private final String TITLE = ConvertFunctionModelDialog.getString("title");
    private ConvertFunctionModelHelper helper;
    private TableViewer listViewer;
    private Button browseModelButton;
    private Text modelNameText;

    private static String getString(String id) {
        return UiConstants.Util.getString(String.valueOf(I18N_PREFIX) + id, new Object[0]);
    }

    public ConvertFunctionModelDialog(Shell parent, ConvertFunctionModelHelper helper) {
        super(parent);
        this.helper = helper;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.TITLE);
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x10 | 0x400);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(this.TITLE);
        this.setMessage(ConvertFunctionModelDialog.getString("titleMessage"));
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        composite.setLayout((Layout)gridLayout);
        gridLayout.numColumns = 1;
        GridData gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.widthHint = 500;
        composite.setLayoutData((Object)gridData);
        this.createFunctionListViewerGroup(composite);
        this.createTargetModelGroup(composite);
        return composite;
    }

    private void createFunctionListViewerGroup(Composite parent) {
        Group theGroup = WidgetFactory.createGroup((Composite)parent, (String)ConvertFunctionModelDialog.getString("selectFunctions"), (int)0, (int)1, (int)2);
        GridData groupGD = new GridData(768);
        groupGD.horizontalSpan = 1;
        theGroup.setLayoutData((Object)groupGD);
        Table table = new Table((Composite)theGroup, 2850);
        table.setHeaderVisible(false);
        table.setLinesVisible(true);
        table.setLayout((Layout)new TableLayout());
        this.listViewer = new TableViewer(table);
        GridDataFactory.fillDefaults().grab(true, false).hint(-1, 100).span(2, 1).applyTo(this.listViewer.getControl());
        this.listViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public boolean hasChildren(Object element) {
                return ConvertFunctionModelDialog.this.helper.getVirtualFunctions().length <= 0;
            }

            public Object getParent(Object element) {
                return null;
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof ConvertFunctionModelHelper) {
                    return ConvertFunctionModelDialog.this.helper.getVirtualFunctions();
                }
                return new Object[0];
            }

            public Object[] getChildren(Object parentElement) {
                return new Object[0];
            }
        });
        FunctionProvider provider = new FunctionProvider();
        this.listViewer.setContentProvider((IContentProvider)provider);
        this.listViewer.setLabelProvider((IBaseLabelProvider)provider);
        this.listViewer.setInput((Object)this.helper);
        this.listViewer.getTable().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (e.detail != 32) {
                    return;
                }
                ConvertFunctionModelDialog.this.helper.clearFunctions();
                TableItem[] tableItemArray = ConvertFunctionModelDialog.this.listViewer.getTable().getItems();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    if (item.getChecked()) {
                        ConvertFunctionModelDialog.this.helper.selectFunction((RelationalViewProcedure)item.getData());
                    }
                    ++n2;
                }
                ConvertFunctionModelDialog.this.setDialogStatus();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void createTargetModelGroup(Composite parent) {
        Group theGroup = WidgetFactory.createGroup((Composite)parent, (String)ConvertFunctionModelDialog.getString("targetModelGroupName"), (int)0, (int)1, (int)3);
        GridData groupGD = new GridData(768);
        groupGD.horizontalSpan = 1;
        theGroup.setLayoutData((Object)groupGD);
        Label selectedFileLabel = new Label((Composite)theGroup, 0);
        selectedFileLabel.setText(ConvertFunctionModelDialog.getString("name"));
        this.modelNameText = new Text((Composite)theGroup, 2052);
        this.modelNameText.setEditable(false);
        this.modelNameText.setBackground(GlobalUiColorManager.getSystemColor((int)19));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.modelNameText);
        this.browseModelButton = new Button((Composite)theGroup, 8);
        this.browseModelButton.setText("...");
        this.browseModelButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ConvertFunctionModelDialog.this.handleModelFolderBrowseButtonPressed();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.browseModelButton.setLayoutData((Object)new GridData(256));
        this.browseModelButton.setFont(parent.getFont());
        GridDataFactory.fillDefaults().minSize(30, 16).applyTo((Control)this.browseModelButton);
    }

    protected void handleModelFolderBrowseButtonPressed() {
        Object[] selectedObjects;
        ModelSelectorInfo newModelInfo = new ModelSelectorInfo(ConvertFunctionModelDialog.getString("modelNameDialogTitle"), ModelType.VIRTUAL_LITERAL, "http://www.metamatrix.com/metamodels/Relational", ConvertFunctionModelDialog.getString("modelNameDialogNewName"), ConvertFunctionModelDialog.getString("modelNameDialogMessage"));
        ModelSelectorDialog mwdDialog = new ModelSelectorDialog(this.getShell(), newModelInfo);
        mwdDialog.addFilter((ViewerFilter)new ModelWorkspaceViewerFilter(true));
        mwdDialog.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection == null) {
                    return new StatusInfo("org.teiid.designer.transformation.ui", 4, ConvertFunctionModelDialog.getString("modelNameDialogNoModelSelected"));
                }
                if (selection.length != 1) {
                    return new StatusInfo("org.teiid.designer.transformation.ui", 4, ConvertFunctionModelDialog.getString("modelNameDialogMultipleSelection"));
                }
                if (!(selection[0] instanceof IFile)) {
                    return new StatusInfo("org.teiid.designer.transformation.ui", 4, ConvertFunctionModelDialog.getString("modelNameDialogNoModelSelected"));
                }
                return new StatusInfo("org.teiid.designer.transformation.ui");
            }
        });
        mwdDialog.setAllowMultiple(false);
        mwdDialog.open();
        if (mwdDialog.getReturnCode() == 0 && (selectedObjects = mwdDialog.getResult()).length > 0 && selectedObjects[0] instanceof IFile) {
            IFile theFile = (IFile)selectedObjects[0];
            ModelResource targetModel = null;
            if (theFile != null) {
                try {
                    targetModel = ModelUtil.getModelResource((IFile)theFile, (boolean)false);
                }
                catch (ModelWorkspaceException theException) {
                    UiConstants.Util.log((Throwable)theException);
                }
            }
            if (targetModel != null) {
                this.helper.setTargetModel(targetModel);
                this.modelNameText.setText(targetModel.getPath().toOSString());
            }
        }
        this.setDialogStatus();
    }

    private void setDialogStatus() {
        IStatus status = this.helper.getStatus();
        if (status.getSeverity() == 4) {
            this.setErrorMessage(status.getMessage());
            this.getButton(0).setEnabled(false);
        } else {
            this.setErrorMessage(null);
            this.setMessage(status.getMessage(), status.getSeverity());
            this.getButton(0).setEnabled(true);
        }
    }

    class FunctionProvider
    extends ColumnLabelProvider
    implements ITreeContentProvider {
        FunctionProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public boolean hasChildren(Object element) {
            return ConvertFunctionModelDialog.this.helper.getVirtualFunctions().length <= 0;
        }

        public Object getParent(Object element) {
            return null;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof ConvertFunctionModelHelper) {
                return ConvertFunctionModelDialog.this.helper.getVirtualFunctions();
            }
            return new Object[0];
        }

        public Object[] getChildren(Object parentElement) {
            return new Object[0];
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            if (element instanceof RelationalViewProcedure) {
                return ((RelationalViewProcedure)element).getName();
            }
            return null;
        }
    }
}

