/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.wizards.functions;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.extension.properties.ModelExtensionPropertyDefinition;
import org.teiid.designer.extension.properties.NamespaceProvider;
import org.teiid.designer.metamodels.function.FunctionParameter;
import org.teiid.designer.metamodels.function.FunctionPlugin;
import org.teiid.designer.metamodels.function.ReturnParameter;
import org.teiid.designer.metamodels.function.ScalarFunction;
import org.teiid.designer.metamodels.function.extension.FunctionModelExtensionConstants;
import org.teiid.designer.relational.model.RelationalModel;
import org.teiid.designer.relational.model.RelationalParameter;
import org.teiid.designer.relational.model.RelationalReference;
import org.teiid.designer.relational.model.RelationalViewProcedure;
import org.teiid.designer.transformation.model.RelationalViewModelFactory;
import org.teiid.designer.transformation.ui.UiConstants;
import org.teiid.designer.ui.editors.ModelEditor;
import org.teiid.designer.ui.editors.ModelEditorManager;

public class ConvertFunctionModelHelper {
    private static String UDF_JAR_PROP_KEY = "udfJarPath";
    private static String RETURN_PARAM_STR = "return_parameter";
    private static Status OK_TO_FINISH_STATUS = new Status(0, "org.teiid.designer.transformation.ui", UiConstants.Util.getString("ConvertFunctionModelHelper.okToFinishMessage", new Object[0]));
    private ModelResource functionModel;
    private List<ScalarFunction> scalarFunctions = new ArrayList<ScalarFunction>();
    private RelationalViewProcedure[] virtualFunctions;
    private Set<RelationalViewProcedure> selectedProcedures = new HashSet<RelationalViewProcedure>();
    private ModelResource targetModel;
    private IStatus currentStatus;

    public ConvertFunctionModelHelper(ModelResource functionModel) {
        this();
        this.functionModel = functionModel;
        this.loadFunctions();
        this.validate();
    }

    public ConvertFunctionModelHelper() {
    }

    public ModelResource getFunctionModel() {
        return this.functionModel;
    }

    public List<ScalarFunction> getScalarFunctions() {
        return this.scalarFunctions;
    }

    public RelationalViewProcedure[] getVirtualFunctions() {
        return this.virtualFunctions;
    }

    public ModelResource getTargetModel() {
        return this.targetModel;
    }

    public void setTargetModel(ModelResource targetModel) {
        this.targetModel = targetModel;
        this.validate();
    }

    private void loadFunctions() {
        try {
            List modelChildren = this.functionModel.getAllRootEObjects();
            this.scalarFunctions = new ArrayList<ScalarFunction>();
            for (EObject child : modelChildren) {
                if (!(child instanceof ScalarFunction)) continue;
                this.scalarFunctions.add((ScalarFunction)child);
            }
        }
        catch (ModelWorkspaceException e) {
            e.printStackTrace();
        }
        ArrayList<RelationalViewProcedure> viewProcedures = new ArrayList<RelationalViewProcedure>();
        for (ScalarFunction sf : this.scalarFunctions) {
            RelationalViewProcedure relationalProcedure = new RelationalViewProcedure(sf.getName());
            relationalProcedure.setFunction(true);
            relationalProcedure.setFunctionCategory(sf.getCategory());
            relationalProcedure.setJavaClassName(sf.getInvocationClass());
            relationalProcedure.setJavaMethodName(sf.getInvocationMethod());
            String jarPathPropId = ModelExtensionPropertyDefinition.Utils.getPropertyId((NamespaceProvider)FunctionModelExtensionConstants.NAMESPACE_PROVIDER, (String)UDF_JAR_PROP_KEY);
            String jarPath = FunctionPlugin.getExtensionProperty((EObject)sf, (String)jarPathPropId);
            relationalProcedure.setUdfJarPath(jarPath);
            String desc = this.getDescription((EObject)sf);
            if (desc != null) {
                relationalProcedure.setDescription(desc);
            }
            for (Object param : sf.getInputParameters()) {
                FunctionParameter fp = (FunctionParameter)param;
                RelationalParameter udfParam = new RelationalParameter(fp.getName());
                udfParam.setDirection("IN");
                udfParam.setDatatype(fp.getType());
                desc = this.getDescription((EObject)fp);
                if (desc != null) {
                    udfParam.setDescription(desc);
                }
                relationalProcedure.addParameter(udfParam);
            }
            ReturnParameter returnParam = sf.getReturnParameter();
            if (returnParam != null) {
                RelationalParameter param = new RelationalParameter(RETURN_PARAM_STR);
                param.setDatatype(returnParam.getType());
                param.setDirection("RETURN");
                desc = this.getDescription((EObject)returnParam);
                if (desc != null) {
                    param.setDescription(desc);
                }
                relationalProcedure.addParameter(param);
            }
            viewProcedures.add(relationalProcedure);
        }
        this.virtualFunctions = viewProcedures.toArray(new RelationalViewProcedure[viewProcedures.size()]);
    }

    public void selectFunction(RelationalViewProcedure procedure) {
        this.selectedProcedures.add(procedure);
        this.validate();
    }

    public void deselectFunction(RelationalViewProcedure procedure) {
        this.selectedProcedures.remove(procedure);
        this.validate();
    }

    public void clearFunctions() {
        this.selectedProcedures.clear();
        this.validate();
    }

    public IStatus generateProcedures() {
        IStatus status = Status.OK_STATUS;
        status = this.createProceduresInTxn();
        return status;
    }

    private IStatus createProceduresInTxn() {
        RelationalModel relModel = new RelationalModel("dummy");
        for (RelationalViewProcedure proc : this.selectedProcedures) {
            relModel.addChild((RelationalReference)proc);
        }
        boolean requiredStart = ModelerCore.startTxn((boolean)true, (boolean)true, (String)"Create Virtual Procedures From Legacy Functions", (Object)this);
        boolean succeeded = false;
        try {
            try {
                ModelEditor editor = ModelEditorManager.getModelEditorForFile((IFile)((IFile)this.targetModel.getCorrespondingResource()), (boolean)true);
                if (editor != null) {
                    boolean isDirty = editor.isDirty();
                    RelationalViewModelFactory factory = new RelationalViewModelFactory();
                    factory.setAllowsZeroStringLength(true);
                    factory.build(this.targetModel, relModel, (IProgressMonitor)new NullProgressMonitor());
                    if (!isDirty && editor.isDirty()) {
                        editor.doSave((IProgressMonitor)new NullProgressMonitor());
                    }
                    succeeded = true;
                }
            }
            catch (Exception e) {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)UiConstants.Util.getString("ConvertFunctionModelHelper.buildErrorTitle", new Object[0]), (String)e.getMessage());
                Status errorStatus = new Status(4, "org.teiid.designer.transformation.ui", UiConstants.Util.getString("ConvertFunctionModelHelper.buildErrorMessage", new Object[0]), (Throwable)e);
                UiConstants.Util.log((IStatus)errorStatus);
                Status status = errorStatus;
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
                return status;
            }
        }
        finally {
            if (requiredStart) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
        return Status.OK_STATUS;
    }

    private void validate() {
        if (this.scalarFunctions.isEmpty()) {
            this.currentStatus = new Status(4, "org.teiid.designer.transformation.ui", UiConstants.Util.getString("ConvertFunctionModelHelper.noFunctionsMessage", new Object[0]));
            return;
        }
        if (this.targetModel == null) {
            this.currentStatus = new Status(4, "org.teiid.designer.transformation.ui", UiConstants.Util.getString("ConvertFunctionModelHelper.targetModelUndefined", new Object[0]));
            return;
        }
        if (this.selectedProcedures.isEmpty()) {
            this.currentStatus = new Status(4, "org.teiid.designer.transformation.ui", UiConstants.Util.getString("ConvertFunctionModelHelper.noFunctionsSelected", new Object[0]));
            return;
        }
        this.currentStatus = OK_TO_FINISH_STATUS;
    }

    public IStatus getStatus() {
        return this.currentStatus;
    }

    private String getDescription(EObject eObj) {
        String desc = null;
        try {
            desc = ModelerCore.getModelEditor().getDescription(eObj);
        }
        catch (ModelerCoreException e) {
            UiConstants.Util.log(4, (Throwable)e, e.getMessage());
        }
        return desc;
    }
}

