/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.wizards.rest;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMarkerResolution;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.extension.ModelExtensionUtils;
import org.teiid.designer.core.util.ModelObjectCollector;
import org.teiid.designer.core.workspace.ModelObjectAnnotationHelper;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.extension.ExtensionPlugin;
import org.teiid.designer.metamodels.relational.Procedure;
import org.teiid.designer.metamodels.relational.extension.RelationalModelExtensionAssistant;
import org.teiid.designer.metamodels.relational.extension.RelationalModelExtensionConstants;
import org.teiid.designer.metamodels.relational.extension.RestModelExtensionAssistant;
import org.teiid.designer.metamodels.relational.extension.RestModelExtensionConstants;
import org.teiid.designer.transformation.ui.Messages;
import org.teiid.designer.transformation.ui.UiConstants;
import org.teiid.designer.transformation.ui.UiPlugin;
import org.teiid.designer.ui.common.viewsupport.UiBusyIndicator;
import org.teiid.designer.ui.editors.ModelEditor;
import org.teiid.designer.ui.editors.ModelEditorManager;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class RestExtensionPropertiesMarkerResolution
implements IMarkerResolution,
RestModelExtensionConstants {
    private Map<EObject, Properties> existingRestPropertyMap;

    public String getLabel() {
        return Messages.restMedQuickFixLabel;
    }

    public void run(IMarker marker) {
        this.existingRestPropertyMap = new HashMap<EObject, Properties>();
        IResource resource = marker.getResource();
        if (ModelUtilities.isModelFile((IResource)resource)) {
            final IFile theFile = (IFile)resource;
            final ModelEditor editor = ModelEditorManager.getModelEditorForFile((IFile)theFile, (boolean)false);
            if (editor != null && editor.isDirty()) {
                boolean saveEditor = MessageDialog.openQuestion((Shell)RestExtensionPropertiesMarkerResolution.getShell(), (String)Messages.quickFixModelDirtyTitle, (String)Messages.quickFixModelDirtyMsg);
                if (!saveEditor) {
                    return;
                }
                UiBusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        editor.doSave((IProgressMonitor)new NullProgressMonitor());
                        RestExtensionPropertiesMarkerResolution.this.fixInTxn((IResource)theFile);
                    }
                });
                return;
            }
            UiBusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    RestExtensionPropertiesMarkerResolution.this.fixInTxn((IResource)theFile);
                }
            });
        }
        this.existingRestPropertyMap.clear();
    }

    private void fixInTxn(IResource modelFile) {
        boolean requiredStart = ModelerCore.startTxn((boolean)true, (boolean)false, (String)"Fix out-dated rest model extensions", (Object)modelFile);
        boolean succeeded = false;
        try {
            this.replaceRestMedAndSetProperties(modelFile);
            succeeded = true;
        }
        finally {
            if (requiredStart) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
    }

    private void replaceRestMedAndSetProperties(IResource modelFile) {
        ModelResource mr = ModelUtilities.getModelResource((Object)modelFile);
        try {
            ModelObjectCollector moc = new ModelObjectCollector(mr.getEmfResource());
            List eObjects = moc.getEObjects();
            ModelObjectAnnotationHelper helper = new ModelObjectAnnotationHelper();
            for (EObject eObj : eObjects) {
                Properties props;
                if (!(eObj instanceof Procedure) || (props = helper.getProperties(eObj, "rest:")).isEmpty()) continue;
                this.existingRestPropertyMap.put(eObj, props);
            }
        }
        catch (ModelWorkspaceException e) {
            UiConstants.Util.log((Throwable)e);
        }
        catch (ModelerCoreException e) {
            UiConstants.Util.log((Throwable)e);
        }
        try {
            ModelExtensionUtils.removeModelExtensionDefinition((ModelResource)mr, (String)"rest");
        }
        catch (Exception e) {
            UiConstants.Util.log((Throwable)e);
        }
        ModelObjectAnnotationHelper helper = new ModelObjectAnnotationHelper();
        try {
            for (EObject eObj : this.existingRestPropertyMap.keySet()) {
                if (!(eObj instanceof Procedure)) continue;
                helper.removeProperties(eObj, "rest:");
            }
        }
        catch (ModelerCoreException e) {
            UiConstants.Util.log((Throwable)e);
        }
        String prefix = RelationalModelExtensionConstants.NAMESPACE_PROVIDER.getNamespacePrefix();
        RelationalModelExtensionAssistant relatinalAssistant = (RelationalModelExtensionAssistant)ExtensionPlugin.getInstance().getRegistry().getModelExtensionAssistant(prefix);
        RestModelExtensionAssistant restAssistant = RestModelExtensionAssistant.getRestAssistant();
        try {
            relatinalAssistant.applyMedIfNecessary(modelFile);
            restAssistant.applyMedIfNecessary(modelFile);
        }
        catch (Exception e) {
            UiConstants.Util.log((Throwable)e);
        }
        for (EObject eObj : this.existingRestPropertyMap.keySet()) {
            if (!(eObj instanceof Procedure)) continue;
            Properties props = this.existingRestPropertyMap.get(eObj);
            for (Object key : props.keySet()) {
                String keyStr = (String)key;
                String value = props.getProperty(keyStr);
                if (keyStr.equals("rest:restMethod")) {
                    RestModelExtensionAssistant.setRestProperty((EObject)eObj, (String)RestModelExtensionConstants.PropertyIds.REST_METHOD, (String)value.toUpperCase());
                    continue;
                }
                if (!keyStr.equals("rest:uri")) continue;
                RestModelExtensionAssistant.setRestProperty((EObject)eObj, (String)RestModelExtensionConstants.PropertyIds.URI, (String)value);
            }
        }
        try {
            ModelResource mdlResc = ModelUtilities.getModelResourceForIFile((IFile)((IFile)modelFile), (boolean)false);
            if (mdlResc != null) {
                mdlResc.save((IProgressMonitor)new NullProgressMonitor(), true);
            }
            modelFile.deleteMarkers("org.teiid.designer.extension.ui.medMarker", true, 2);
            modelFile.getParent().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            UiConstants.Util.log(4, (Throwable)e, NLS.bind((String)Messages.saveModelErrorMsg, (Object)modelFile.getName()));
        }
    }

    private static Shell getShell() {
        return UiPlugin.getDefault().getCurrentWorkbenchWindow().getShell();
    }
}

