/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.wizards.rest;

import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.widgets.Shell;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.core.designer.util.StringUtilities;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.core.workspace.ModelWorkspaceItem;
import org.teiid.designer.core.workspace.ModelWorkspaceManager;
import org.teiid.designer.datatools.connection.ConnectionInfoHelper;
import org.teiid.designer.datatools.connection.DataSourceConnectionHelper;
import org.teiid.designer.datatools.profiles.ws.WSConnectionInfoProvider;
import org.teiid.designer.datatools.profiles.xml.XmlFileConnectionInfoProvider;
import org.teiid.designer.datatools.profiles.xml.XmlUrlConnectionInfoProvider;
import org.teiid.designer.datatools.ui.DatatoolsUiConstants;
import org.teiid.designer.runtime.spi.ITeiidServer;
import org.teiid.designer.transformation.ui.wizards.file.FlatFileRelationalModelFactory;
import org.teiid.designer.transformation.ui.wizards.file.TeiidMetadataImportInfo;
import org.teiid.designer.transformation.ui.wizards.file.TeiidMetadataImportProcessor;
import org.teiid.designer.transformation.ui.wizards.xmlfile.TeiidXmlFileInfo;
import org.teiid.designer.transformation.ui.wizards.xmlfile.XmlFileViewModelFactory;
import org.teiid.designer.ui.editors.ModelEditor;
import org.teiid.designer.ui.editors.ModelEditorManager;

public class TeiidRestImportProcessor
extends TeiidMetadataImportProcessor {
    public TeiidRestImportProcessor(TeiidMetadataImportInfo info, Shell shell) {
        super(info, shell);
    }

    @Override
    protected ModelResource createViewsInExistingModel(String relationalModelName) throws ModelerCoreException {
        if (this.getInfo().getViewModelLocation() != null && this.getInfo().getViewModelName() != null) {
            ModelWorkspaceItem item;
            ModelEditor editor;
            IPath modelPath = this.getInfo().getViewModelLocation().append(this.getInfo().getViewModelName());
            if (!modelPath.toString().toUpperCase().endsWith(".XMI")) {
                modelPath = modelPath.addFileExtension("xmi");
            }
            if ((editor = ModelEditorManager.getModelEditorForFile((IFile)((IFile)(item = ModelWorkspaceManager.getModelWorkspaceManager().findModelWorkspaceItem(modelPath, 1)).getCorrespondingResource()), (boolean)true)) != null) {
                boolean isDirty = editor.isDirty();
                XmlFileViewModelFactory factory = new XmlFileViewModelFactory();
                for (TeiidXmlFileInfo info : this.getInfo().getXmlFileInfos()) {
                    if (!info.doProcess()) continue;
                    factory.createViewProcedure(editor.getModelResource(), info, relationalModelName);
                }
                editor.getModelResource().save(null, true);
                if (!isDirty && editor.isDirty()) {
                    editor.doSave((IProgressMonitor)new NullProgressMonitor());
                }
                return editor.getModelResource();
            }
        }
        return null;
    }

    @Override
    protected ModelResource createViewsInNewModel(String sourceModelName) throws ModelerCoreException {
        XmlFileViewModelFactory factory = new XmlFileViewModelFactory();
        String viewModelName = this.getInfo().getViewModelName();
        if (!viewModelName.toLowerCase().endsWith(".xmi")) {
            viewModelName = String.valueOf(viewModelName) + ".xmi";
        }
        ModelResource modelResource = factory.createViewRelationalModel(this.getInfo().getViewModelLocation(), viewModelName);
        for (TeiidXmlFileInfo info : this.getInfo().getXmlFileInfos()) {
            if (!info.doProcess()) continue;
            factory.createViewProcedure(modelResource, info, sourceModelName);
        }
        return modelResource;
    }

    @Override
    protected void addConnectionProfileInfoToModel(ModelResource sourceModel, TeiidMetadataImportInfo info) throws ModelWorkspaceException {
        if (info.getConnectionProfile() != null) {
            String jndiName;
            Object provider = null;
            if (this.getInfo().isXmlLocalFileMode()) {
                provider = new XmlFileConnectionInfoProvider();
            } else if (this.getInfo().isRestUrlFileMode()) {
                provider = "org.teiid.designer.datatools.profiles.ws.WSConnectionProfile".equalsIgnoreCase(info.getConnectionProfile().getProviderId()) ? new WSConnectionInfoProvider() : new XmlUrlConnectionInfoProvider();
            }
            if (provider != null) {
                provider.setConnectionInfo(sourceModel, info.getConnectionProfile());
            }
            if (!StringUtilities.isEmpty((String)(jndiName = info.getJBossJndiName()))) {
                ConnectionInfoHelper helper = new ConnectionInfoHelper();
                helper.setJNDIName(sourceModel, jndiName);
            }
        }
    }

    @Override
    protected ModelResource addProcedureToRelationalSourceModel() throws ModelerCoreException {
        if (this.getInfo().isXmlLocalFileMode()) {
            return super.addProcedureToRelationalSourceModel();
        }
        if (this.getInfo().getSourceModelLocation() != null && this.getInfo().getSourceModelName() != null) {
            ModelWorkspaceItem item;
            ModelEditor editor;
            IPath modelPath = this.getInfo().getSourceModelLocation().append(this.getInfo().getSourceModelName());
            if (!modelPath.toString().toUpperCase().endsWith(".XMI")) {
                modelPath = modelPath.addFileExtension("xmi");
            }
            if ((editor = ModelEditorManager.getModelEditorForFile((IFile)((IFile)(item = ModelWorkspaceManager.getModelWorkspaceManager().findModelWorkspaceItem(modelPath, 1)).getCorrespondingResource()), (boolean)true)) != null) {
                ModelResource mr = editor.getModelResource();
                boolean isDirty = editor.isDirty();
                FlatFileRelationalModelFactory factory = new FlatFileRelationalModelFactory();
                factory.addMissingProcedure(mr, "invokeHttp");
                mr.save(null, true);
                if (!isDirty && editor.isDirty()) {
                    editor.doSave((IProgressMonitor)new NullProgressMonitor());
                }
                return mr;
            }
        }
        return null;
    }

    @Override
    protected void handleCreateDataSource() {
        ITeiidServer teiidServer;
        if (this.getInfo().doCreateDataSource() && DataSourceConnectionHelper.isServerConnected() && (teiidServer = ModelerCore.getTeiidServerManager().getDefaultServer()).isConnected()) {
            String dsName = this.getInfo().getJBossJndiName();
            String jndiName = this.getInfo().getJBossJndiName();
            DataSourceConnectionHelper helper = new DataSourceConnectionHelper(this.getSourceModel(), this.getInfo().getConnectionProfile());
            Properties connProps = helper.getModelConnectionProperties();
            String dsType = helper.getDataSourceType();
            try {
                teiidServer.getOrCreateDataSource(dsName, jndiName, dsType, connProps);
            }
            catch (Exception e) {
                DatatoolsUiConstants.UTIL.log((Throwable)e);
            }
            try {
                teiidServer.getOrCreateDataSource(dsName, jndiName, dsType, connProps);
            }
            catch (Exception e) {
                DatatoolsUiConstants.UTIL.log((Throwable)e);
            }
        }
    }
}

