/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.wizards.xmlfile;

import java.util.Properties;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.transformation.ui.UiConstants;
import org.teiid.designer.transformation.ui.wizards.file.TeiidMetadataImportInfo;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.widget.DefaultScrolledComposite;
import org.teiid.designer.ui.common.wizard.AbstractWizardPage;
import org.teiid.designer.ui.viewsupport.DesignerPropertiesUtil;

public class TeiidXmlImportOptionsPage
extends AbstractWizardPage
implements UiConstants {
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix(TeiidXmlImportOptionsPage.class);
    private static final String TITLE = TeiidXmlImportOptionsPage.getString("title");
    private Button xmlFileOptionButton;
    private Button xmlUrlOptionButton;
    private final TeiidMetadataImportInfo fileInfo;
    private Properties designerProperties;
    private boolean synchronizing = false;

    private static String getString(String id) {
        return Util.getString(String.valueOf(I18N_PREFIX) + id, new Object[0]);
    }

    public TeiidXmlImportOptionsPage(TeiidMetadataImportInfo fileInfo) {
        super(TeiidXmlImportOptionsPage.class.getSimpleName(), TITLE);
        this.fileInfo = fileInfo;
    }

    public void createControl(Composite parent) {
        Composite hostPanel = new Composite(parent, 0);
        hostPanel.setLayout((Layout)new GridLayout(1, false));
        hostPanel.setLayoutData((Object)new GridData(1808));
        DefaultScrolledComposite scrolledComposite = new DefaultScrolledComposite(hostPanel);
        hostPanel.setLayout((Layout)new GridLayout(1, false));
        hostPanel.setLayoutData((Object)new GridData(1808));
        Composite mainPanel = scrolledComposite.getPanel();
        mainPanel.setLayoutData((Object)new GridData(1808));
        mainPanel.setLayout((Layout)new GridLayout(1, false));
        Group descriptionGroup = WidgetFactory.createGroup((Composite)mainPanel, (String)TeiidXmlImportOptionsPage.getString("description"), (int)768);
        ((GridData)descriptionGroup.getLayoutData()).minimumWidth = 400;
        Text descriptionText = new Text((Composite)descriptionGroup, 72);
        GridData gd = new GridData(4, 0x1000000, true, false);
        gd.heightHint = 120;
        gd.widthHint = 300;
        descriptionText.setLayoutData((Object)gd);
        descriptionText.setText(TeiidXmlImportOptionsPage.getString("descriptionMessage"));
        descriptionText.setBackground(mainPanel.getBackground());
        descriptionText.setForeground(Display.getCurrent().getSystemColor(10));
        Group mainGroup = WidgetFactory.createGroup((Composite)mainPanel, (String)TeiidXmlImportOptionsPage.getString("xmlOptionsGroup"), (int)2048);
        mainGroup.setLayoutData((Object)new GridData(768));
        this.xmlFileOptionButton = WidgetFactory.createRadioButton((Composite)mainGroup, (String)TeiidXmlImportOptionsPage.getString("localXmlFileOption"), (boolean)true);
        this.xmlFileOptionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (!TeiidXmlImportOptionsPage.this.synchronizing) {
                    TeiidXmlImportOptionsPage.this.optionButtonSelected();
                }
            }
        });
        this.xmlUrlOptionButton = WidgetFactory.createRadioButton((Composite)mainGroup, (String)TeiidXmlImportOptionsPage.getString("urlXmlFileOption"));
        this.xmlUrlOptionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (!TeiidXmlImportOptionsPage.this.synchronizing) {
                    TeiidXmlImportOptionsPage.this.optionButtonSelected();
                }
            }
        });
        scrolledComposite.sizeScrolledPanel();
        this.setControl((Control)hostPanel);
        this.setMessage(TeiidXmlImportOptionsPage.getString("message"));
        this.setPageComplete(true);
    }

    void optionButtonSelected() {
        if (this.xmlFileOptionButton.getSelection()) {
            this.fileInfo.setFileMode(2);
        } else {
            this.fileInfo.setFileMode(3);
        }
    }

    void synchronizeUI() {
        this.synchronizing = true;
        this.synchronizing = false;
    }

    public void setVisible(boolean visible) {
        boolean value;
        super.setVisible(visible);
        if (visible && this.designerProperties != null && (value = DesignerPropertiesUtil.isImportXmlRemote((Properties)this.designerProperties))) {
            this.xmlFileOptionButton.setSelection(false);
            this.xmlUrlOptionButton.setSelection(true);
            this.optionButtonSelected();
        }
    }

    public void setDesignerProperties(Properties properties) {
        this.designerProperties = properties;
    }
}

