/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.wizards.xmlfile;

import java.util.HashMap;
import java.util.Map;
import org.teiid.designer.transformation.ui.wizards.xmlfile.XmlAttribute;
import org.teiid.designer.transformation.ui.wizards.xmlfile.XmlElement;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlFileContentHandler
extends DefaultHandler {
    private XmlElement rootElement;
    private XmlElement parentElement;
    private Map<String, String> namespaceMap = new HashMap<String, String>();

    @Override
    public void startElement(String uri, String lName, String qName, Attributes attributes) throws SAXException {
        if (this.rootElement == null) {
            this.rootElement = new XmlElement(qName);
            if (attributes != null) {
                int attributeLength = attributes.getLength();
                int i = 0;
                while (i < attributeLength) {
                    String value = attributes.getValue(i);
                    String localName = attributes.getLocalName(i);
                    this.rootElement.addChildAttribute(new XmlAttribute(localName, value, this.rootElement));
                    ++i;
                }
            }
            this.parentElement = this.rootElement;
        } else {
            XmlElement newElement = new XmlElement(qName);
            if (attributes != null) {
                int attributeLength = attributes.getLength();
                int i = 0;
                while (i < attributeLength) {
                    String value = attributes.getValue(i);
                    String localName = attributes.getLocalName(i);
                    newElement.addChildAttribute(new XmlAttribute(localName, value, newElement));
                    ++i;
                }
            }
            this.parentElement.addChildElement(newElement);
            this.parentElement = newElement;
        }
        super.startElement(uri, lName, qName, attributes);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.parentElement = this.parentElement.getParent();
        super.endElement(uri, localName, qName);
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (!this.namespaceMap.containsKey(prefix)) {
            this.namespaceMap.put(prefix, uri);
        }
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public XmlElement getRootElement() {
        return this.rootElement;
    }

    public Map<String, String> getNamespaceMap() {
        return this.namespaceMap;
    }
}

