/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ILabelProvider;
import org.teiid.designer.diagram.ui.DiagramUiConstants;
import org.teiid.designer.diagram.ui.NotationChangeListener;
import org.teiid.designer.diagram.ui.PluginConstants;
import org.teiid.designer.diagram.ui.actions.NotationChoiceRadioActionGroup;
import org.teiid.designer.diagram.ui.notation.NotationFigureGenerator;
import org.teiid.designer.diagram.ui.notation.NotationModelGenerator;
import org.teiid.designer.diagram.ui.notation.NotationPartGenerator;
import org.teiid.designer.diagram.ui.preferences.NotationIDAndName;

public class DiagramNotationManager
implements PluginConstants,
DiagramUiConstants,
DiagramUiConstants.ExtensionPoints,
NotationChangeListener {
    private NotationPartGenerator depfCurrentPartGenerator;
    private NotationModelGenerator dmfCurrentModelGenerator;
    private NotationFigureGenerator fgfCurrentFigureGenerator;
    private List<NotationIDAndName> notationSelectionList;
    private String sCurrentExtensionUid = null;
    private ILabelProvider labelProvider;
    private IExtension[] exExtensions;
    private HashMap<String, IExtension> hmExtensions;
    private HashMap<String, IConfigurationElement> hmEditPartGeneratorElements;
    private HashMap<String, IConfigurationElement> hmDiagramModelGeneratorElements;
    private HashMap<String, IConfigurationElement> hmFigureGeneratorElements;
    private NotationChangeListener nclNotationListener;

    public DiagramNotationManager() {
        this.loadNotationExtensions();
        this.establishInitialNotationExtension();
    }

    public String getExtensionDisplayName(String sExtensionId) {
        IExtension ex = this.hmExtensions.get(sExtensionId);
        if (ex != null) {
            return ex.getLabel();
        }
        return "Unknown extension id...";
    }

    public String getCurrentExtensionId() {
        return this.sCurrentExtensionUid;
    }

    public List<String> getExtensionIds() {
        return new ArrayList<String>(this.hmExtensions.keySet());
    }

    public NotationPartGenerator getEditPartGenerator() {
        if (this.depfCurrentPartGenerator == null) {
            this.setEditPartGenerator(this.getEditPartGeneratorClassExecutable(this.sCurrentExtensionUid));
        }
        return this.depfCurrentPartGenerator;
    }

    public NotationPartGenerator getEditPartGenerator(String sExtensionId) {
        NotationPartGenerator depf = this.getEditPartGeneratorClassExecutable(sExtensionId);
        return depf;
    }

    public void setEditPartGenerator(NotationPartGenerator epfGenerator) {
        this.depfCurrentPartGenerator = epfGenerator;
    }

    public NotationModelGenerator getDiagramModelGenerator() {
        if (this.dmfCurrentModelGenerator == null) {
            this.setDiagramModelGenerator(this.getDiagramModelGeneratorClassExecutable(this.sCurrentExtensionUid));
        }
        return this.dmfCurrentModelGenerator;
    }

    public NotationModelGenerator getDiagramModelGenerator(String sExtensionId) {
        return this.getDiagramModelGeneratorClassExecutable(sExtensionId);
    }

    public void setDiagramModelGenerator(NotationModelGenerator dmfGenerator) {
        this.dmfCurrentModelGenerator = dmfGenerator;
    }

    public NotationFigureGenerator getFigureGenerator() {
        if (this.fgfCurrentFigureGenerator == null) {
            this.setFigureGenerator(this.getFigureGeneratorClassExecutable(this.sCurrentExtensionUid));
        }
        return this.fgfCurrentFigureGenerator;
    }

    public NotationFigureGenerator getFigureGenerator(String sExtensionId) {
        return this.getFigureGeneratorClassExecutable(sExtensionId);
    }

    public void setFigureGenerator(NotationFigureGenerator fgfGenerator) {
        this.fgfCurrentFigureGenerator = fgfGenerator;
    }

    private void loadNotationExtensions() {
        IExtension[] exExtensions = this.getDiagramNotationExtensions();
        this.hmExtensions = new HashMap();
        this.hmEditPartGeneratorElements = new HashMap();
        this.hmDiagramModelGeneratorElements = new HashMap();
        this.hmFigureGeneratorElements = new HashMap();
        this.notationSelectionList = new ArrayList<NotationIDAndName>(exExtensions.length);
        int iExtensionIndex = 0;
        while (iExtensionIndex < exExtensions.length) {
            this.hmExtensions.put(exExtensions[iExtensionIndex].getUniqueIdentifier(), exExtensions[iExtensionIndex]);
            String sExtensionId = exExtensions[iExtensionIndex].getUniqueIdentifier();
            IConfigurationElement[] elements = exExtensions[iExtensionIndex].getConfigurationElements();
            String sElementName = null;
            int iElementIndex = 0;
            while (iElementIndex < elements.length) {
                String displayName;
                sElementName = elements[iElementIndex].getName();
                if (sElementName.equals("editPartGenerator")) {
                    this.hmEditPartGeneratorElements.put(sExtensionId, elements[iElementIndex]);
                } else if (sElementName.equals("diagramModelGenerator")) {
                    this.hmDiagramModelGeneratorElements.put(sExtensionId, elements[iElementIndex]);
                } else if (sElementName.equals("figureGenerator")) {
                    this.hmFigureGeneratorElements.put(sExtensionId, elements[iElementIndex]);
                }
                if (sElementName.equals("notationPreferences") && (displayName = elements[iElementIndex].getAttribute("displayName")) != null) {
                    NotationIDAndName newIDandName = new NotationIDAndName(exExtensions[iExtensionIndex].getSimpleIdentifier(), displayName);
                    this.notationSelectionList.add(newIDandName);
                }
                ++iElementIndex;
            }
            ++iExtensionIndex;
        }
    }

    private void establishInitialNotationExtension() {
        String simpleExtensionID = "umlDiagramNotation";
        IExtension[] exExtensions = this.getDiagramNotationExtensions();
        if (exExtensions.length > 0) {
            boolean foundDefault = false;
            int i = 0;
            while (i < exExtensions.length) {
                String extensionID = exExtensions[i].getSimpleIdentifier();
                if (extensionID.equals(simpleExtensionID)) {
                    foundDefault = true;
                    this.sCurrentExtensionUid = exExtensions[i].getUniqueIdentifier();
                }
                if (foundDefault) break;
                ++i;
            }
            if (!foundDefault) {
                this.sCurrentExtensionUid = exExtensions[0].getUniqueIdentifier();
            }
        }
    }

    private IExtension[] getDiagramNotationExtensions() {
        if (this.exExtensions == null) {
            IExtensionPoint epExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.teiid.designer.diagram.ui", "diagramNotation");
            this.exExtensions = epExtensionPoint.getExtensions();
        }
        return this.exExtensions;
    }

    private NotationPartGenerator getEditPartGeneratorClassExecutable(String sExtensionUid) {
        Object oExecutableExtension = null;
        IConfigurationElement ceElement = null;
        try {
            ceElement = this.hmEditPartGeneratorElements.get(sExtensionUid);
            oExecutableExtension = ceElement.createExecutableExtension("class");
        }
        catch (CoreException ce) {
            ce.printStackTrace();
        }
        if (oExecutableExtension instanceof NotationPartGenerator) {
            return (NotationPartGenerator)oExecutableExtension;
        }
        return null;
    }

    private NotationModelGenerator getDiagramModelGeneratorClassExecutable(String sExtensionUid) {
        Object oExecutableExtension = null;
        IConfigurationElement ceElement = null;
        try {
            ceElement = this.hmDiagramModelGeneratorElements.get(sExtensionUid);
            oExecutableExtension = ceElement.createExecutableExtension("class");
        }
        catch (CoreException ce) {
            ce.printStackTrace();
        }
        if (oExecutableExtension instanceof NotationModelGenerator) {
            return (NotationModelGenerator)oExecutableExtension;
        }
        return null;
    }

    private NotationFigureGenerator getFigureGeneratorClassExecutable(String sExtensionUid) {
        Object oExecutableExtension = null;
        IConfigurationElement ceElement = null;
        try {
            ceElement = this.hmFigureGeneratorElements.get(sExtensionUid);
            oExecutableExtension = ceElement.createExecutableExtension("class");
        }
        catch (CoreException ce) {
            ce.printStackTrace();
        }
        if (oExecutableExtension instanceof NotationFigureGenerator) {
            return (NotationFigureGenerator)oExecutableExtension;
        }
        return null;
    }

    public void setLabelProvider(ILabelProvider provider) {
        this.labelProvider = provider;
    }

    public ILabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    public void setNotationChangeListener(NotationChangeListener nclNotationListener) {
        this.nclNotationListener = nclNotationListener;
    }

    public NotationChangeListener getNotationChangeListener() {
        return this.nclNotationListener;
    }

    @Override
    public void setNotationId(String sNotationId) {
    }

    public MenuManager getNotationActionGroup(NotationChangeListener ncl, String currentNotationId) {
        if (this.exExtensions != null && this.exExtensions.length > 1) {
            return new NotationChoiceRadioActionGroup(ncl, currentNotationId);
        }
        return null;
    }

    public List<NotationIDAndName> getDiagramNotationInfo() {
        return this.notationSelectionList;
    }
}

