/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.diagram.ui.DiagramUiConstants;
import org.teiid.designer.diagram.ui.IDiagramType;
import org.teiid.designer.diagram.ui.PluginConstants;
import org.teiid.designer.diagram.ui.editor.CanOpenContextException;
import org.teiid.designer.diagram.ui.pakkage.PackageDiagramProvider;
import org.teiid.designer.diagram.ui.preferences.DiagramColorObject;
import org.teiid.designer.diagram.ui.util.DiagramUiUtilities;
import org.teiid.designer.metamodels.diagram.Diagram;
import org.teiid.designer.metamodels.diagram.impl.DiagramEntityImpl;
import org.teiid.designer.ui.common.util.WidgetUtil;

public class DiagramTypeManager
implements PluginConstants,
DiagramUiConstants,
DiagramUiConstants.ExtensionPoints {
    private IExtension[] exExtensions;
    private HashMap<String, IExtension> hmExtensionsByExtensionId;
    private HashMap<String, IConfigurationElement> hmDiagramTypeElements;
    private HashMap<String, IDiagramType> diagramTypeMap;
    private List<String> orderedExtentionIDs;
    private List<DiagramColorObject> bkgdColorList;

    public DiagramTypeManager() {
        this.loadAllExtensions();
    }

    private void loadAllExtensions() {
        IExtension[] exExtensions = this.getDiagramTypeExtensions();
        this.hmExtensionsByExtensionId = new HashMap();
        this.hmDiagramTypeElements = new HashMap();
        this.diagramTypeMap = new HashMap();
        int iExtensionIndex = 0;
        while (iExtensionIndex < exExtensions.length) {
            this.hmExtensionsByExtensionId.put(exExtensions[iExtensionIndex].getSimpleIdentifier(), exExtensions[iExtensionIndex]);
            String sExtensionId = exExtensions[iExtensionIndex].getSimpleIdentifier();
            IConfigurationElement[] elements = exExtensions[iExtensionIndex].getConfigurationElements();
            String sElementName = null;
            int iElementIndex = 0;
            while (iElementIndex < elements.length) {
                sElementName = elements[iElementIndex].getName();
                if (sElementName.equals("diagram")) {
                    this.hmDiagramTypeElements.put(sExtensionId, elements[iElementIndex]);
                }
                ++iElementIndex;
            }
            ++iExtensionIndex;
        }
        this.setOrderedExtentionIds();
    }

    private IExtension[] getDiagramTypeExtensions() {
        if (this.exExtensions == null) {
            IExtensionPoint epExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.teiid.designer.diagram.ui", "diagramType");
            this.exExtensions = epExtensionPoint.getExtensions();
        }
        return this.exExtensions;
    }

    public boolean isDiagramSimple(String sDiagramTypeId) {
        IConfigurationElement ceElement = this.hmDiagramTypeElements.get(sDiagramTypeId);
        String simpleDiagram = ceElement.getAttribute("simpleDiagram");
        return simpleDiagram != null && simpleDiagram.equalsIgnoreCase("true");
    }

    public boolean isTransientDiagram(Diagram diagram) {
        boolean isTransient = false;
        Iterator<String> iter = this.getOrderedExtentionIds().iterator();
        String nextExtensionID = null;
        IDiagramType nextDiagramType = null;
        while (iter.hasNext() && !isTransient) {
            nextExtensionID = iter.next();
            nextDiagramType = this.getDiagram(nextExtensionID);
            if (nextDiagramType == null) continue;
            isTransient = nextDiagramType.isTransientDiagram(diagram);
        }
        return isTransient;
    }

    public boolean isDeprecatedDiagram(String diagramTypeId) {
        IConfigurationElement ceElement = this.hmDiagramTypeElements.get(diagramTypeId);
        String deprecatedDiagram = ceElement.getAttribute("deprecated");
        return deprecatedDiagram != null && deprecatedDiagram.equalsIgnoreCase("true");
    }

    public IDiagramType getDiagram(String sDiagramTypeId) {
        return this.getDiagramTypeClassExecutable(sDiagramTypeId);
    }

    private IDiagramType getDiagramTypeClassExecutable(String sExtensionId) {
        IDiagramType diagramType = null;
        IConfigurationElement ceElement = null;
        if (this.diagramTypeMap != null) {
            diagramType = this.diagramTypeMap.get(sExtensionId);
        }
        if (diagramType == null) {
            try {
                ceElement = this.hmDiagramTypeElements.get(sExtensionId);
                Object oExecutableExtension = ceElement.createExecutableExtension("class");
                if (oExecutableExtension instanceof IDiagramType) {
                    diagramType = (IDiagramType)oExecutableExtension;
                    diagramType.setType(sExtensionId);
                    this.diagramTypeMap.put(sExtensionId, diagramType);
                }
            }
            catch (CoreException ce) {
                ce.printStackTrace();
            }
        }
        return diagramType;
    }

    public boolean canOpenContext(Object input) {
        boolean canOpen = false;
        if (input instanceof DiagramEntityImpl) {
            Diagram parentDiagram = ((DiagramEntityImpl)input).getDiagram();
            if (parentDiagram != null) {
                canOpen = true;
            }
        } else {
            List<String> extensionIDs = this.getOrderedExtentionIds();
            try {
                Iterator<String> iter = extensionIDs.iterator();
                String nextExtensionID = null;
                IDiagramType nextDiagramType = null;
                while (iter.hasNext() && !canOpen) {
                    nextExtensionID = iter.next();
                    nextDiagramType = this.getDiagram(nextExtensionID);
                    if (nextDiagramType == null) continue;
                    canOpen = nextDiagramType.canOpenContext(input);
                }
            }
            catch (CanOpenContextException ex) {
                WidgetUtil.showWarning((String)ex.getMessage());
                canOpen = false;
            }
        }
        return canOpen;
    }

    public Diagram getDiagramForContext(Object input) {
        Diagram diagram = null;
        if (input instanceof DiagramEntityImpl) {
            Diagram parentDiagram = ((DiagramEntityImpl)input).getDiagram();
            if (parentDiagram != null) {
                diagram = parentDiagram;
            }
        } else {
            List<String> extensionIDs = this.getOrderedExtentionIds();
            Iterator<String> iter = extensionIDs.iterator();
            String nextExtensionID = null;
            IDiagramType nextDiagramType = null;
            while (iter.hasNext() && diagram == null) {
                nextExtensionID = iter.next();
                nextDiagramType = this.getDiagram(nextExtensionID);
                if (nextDiagramType == null) continue;
                diagram = nextDiagramType.getDiagramForContext(input);
            }
        }
        return diagram;
    }

    public List<DiagramColorObject> getDiagramColorInfo() {
        if (this.bkgdColorList == null) {
            this.bkgdColorList = new ArrayList<DiagramColorObject>();
            List<String> extensionIDs = this.getOrderedExtentionIds();
            DiagramColorObject dco = null;
            Iterator<String> iter = extensionIDs.iterator();
            String nextExtensionID = null;
            IDiagramType nextDiagramType = null;
            while (iter.hasNext()) {
                nextExtensionID = iter.next();
                if (this.isDeprecatedDiagram(nextExtensionID) || (nextDiagramType = this.getDiagram(nextExtensionID)) == null || (dco = nextDiagramType.getBackgroundColorObject(nextDiagramType.getType())) == null) continue;
                this.bkgdColorList.add(dco);
            }
        }
        return this.bkgdColorList;
    }

    public Diagram getPackageDiagram(ModelResource resource, EObject packageEObject, boolean forceCreate) {
        Diagram someDiagram = null;
        List<String> extensionIDs = this.getOrderedExtentionIds();
        Iterator<String> iter = extensionIDs.iterator();
        String nextExtensionID = null;
        IDiagramType nextDiagramType = null;
        while (iter.hasNext() && someDiagram == null) {
            nextExtensionID = iter.next();
            nextDiagramType = this.getDiagram(nextExtensionID);
            if (nextDiagramType.getPackageDiagramProvider() == null) continue;
            someDiagram = nextDiagramType.getPackageDiagramProvider().getPackageDiagram(resource, packageEObject, forceCreate);
        }
        return someDiagram;
    }

    public Diagram getDiagramForGoToMarkerEObject(EObject eObject, boolean forceCreate) {
        EObject parentPackage;
        PackageDiagramProvider pdp;
        Diagram someDiagram = null;
        List<String> extensionIDs = this.getOrderedExtentionIds();
        Iterator<String> iter = extensionIDs.iterator();
        String nextExtensionID = null;
        IDiagramType nextDiagramType = null;
        while (iter.hasNext() && someDiagram == null) {
            nextExtensionID = iter.next();
            nextDiagramType = this.getDiagram(nextExtensionID);
            someDiagram = nextDiagramType.getDiagramForGoToMarkerEObject(eObject);
        }
        if (someDiagram == null && (someDiagram = (pdp = new PackageDiagramProvider()).getPackageDiagram(eObject, forceCreate)) == null && (parentPackage = DiagramUiUtilities.getParentPackage(eObject)) != null) {
            someDiagram = pdp.getPackageDiagram(parentPackage, forceCreate);
        }
        return someDiagram;
    }

    public String getDisplayedPath(Diagram diagram, EObject eObject) {
        IDiagramType theDiagramType;
        String somePath = null;
        if (diagram != null && eObject != null && (theDiagramType = this.getDiagram(diagram.getType())) != null) {
            somePath = theDiagramType.getDisplayedPath(diagram, eObject);
        }
        return somePath;
    }

    private List<String> getOrderedExtentionIds() {
        if (this.orderedExtentionIDs == null) {
            return Collections.emptyList();
        }
        return this.orderedExtentionIDs;
    }

    private void setOrderedExtentionIds() {
        ArrayList<String> rawList = new ArrayList<String>(this.hmExtensionsByExtensionId.keySet());
        this.orderedExtentionIDs = new ArrayList<String>(rawList.size());
        Iterator iter = rawList.iterator();
        String pkgType = null;
        String nextID = null;
        while (iter.hasNext()) {
            nextID = (String)iter.next();
            if (nextID.equals("packageDiagramType")) {
                pkgType = nextID;
                continue;
            }
            this.orderedExtentionIDs.add(nextID);
        }
        if (pkgType != null) {
            this.orderedExtentionIDs.add(pkgType);
        }
    }
}

