/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui;

import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.osgi.framework.BundleContext;
import org.teiid.core.designer.PluginUtil;
import org.teiid.core.designer.util.PluginUtilImpl;
import org.teiid.designer.diagram.ui.DiagramNotationManager;
import org.teiid.designer.diagram.ui.DiagramTypeManager;
import org.teiid.designer.diagram.ui.DiagramUiConstants;
import org.teiid.designer.diagram.ui.PluginConstants;
import org.teiid.designer.diagram.ui.actions.DiagramActionService;
import org.teiid.designer.diagram.ui.editor.DiagramActionContributor;
import org.teiid.designer.diagram.ui.editor.DiagramEditor;
import org.teiid.designer.diagram.ui.editor.DiagramEditorUtil;
import org.teiid.designer.diagram.ui.util.AspectManager;
import org.teiid.designer.ui.common.AbstractUiPlugin;
import org.teiid.designer.ui.common.PreferenceKeyAndDefaultValue;
import org.teiid.designer.ui.common.actions.ActionService;
import org.teiid.designer.ui.editors.AbstractModelEditorPageActionBarContributor;
import org.teiid.designer.ui.editors.ModelEditorPage;

public class DiagramUiPlugin
extends AbstractUiPlugin
implements DiagramUiConstants {
    private static DiagramUiPlugin plugin;
    private static DiagramNotationManager notationManager;
    private static DiagramTypeManager diagramTypeManager;
    private static AspectManager amDiagramAspectManager;
    private static DiagramActionContributor dacDiagramActionContributor;

    public static DiagramUiPlugin getDefault() {
        return plugin;
    }

    public static DiagramNotationManager getDiagramNotationManager() {
        if (notationManager == null) {
            notationManager = new DiagramNotationManager();
        }
        return notationManager;
    }

    public static DiagramTypeManager getDiagramTypeManager() {
        if (diagramTypeManager == null) {
            diagramTypeManager = new DiagramTypeManager();
        }
        return diagramTypeManager;
    }

    public static AspectManager getDiagramAspectManager() {
        if (amDiagramAspectManager == null) {
            amDiagramAspectManager = new AspectManager("umlDiagramAspect");
        }
        return amDiagramAspectManager;
    }

    public static void registerDiagramActionForSelection(ISelectionListener action) {
        ActionService actionService = DiagramUiPlugin.getDefault().getActionService(DiagramUiPlugin.getDefault().getCurrentWorkbenchWindow().getActivePage());
        actionService.addWorkbenchSelectionListener(action);
    }

    public static void unregisterDiagramActionForSelection(ISelectionListener action) {
        ActionService actionService = DiagramUiPlugin.getDefault().getActionService(DiagramUiPlugin.getDefault().getCurrentWorkbenchWindow().getActivePage());
        actionService.removeWorkbenchSelectionListener(action);
    }

    public static void updateEditorForPreferences() {
        DiagramEditor[] editors = DiagramEditorUtil.getInitializedDiagramEditors();
        int i = 0;
        while (i < editors.length) {
            DiagramEditor editor = editors[i];
            editor.updateDiagramPreferences();
            ++i;
        }
    }

    public DiagramUiPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        ((PluginUtilImpl)Util).initializePlatformLogger((Plugin)this);
        this.storeDefaultPreferenceValues();
    }

    protected ActionService createActionService(IWorkbenchPage page) {
        return new DiagramActionService(page);
    }

    public PluginUtil getPluginUtil() {
        return Util;
    }

    private void storeDefaultPreferenceValues() {
        IPreferenceStore preferenceStore = DiagramUiPlugin.getDefault().getPreferenceStore();
        int i = 0;
        while (i < PluginConstants.Prefs.PREFERENCES.length) {
            PreferenceKeyAndDefaultValue.storePreferenceDefault((IPreferenceStore)preferenceStore, (PreferenceKeyAndDefaultValue)PluginConstants.Prefs.PREFERENCES[i]);
            ++i;
        }
        i = 0;
        while (i < PluginConstants.Prefs.Appearance.PREFERENCES.length) {
            PreferenceKeyAndDefaultValue.storePreferenceDefault((IPreferenceStore)preferenceStore, (PreferenceKeyAndDefaultValue)PluginConstants.Prefs.Appearance.PREFERENCES[i]);
            ++i;
        }
        i = 0;
        while (i < PluginConstants.Prefs.Filter.PREFERENCES.length) {
            PreferenceKeyAndDefaultValue.storePreferenceDefault((IPreferenceStore)preferenceStore, (PreferenceKeyAndDefaultValue)PluginConstants.Prefs.Filter.PREFERENCES[i]);
            ++i;
        }
        i = 0;
        while (i < PluginConstants.Prefs.Print.PREFERENCES.length) {
            PreferenceKeyAndDefaultValue.storePreferenceDefault((IPreferenceStore)preferenceStore, (PreferenceKeyAndDefaultValue)PluginConstants.Prefs.Print.PREFERENCES[i]);
            ++i;
        }
        DiagramUiPlugin.getDefault().savePreferences();
    }

    public static AbstractModelEditorPageActionBarContributor getActionBarContributor(ModelEditorPage newPage) {
        if (dacDiagramActionContributor == null) {
            dacDiagramActionContributor = new DiagramActionContributor(newPage);
        } else {
            dacDiagramActionContributor.setEditorPage(newPage);
        }
        return dacDiagramActionContributor;
    }

    public void stop(BundleContext theContext) throws Exception {
        this.cleanUpWindowResources();
        super.stop(theContext);
    }

    private void cleanUpWindowResources() {
        if (!DiagramUiConstants.Colors.DEPENDENCY.isDisposed()) {
            DiagramUiConstants.Colors.DEPENDENCY.dispose();
        }
        if (!DiagramUiConstants.Colors.DEPENDENCY.isDisposed()) {
            DiagramUiConstants.Colors.GROUP_BKGRND.dispose();
        }
        if (!DiagramUiConstants.Colors.DEPENDENCY.isDisposed()) {
            DiagramUiConstants.Colors.GROUP_HEADER.dispose();
        }
        if (!DiagramUiConstants.Colors.DEPENDENCY.isDisposed()) {
            DiagramUiConstants.Colors.LOGICAL_GROUP_BKGRND.dispose();
        }
        if (!DiagramUiConstants.Colors.DEPENDENCY.isDisposed()) {
            DiagramUiConstants.Colors.LOGICAL_GROUP_HEADER.dispose();
        }
        if (!DiagramUiConstants.Colors.DEPENDENCY.isDisposed()) {
            DiagramUiConstants.Colors.OUTLINE.dispose();
        }
        if (!DiagramUiConstants.Colors.DEPENDENCY.isDisposed()) {
            DiagramUiConstants.Colors.TEMP_GROUP_BKGRND.dispose();
        }
        if (!DiagramUiConstants.Colors.DEPENDENCY.isDisposed()) {
            DiagramUiConstants.Colors.TEMP_GROUP_HEADER.dispose();
        }
        if (!DiagramUiConstants.Colors.DEPENDENCY.isDisposed()) {
            DiagramUiConstants.Colors.VIRTUAL_GROUP_BKGRND.dispose();
        }
        if (!DiagramUiConstants.Colors.DEPENDENCY.isDisposed()) {
            DiagramUiConstants.Colors.VIRTUAL_GROUP_HEADER.dispose();
        }
        if (!DiagramUiConstants.Colors.DEPENDENCY.isDisposed()) {
            DiagramUiConstants.Colors.VIRTUAL_RS_GROUP_HEADER.dispose();
        }
    }
}

