/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.teiid.designer.diagram.ui.DiagramUiConstants;
import org.teiid.designer.diagram.ui.actions.ActionWrapper;
import org.teiid.designer.diagram.ui.actions.DiagramAction;
import org.teiid.designer.diagram.ui.actions.IDiagramActionConstants;
import org.teiid.designer.diagram.ui.actions.IFontChangeListener;
import org.teiid.designer.diagram.ui.actions.ScaledFont;
import org.teiid.designer.diagram.ui.editor.DiagramEditor;
import org.teiid.designer.ui.editors.ModelEditor;

abstract class AbstractFontWrapper
extends DiagramAction
implements DiagramUiConstants,
IDiagramActionConstants,
IPartListener,
ActionWrapper,
IFontChangeListener {
    protected DiagramEditor diagramEditor;

    public AbstractFontWrapper(DiagramEditor editor) {
        this.diagramEditor = editor;
        this.initialize();
    }

    @Override
    public void initialize() {
        this.setEnableState();
        this.addAsPartListener();
        ScaledFont sfFontMgr = this.getFontManager();
        if (sfFontMgr != null) {
            sfFontMgr.removeFontChangeListener(this);
            sfFontMgr.addFontChangeListener(this);
        }
    }

    protected abstract IAction createAction();

    @Override
    protected void doRun() {
        ScaledFont fontMgr = this.getFontManager();
        if (fontMgr != null) {
            IAction action = this.createAction();
            action.run();
            this.setEnabled(this.getEnabledState());
        }
    }

    protected abstract boolean getEnabledState();

    private void addAsPartListener() {
        this.getPlugin().getCurrentWorkbenchWindow().getPartService().addPartListener((IPartListener)this);
    }

    public void dispose() {
        this.getPlugin().getCurrentWorkbenchWindow().getPartService().removePartListener((IPartListener)this);
        super.dispose();
    }

    public void selectionChanged(IWorkbenchPart thePart, ISelection theSelection) {
    }

    protected ScaledFont getFontManager() {
        return (ScaledFont)this.diagramEditor.getAdapter(ScaledFont.class);
    }

    protected abstract void setEnableState();

    public void partActivated(IWorkbenchPart part) {
        if (this.isEventForThisPart(part)) {
            this.setEnableState();
        }
    }

    public void partBroughtToTop(IWorkbenchPart part) {
        if (this.isEventForThisPart(part)) {
            this.setEnableState();
        }
    }

    public void partClosed(IWorkbenchPart part) {
        if (this.isEventForThisPart(part)) {
            this.getPlugin().getCurrentWorkbenchWindow().getPartService().removePartListener((IPartListener)this);
            this.getFontManager().removeFontChangeListener(this);
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
        if (this.isEventForThisPart(part)) {
            this.setEnableState();
        }
    }

    private boolean isEventForThisPart(IWorkbenchPart part) {
        return part instanceof ModelEditor && ((ModelEditor)part).getAllEditors().contains(this.diagramEditor);
    }

    public void partOpened(IWorkbenchPart part) {
        if (this.isEventForThisPart(part)) {
            this.setEnableState();
        }
    }

    @Override
    public void fontChanged() {
        this.setEnableState();
    }
}

