/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui.actions;

import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.teiid.designer.diagram.ui.DiagramUiPlugin;
import org.teiid.designer.diagram.ui.actions.IFontChangeListener;
import org.teiid.designer.diagram.ui.actions.ScaledFont;
import org.teiid.designer.diagram.ui.actions.ScaledFontManager;
import org.teiid.designer.diagram.ui.editor.DiagramViewer;
import org.teiid.designer.diagram.ui.part.DiagramEditPart;
import org.teiid.designer.ui.common.util.UiUtil;

public class DiagramFontManager
implements ScaledFont {
    private DiagramViewer viewer;
    private ListenerList listeners = new ListenerList(1);

    public DiagramFontManager(DiagramViewer viewer) {
        this.setFontFromPreferences();
        this.viewer = viewer;
    }

    public void setFontFromPreferences() {
        IPreferenceStore preferenceStore = DiagramUiPlugin.getDefault().getPreferenceStore();
        FontData fontData = PreferenceConverter.getFontData((IPreferenceStore)preferenceStore, (String)"modeler.preference.diagram.font");
        String currentName = fontData.getName();
        int currentSize = fontData.getHeight();
        int currentStyle = fontData.getStyle();
        ScaledFontManager.setFont(currentName, currentSize, currentStyle);
    }

    @Override
    public void increase() {
        ScaledFontManager.increase();
        DiagramEditPart diagram = (DiagramEditPart)this.viewer.getContents();
        diagram.refreshFont(true);
        diagram = (DiagramEditPart)this.viewer.getContents();
        diagram.layout();
        this.fireFontChanged();
    }

    @Override
    public void decrease() {
        ScaledFontManager.decrease();
        DiagramEditPart diagram = (DiagramEditPart)this.viewer.getContents();
        diagram.refreshFont(true);
        diagram = (DiagramEditPart)this.viewer.getContents();
        diagram.layout();
        this.fireFontChanged();
    }

    @Override
    public boolean canIncrease() {
        return ScaledFontManager.canIncrease();
    }

    @Override
    public boolean canDecrease() {
        return ScaledFontManager.canDecrease();
    }

    @Override
    public Font getFont() {
        return ScaledFontManager.getFont();
    }

    @Override
    public String getName() {
        return ScaledFontManager.getName();
    }

    @Override
    public int getSize() {
        return ScaledFontManager.getSize();
    }

    @Override
    public int getStyle() {
        return ScaledFontManager.getStyle();
    }

    @Override
    public void setFont(Font newFont) {
        ScaledFontManager.setFont(newFont);
    }

    @Override
    public void setFont(String typeName, int size, int style) {
        ScaledFontManager.setFont(typeName, size, style);
    }

    @Override
    public void setSize(int newSize) {
        ScaledFontManager.setSize(newSize);
        this.fireFontChanged();
    }

    @Override
    public void addFontChangeListener(IFontChangeListener listener) {
        this.listeners.add((Object)listener);
    }

    @Override
    public void removeFontChangeListener(IFontChangeListener listener) {
        this.listeners.remove((Object)listener);
    }

    @Override
    public void fireFontChanged() {
        final Object[] handlers = this.listeners.getListeners();
        UiUtil.runInSwtThread((Runnable)new Runnable(){

            @Override
            public void run() {
                Object[] objectArray = handlers;
                int n = handlers.length;
                int n2 = 0;
                while (n2 < n) {
                    Object handler = objectArray[n2];
                    ((IFontChangeListener)handler).fontChanged();
                    ++n2;
                }
            }
        }, (boolean)false);
    }

    @Override
    public Font getFont(int style) {
        return ScaledFontManager.getFont(style);
    }
}

