/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchPart;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.diagram.ui.DiagramUiConstants;
import org.teiid.designer.diagram.ui.DiagramUiPlugin;
import org.teiid.designer.diagram.ui.actions.DiagramAction;
import org.teiid.designer.diagram.ui.editor.DiagramEditor;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.common.util.UiUtil;
import org.teiid.designer.ui.editors.ModelEditor;
import org.teiid.designer.ui.editors.ModelEditorManager;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class LockDiagramAction
extends DiagramAction {
    DiagramEditor editor = null;

    public LockDiagramAction(DiagramEditor editor) {
        super(2);
        this.editor = editor;
        this.setImageDescriptor(DiagramUiPlugin.getDefault().getImageDescriptor("icons/full/cview16/unlocked.png"));
    }

    public void selectionChanged(IWorkbenchPart thePart, ISelection theSelection) {
        super.selectionChanged(thePart, theSelection);
        this.setEnabled(true);
        this.updateUi();
    }

    private void updateUi() {
        ModelResource mr = this.editor.getCurrentModelResource();
        if (mr != null) {
            boolean currentValue = ModelUtilities.isModelDiagramLocked((Object)mr);
            if (currentValue) {
                this.setToolTipText(DiagramUiConstants.Util.getString("LockDiagramAction.unlockTooltip", new Object[0]));
                this.setImageDescriptor(DiagramUiPlugin.getDefault().getImageDescriptor("icons/full/cview16/locked.png"));
            } else {
                this.setToolTipText(DiagramUiConstants.Util.getString("LockDiagramAction.lockTooltip", new Object[0]));
                this.setImageDescriptor(DiagramUiPlugin.getDefault().getImageDescriptor("icons/full/cview16/unlocked.png"));
            }
        }
    }

    @Override
    protected void doRun() {
        ModelResource mr = this.editor.getCurrentModelResource();
        boolean currentValue = ModelUtilities.isModelDiagramLocked((Object)mr);
        if (currentValue) {
            ModelUtilities.unlockModelDiagrams((Object)mr);
        } else {
            ModelUtilities.lockModelDiagrams((Object)mr);
        }
        try {
            ModelEditor modelEditor = ModelEditorManager.getModelEditorForFile((IFile)((IFile)mr.getUnderlyingResource()), (boolean)false);
            if (modelEditor != null) {
                modelEditor.doSave((IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (Exception e) {
            UiConstants.Util.log(4, (Throwable)e, e.getMessage());
        }
        UiUtil.runInSwtThread((Runnable)new Runnable(){

            @Override
            public void run() {
                LockDiagramAction.this.editor.doRefreshDiagram();
            }
        }, (boolean)true);
        this.updateUi();
    }
}

