/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.teiid.designer.diagram.ui.DiagramUiConstants;
import org.teiid.designer.diagram.ui.DiagramUiPlugin;
import org.teiid.designer.diagram.ui.NotationChangeListener;
import org.teiid.designer.diagram.ui.actions.NotationChoice;

public class NotationChoiceRadioActionGroup
extends MenuManager
implements NotationChangeListener,
DiagramUiConstants {
    private ArrayList<NotationChoice> arylNotationActions;
    private NotationChangeListener nclNotationListener;
    private String sNotationId;
    private static final String NOTATION_SUBMENU_TITLE = "DiagramActions.NotationSubmenuTitle";

    public NotationChoiceRadioActionGroup(NotationChangeListener nclNotationListener, String currentNotationId) {
        this(nclNotationListener, Util.getString(NOTATION_SUBMENU_TITLE, new Object[0]), currentNotationId);
    }

    public NotationChoiceRadioActionGroup(NotationChangeListener nclNotationListener, String sText, String currentNotationId) {
        super(sText);
        this.nclNotationListener = nclNotationListener;
        List<String> lstNotationExtensions = DiagramUiPlugin.getDiagramNotationManager().getExtensionIds();
        this.arylNotationActions = new ArrayList();
        for (String sExtensionId : lstNotationExtensions) {
            String sExtensionDisplayName = DiagramUiPlugin.getDiagramNotationManager().getExtensionDisplayName(sExtensionId);
            NotationChoice action = new NotationChoice(sExtensionId, sExtensionDisplayName, this);
            if (sExtensionId.equals(currentNotationId)) {
                action.setChecked(true);
            } else {
                action.setChecked(false);
            }
            this.add((IAction)action);
            this.arylNotationActions.add(action);
        }
    }

    @Override
    public void setNotationId(String sNotationId) {
        if (this.sNotationId == null || sNotationId != null && this.sNotationId != null && !this.sNotationId.equals(sNotationId)) {
            this.nclNotationListener.setNotationId(sNotationId);
            this.sNotationId = sNotationId;
        }
        this.updateNotationActions(this.sNotationId);
    }

    public void updateNotationActions(String sNotationId) {
        for (NotationChoice ncAction : this.arylNotationActions) {
            if (ncAction.getExtensionId().equals(sNotationId)) {
                ncAction.setChecked(true);
                continue;
            }
            ncAction.setChecked(false);
        }
    }

    public void setNotationChangeListener(NotationChangeListener nclNotationListener) {
        this.nclNotationListener = nclNotationListener;
    }

    public NotationChangeListener getNotationChangeListener() {
        return this.nclNotationListener;
    }
}

