/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui.actions;

import org.eclipse.gef.editparts.ZoomListener;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.ui.actions.ZoomOutAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.teiid.designer.diagram.ui.DiagramUiConstants;
import org.teiid.designer.diagram.ui.actions.ActionWrapper;
import org.teiid.designer.diagram.ui.actions.DiagramAction;
import org.teiid.designer.diagram.ui.actions.IDiagramActionConstants;
import org.teiid.designer.diagram.ui.editor.DiagramEditor;
import org.teiid.designer.diagram.ui.editor.ZoomableEditor;
import org.teiid.designer.ui.editors.ModelEditor;

public class ZoomOutWrapper
extends DiagramAction
implements DiagramUiConstants,
IDiagramActionConstants,
IPartListener,
ActionWrapper,
ZoomListener {
    private static final double[] zoomValues = new double[]{0.1, 0.25, 0.5, 0.75, 0.9, 1.0, 1.1, 1.25, 1.5, 2.0, 3.0, 4.0, 10.0};
    private boolean wasInitialized = false;
    private ZoomManager zoomManager;

    public ZoomOutWrapper() {
    }

    public ZoomOutWrapper(int theStyle) {
        super(theStyle);
    }

    @Override
    public void initialize() {
        DiagramEditor deEditorPage;
        ModelEditor editor = this.getActiveEditor();
        if (editor != null && editor.getCurrentPage() instanceof ZoomableEditor && (deEditorPage = ((ZoomableEditor)editor.getCurrentPage()).getDiagramEditor()) != null) {
            this.zoomManager = (ZoomManager)deEditorPage.getAdapter(ZoomManager.class);
        }
        if (this.zoomManager != null) {
            this.zoomManager.setZoomLevels(zoomValues);
            if (!this.wasInitialized) {
                this.wasInitialized = true;
                this.zoomManager.setZoom(this.getEditorZoomLevel());
            }
            this.zoomManager.addZoomListener((ZoomListener)this);
        }
        this.setEnableState();
        this.addAsPartListener();
    }

    @Override
    protected void doRun() {
        ZoomManager zoomMgr = this.getZoomManager();
        if (zoomMgr != null) {
            ZoomOutAction action = new ZoomOutAction(zoomMgr);
            action.run();
            DiagramEditor de = this.getDiagramEditor();
            if (de != null) {
                de.handleZoomChanged();
            }
            zoomMgr.removeZoomListener((ZoomListener)action);
            this.setEnabled(zoomMgr.canZoomOut());
        }
    }

    private DiagramEditor getDiagramEditor() {
        DiagramEditor deEditorPage;
        ModelEditor editor = this.getActiveEditor();
        if (editor != null && editor.getCurrentPage() instanceof ZoomableEditor && (deEditorPage = ((ZoomableEditor)editor.getCurrentPage()).getDiagramEditor()) != null) {
            return deEditorPage;
        }
        return null;
    }

    public void closeZoomManager() {
        if (this.zoomManager != null) {
            this.zoomManager.removeZoomListener((ZoomListener)this);
            this.zoomManager = null;
        }
    }

    private double getEditorZoomLevel() {
        double currentZoom = 1.0;
        DiagramEditor de = this.getDiagramEditor();
        if (de != null) {
            currentZoom = de.getCurrentZoomFactor();
        }
        return currentZoom;
    }

    private ZoomManager getZoomManager() {
        if (this.zoomManager == null) {
            this.initialize();
        }
        return this.zoomManager;
    }

    private void addAsPartListener() {
        this.getPlugin().getCurrentWorkbenchWindow().getPartService().addPartListener((IPartListener)this);
    }

    public void dispose() {
        this.getPlugin().getCurrentWorkbenchWindow().getPartService().removePartListener((IPartListener)this);
        super.dispose();
    }

    public void selectionChanged(IWorkbenchPart thePart, ISelection theSelection) {
    }

    public void setEnableState() {
        ModelEditor editor = this.getActiveEditor();
        if (editor != null && editor.getCurrentPage() instanceof DiagramEditor) {
            ZoomManager zoomMgr = this.getZoomManager();
            if (zoomMgr != null) {
                this.setEnabled(zoomMgr.canZoomOut());
            } else {
                this.setEnabled(false);
            }
        }
    }

    public void partActivated(IWorkbenchPart part) {
        this.setEnableState();
    }

    public void partBroughtToTop(IWorkbenchPart part) {
        this.setEnableState();
    }

    public void partClosed(IWorkbenchPart part) {
        this.setEnabled(false);
    }

    public void partDeactivated(IWorkbenchPart part) {
        this.setEnabled(false);
    }

    public void partOpened(IWorkbenchPart part) {
        this.setEnableState();
    }

    public void zoomChanged(double d) {
        this.setEnableState();
    }
}

