/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui.connection;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.teiid.designer.diagram.ui.connection.AnchorManager;
import org.teiid.designer.diagram.ui.connection.NodeConnectionAnchor;
import org.teiid.designer.diagram.ui.connection.NodeConnectionEditPart;
import org.teiid.designer.diagram.ui.model.DiagramModelNode;
import org.teiid.designer.diagram.ui.part.DiagramEditPart;

public class BlockAnchorManager
implements AnchorManager {
    public static final int QA = 0;
    public static final int QB = 1;
    public static final int QC = 2;
    public static final int QD = 3;
    public static final int QE = 4;
    public static final int QF = 5;
    public static final int QG = 6;
    public static final int QH = 7;
    public static final int QZ = 8;
    public static final int C1 = 9;
    public static final int C2 = 10;
    public static final int C3 = 11;
    public static final int C4 = 12;
    public static final int C5 = 13;
    public static final int C6 = 14;
    public static final int C7 = 15;
    public static final int C8 = 16;
    public static final int C9 = 17;
    public static final int C10 = 18;
    public static final int C11 = 19;
    public static final int C12 = 20;
    public static final int C13 = 21;
    public static final int C14 = 22;
    public static final int C15 = 23;
    public static final int C16 = 24;
    public static final int C17 = 25;
    public static final int C18 = 26;
    public static final int C19 = 27;
    public static final int C20 = 28;
    public static final int C21 = 29;
    public static final int C22 = 30;
    public static final int C23 = 31;
    public static final int C24 = 32;
    private List northAnchors;
    private List southAnchors;
    private List eastAnchors;
    private List westAnchors;
    private DiagramEditPart diagramEditPart;

    public BlockAnchorManager(DiagramEditPart diagramEditPart) {
        this.diagramEditPart = diagramEditPart;
        this.init();
    }

    private void init() {
    }

    private List getEastAnchors() {
        return this.eastAnchors;
    }

    private List getNorthAnchors() {
        return this.northAnchors;
    }

    private List getSouthAnchors() {
        return this.southAnchors;
    }

    private List getWestAnchors() {
        return this.westAnchors;
    }

    private boolean addEastAnchor(NodeConnectionAnchor newAnchor) {
        if (this.eastAnchors == null) {
            this.eastAnchors = new ArrayList(1);
        }
        if (!this.eastAnchors.contains((Object)newAnchor)) {
            this.eastAnchors.add(newAnchor);
            return true;
        }
        return false;
    }

    private boolean addNorthAnchor(NodeConnectionAnchor newAnchor) {
        if (this.northAnchors == null) {
            this.northAnchors = new ArrayList(1);
        }
        if (!this.northAnchors.contains((Object)newAnchor)) {
            this.northAnchors.add(newAnchor);
            return true;
        }
        return false;
    }

    private boolean addSouthAnchor(NodeConnectionAnchor newAnchor) {
        if (this.southAnchors == null) {
            this.southAnchors = new ArrayList(1);
        }
        if (!this.southAnchors.contains((Object)newAnchor)) {
            this.southAnchors.add(newAnchor);
            return true;
        }
        return false;
    }

    private boolean addWestAnchor(NodeConnectionAnchor newAnchor) {
        if (this.westAnchors == null) {
            this.westAnchors = new ArrayList(1);
        }
        if (!this.westAnchors.contains((Object)newAnchor)) {
            this.westAnchors.add(newAnchor);
            return true;
        }
        return false;
    }

    @Override
    public boolean add(NodeConnectionAnchor targetAnchor) {
        boolean added = false;
        if (targetAnchor.getDirection() == 0) {
            added = this.addNorthAnchor(targetAnchor);
        } else if (targetAnchor.getDirection() == 2) {
            added = this.addSouthAnchor(targetAnchor);
        } else if (targetAnchor.getDirection() == 1) {
            added = this.addEastAnchor(targetAnchor);
        } else if (targetAnchor.getDirection() == 3) {
            added = this.addWestAnchor(targetAnchor);
        }
        return added;
    }

    @Override
    public boolean move(NodeConnectionAnchor targetAnchor) {
        boolean removed = this.remove(targetAnchor);
        boolean added = this.add(targetAnchor);
        return removed && added;
    }

    @Override
    public boolean remove(NodeConnectionAnchor targetAnchor) {
        boolean removed = false;
        if (targetAnchor.getDirection() != 0 && this.getNorthAnchors() != null && this.getNorthAnchors().contains((Object)targetAnchor)) {
            this.getNorthAnchors().remove((Object)targetAnchor);
            removed = true;
        }
        if (targetAnchor.getDirection() != 2 && this.getSouthAnchors() != null && this.getSouthAnchors().contains((Object)targetAnchor)) {
            this.getSouthAnchors().remove((Object)targetAnchor);
            removed = true;
        }
        if (targetAnchor.getDirection() != 1 && this.getEastAnchors() != null && this.getEastAnchors().contains((Object)targetAnchor)) {
            this.getEastAnchors().remove((Object)targetAnchor);
            removed = true;
        }
        if (targetAnchor.getDirection() != 3 && this.getWestAnchors() != null && this.getWestAnchors().contains((Object)targetAnchor)) {
            this.getWestAnchors().remove((Object)targetAnchor);
            removed = true;
        }
        return removed;
    }

    @Override
    public void resetSourceAnchors(boolean updateTargetEnd) {
        List sConnections = this.getSourceConnections();
        if (sConnections.isEmpty()) {
            return;
        }
        NodeConnectionEditPart nextConnection = null;
        Iterator iter = sConnections.iterator();
        DiagramEditPart targetEditPart = null;
        NodeConnectionAnchor sourceAnchor = null;
        while (iter.hasNext()) {
            nextConnection = (NodeConnectionEditPart)iter.next();
            sourceAnchor = (NodeConnectionAnchor)nextConnection.getSourceAnchor();
            targetEditPart = (DiagramEditPart)nextConnection.getTarget();
            if (targetEditPart == null) continue;
            int gridId = this.getSourceGridLocation(this.diagramEditPart, targetEditPart);
            if (gridId == 0 || gridId == 1 || gridId == 2) {
                this.setAnchorPosition(sourceAnchor, 2);
            } else if (gridId == 6 || gridId == 5 || gridId == 4) {
                this.setAnchorPosition(sourceAnchor, 0);
            } else if (gridId == 7) {
                this.setAnchorPosition(sourceAnchor, 3);
            } else if (gridId == 8 || gridId == 3) {
                this.setAnchorPosition(sourceAnchor, 1);
            } else if (gridId == 9 || gridId == 10 || gridId == 11 || gridId == 12 || gridId == 17 || gridId == 29 || gridId == 30 || gridId == 31 || gridId == 32) {
                this.setAnchorPosition(sourceAnchor, 1);
            } else if (gridId == 13 || gridId == 14 || gridId == 15 || gridId == 18 || gridId == 23 || gridId == 24 || gridId == 28) {
                this.setAnchorPosition(sourceAnchor, 0);
            } else if (gridId == 16 || gridId == 26) {
                this.setAnchorPosition(sourceAnchor, 2);
            } else {
                this.setAnchorPosition(sourceAnchor, 3);
            }
            if (!updateTargetEnd) continue;
            targetEditPart.createOrUpdateAnchorsLocations(false);
        }
    }

    @Override
    public void resetTargetAnchors(boolean updateSourceEnd) {
        List tConnections = this.getTargetConnections();
        if (tConnections.isEmpty()) {
            return;
        }
        NodeConnectionEditPart nextConnection = null;
        Iterator iter = tConnections.iterator();
        DiagramEditPart sourceEditPart = null;
        NodeConnectionAnchor targetAnchor = null;
        while (iter.hasNext()) {
            nextConnection = (NodeConnectionEditPart)iter.next();
            targetAnchor = (NodeConnectionAnchor)nextConnection.getTargetAnchor();
            sourceEditPart = (DiagramEditPart)nextConnection.getSource();
            if (sourceEditPart == null) continue;
            int gridId = this.getSourceGridLocation(sourceEditPart, this.diagramEditPart);
            if (gridId == 0 || gridId == 7 || gridId == 6) {
                this.setAnchorPosition(targetAnchor, 1);
            } else if (gridId == 2 || gridId == 3 || gridId == 4) {
                this.setAnchorPosition(targetAnchor, 3);
            } else if (gridId == 1) {
                this.setAnchorPosition(targetAnchor, 0);
            } else if (gridId == 8 || gridId == 5) {
                this.setAnchorPosition(targetAnchor, 2);
            } else if (gridId == 9 || gridId == 10 || gridId == 12 || gridId == 17 || gridId == 19 || gridId == 20 || gridId == 22 || gridId == 25 || gridId == 27 || gridId == 29 || gridId == 30 || gridId == 32) {
                this.setAnchorPosition(targetAnchor, 2);
            } else if (gridId == 11 || gridId == 21 || gridId == 31) {
                this.setAnchorPosition(targetAnchor, 0);
            } else if (gridId == 13 || gridId == 14 || gridId == 15 || gridId == 16 || gridId == 18) {
                this.setAnchorPosition(targetAnchor, 3);
            } else {
                this.setAnchorPosition(targetAnchor, 1);
            }
            if (!updateSourceEnd) continue;
            sourceEditPart.createOrUpdateAnchorsLocations(false);
        }
    }

    @Override
    public List getSourceConnections() {
        return this.diagramEditPart.getSourceConnections();
    }

    @Override
    public List getTargetConnections() {
        return this.diagramEditPart.getTargetConnections();
    }

    @Override
    public ConnectionAnchor getSourceAnchor(NodeConnectionEditPart connection) {
        if (connection.getSourceAnchor() == null) {
            NodeConnectionAnchor newAnchor = this.createSourceAnchor();
            connection.setSourceAnchor((ConnectionAnchor)newAnchor);
            return newAnchor;
        }
        return connection.getSourceAnchor();
    }

    @Override
    public ConnectionAnchor getTargetAnchor(NodeConnectionEditPart connection) {
        if (connection.getTargetAnchor() == null) {
            NodeConnectionAnchor newAnchor = this.createTargetAnchor();
            connection.setTargetAnchor((ConnectionAnchor)newAnchor);
            return newAnchor;
        }
        return connection.getTargetAnchor();
    }

    private NodeConnectionAnchor createTargetAnchor() {
        NodeConnectionAnchor newAnchor = new NodeConnectionAnchor(this.diagramEditPart.getFigure(), false);
        newAnchor.setDirection(0);
        this.add(newAnchor);
        return newAnchor;
    }

    private NodeConnectionAnchor createSourceAnchor() {
        NodeConnectionAnchor newAnchor = new NodeConnectionAnchor(this.diagramEditPart.getFigure(), true);
        newAnchor.setDirection(0);
        this.add(newAnchor);
        return newAnchor;
    }

    @Override
    public boolean hasSourceAnchors() {
        NodeConnectionAnchor nextAnchor2 = null;
        Iterator iter = null;
        if (this.northAnchors != null && !this.northAnchors.isEmpty()) {
            for (NodeConnectionAnchor nextAnchor2 : this.northAnchors) {
                if (nextAnchor2 == null || !nextAnchor2.isSource()) continue;
                return true;
            }
        }
        if (this.southAnchors != null && !this.southAnchors.isEmpty()) {
            for (NodeConnectionAnchor nextAnchor2 : this.southAnchors) {
                if (nextAnchor2 == null || !nextAnchor2.isSource()) continue;
                return true;
            }
        }
        if (this.eastAnchors != null && !this.eastAnchors.isEmpty()) {
            for (NodeConnectionAnchor nextAnchor2 : this.eastAnchors) {
                if (nextAnchor2 == null || !nextAnchor2.isSource()) continue;
                return true;
            }
        }
        if (this.westAnchors != null && !this.westAnchors.isEmpty()) {
            for (NodeConnectionAnchor nextAnchor2 : this.westAnchors) {
                if (nextAnchor2 == null || !nextAnchor2.isSource()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasTargetAnchors() {
        NodeConnectionAnchor nextAnchor2 = null;
        Iterator iter = null;
        if (this.northAnchors != null && !this.northAnchors.isEmpty()) {
            for (NodeConnectionAnchor nextAnchor2 : this.northAnchors) {
                if (nextAnchor2 == null || nextAnchor2.isSource()) continue;
                return true;
            }
        }
        if (this.southAnchors != null && !this.southAnchors.isEmpty()) {
            for (NodeConnectionAnchor nextAnchor2 : this.southAnchors) {
                if (nextAnchor2 == null || nextAnchor2.isSource()) continue;
                return true;
            }
        }
        if (this.eastAnchors != null && !this.eastAnchors.isEmpty()) {
            for (NodeConnectionAnchor nextAnchor2 : this.eastAnchors) {
                if (nextAnchor2 == null || nextAnchor2.isSource()) continue;
                return true;
            }
        }
        if (this.westAnchors != null && !this.westAnchors.isEmpty()) {
            for (NodeConnectionAnchor nextAnchor2 : this.westAnchors) {
                if (nextAnchor2 == null || nextAnchor2.isSource()) continue;
                return true;
            }
        }
        return false;
    }

    public void setAnchorPosition(NodeConnectionAnchor theAnchor, int direction, List fellowAnchors) {
        Dimension partSize = ((DiagramModelNode)this.diagramEditPart.getModel()).getSize();
        int oldDirection = theAnchor.getDirection();
        theAnchor.setDirection(direction);
        boolean moved = this.move(theAnchor);
        if (moved) {
            this.setAnchorPositions(oldDirection, direction);
        }
        if (direction == 0) {
            if (fellowAnchors.size() == 1) {
                theAnchor.setOffsetH(partSize.width / 2);
                theAnchor.setOffsetV(0);
            } else {
                int nAnchors = fellowAnchors.size();
                int anchorId = this.getAnchorListId(fellowAnchors, theAnchor) + 1;
                int hOffsetIncrement = partSize.width / (nAnchors + 1);
                theAnchor.setOffsetH(hOffsetIncrement * anchorId);
                theAnchor.setOffsetV(0);
            }
        } else if (direction == 2) {
            if (fellowAnchors.size() == 1) {
                theAnchor.setOffsetH(partSize.width / 2);
                theAnchor.setOffsetV(partSize.height);
            } else {
                int nAnchors = fellowAnchors.size();
                int anchorId = this.getAnchorListId(fellowAnchors, theAnchor) + 1;
                int hOffsetIncrement = partSize.width / (nAnchors + 1);
                theAnchor.setOffsetH(hOffsetIncrement * anchorId);
                theAnchor.setOffsetV(partSize.height);
            }
        } else if (direction == 3) {
            if (fellowAnchors.size() == 1) {
                theAnchor.setOffsetH(0);
                theAnchor.setOffsetV(partSize.height / 2);
            } else {
                int nAnchors = fellowAnchors.size();
                int anchorId = this.getAnchorListId(fellowAnchors, theAnchor) + 1;
                int vOffsetIncrement = partSize.height / (nAnchors + 1);
                theAnchor.setOffsetV(vOffsetIncrement * anchorId);
                theAnchor.setOffsetH(0);
            }
        } else if (fellowAnchors.size() == 1) {
            theAnchor.setOffsetH(partSize.width);
            theAnchor.setOffsetV(partSize.height / 2);
        } else {
            int nAnchors = fellowAnchors.size();
            int anchorId = this.getAnchorListId(fellowAnchors, theAnchor) + 1;
            int vOffsetIncrement = partSize.height / (nAnchors + 1);
            theAnchor.setOffsetV(vOffsetIncrement * anchorId);
            theAnchor.setOffsetH(partSize.width);
        }
    }

    @Override
    public void setAnchorPosition(NodeConnectionAnchor theAnchor, int direction) {
        Dimension partSize = ((DiagramModelNode)this.diagramEditPart.getModel()).getSize();
        int oldDirection = theAnchor.getDirection();
        theAnchor.setDirection(direction);
        boolean moved = this.move(theAnchor);
        if (moved) {
            this.setAnchorPositions(oldDirection, direction);
        } else if (direction == 0) {
            if (this.getNorthAnchors().size() == 1) {
                theAnchor.setOffsetH(partSize.width / 2);
                theAnchor.setOffsetV(0);
            } else {
                int nAnchors = this.getNorthAnchors().size();
                int anchorId = this.getAnchorListId(this.getNorthAnchors(), theAnchor) + 1;
                int hOffsetIncrement = partSize.width / (nAnchors + 1);
                theAnchor.setOffsetH(hOffsetIncrement * anchorId);
                theAnchor.setOffsetV(0);
            }
        } else if (direction == 2) {
            if (this.getSouthAnchors().size() == 1) {
                theAnchor.setOffsetH(partSize.width / 2);
                theAnchor.setOffsetV(partSize.height);
            } else {
                int nAnchors = this.getSouthAnchors().size();
                int anchorId = this.getAnchorListId(this.getSouthAnchors(), theAnchor) + 1;
                int hOffsetIncrement = partSize.width / (nAnchors + 1);
                theAnchor.setOffsetH(hOffsetIncrement * anchorId);
                theAnchor.setOffsetV(partSize.height);
            }
        } else if (direction == 3) {
            if (this.getWestAnchors().size() == 1) {
                theAnchor.setOffsetH(0);
                theAnchor.setOffsetV(partSize.height / 2);
            } else {
                int nAnchors = this.getWestAnchors().size();
                int anchorId = this.getAnchorListId(this.getWestAnchors(), theAnchor) + 1;
                int vOffsetIncrement = partSize.height / (nAnchors + 1);
                theAnchor.setOffsetV(vOffsetIncrement * anchorId);
                theAnchor.setOffsetH(0);
            }
        } else if (this.getEastAnchors().size() == 1) {
            theAnchor.setOffsetH(partSize.width);
            theAnchor.setOffsetV(partSize.height / 2);
        } else {
            int nAnchors = this.getEastAnchors().size();
            int anchorId = this.getAnchorListId(this.getEastAnchors(), theAnchor) + 1;
            int vOffsetIncrement = partSize.height / (nAnchors + 1);
            theAnchor.setOffsetV(vOffsetIncrement * anchorId);
            theAnchor.setOffsetH(partSize.width);
        }
    }

    private void reorderAnchors(List anchors, int direction) {
        if (anchors != null && !anchors.isEmpty()) {
            Iterator iter = anchors.iterator();
            while (iter.hasNext()) {
                this.setAnchorPosition((NodeConnectionAnchor)((Object)iter.next()), direction, anchors);
            }
        }
    }

    @Override
    public void reorderAllAnchors(boolean updateBothEnds) {
        List tConnections = this.getTargetConnections();
        List sConnections = this.getSourceConnections();
        if (tConnections.isEmpty() && sConnections.isEmpty()) {
            return;
        }
        AnchorListManager eastAnchors = new AnchorListManager(1);
        AnchorListManager westAnchors = new AnchorListManager(3);
        AnchorListManager northAnchors = new AnchorListManager(0);
        AnchorListManager southAnchors = new AnchorListManager(2);
        HashMap<DiagramEditPart, String> otherEndParts = new HashMap<DiagramEditPart, String>();
        NodeConnectionEditPart nextConnection2 = null;
        DiagramEditPart sourceEditPart = null;
        NodeConnectionAnchor targetAnchor = null;
        for (NodeConnectionEditPart nextConnection2 : tConnections) {
            targetAnchor = (NodeConnectionAnchor)nextConnection2.getTargetAnchor();
            sourceEditPart = (DiagramEditPart)nextConnection2.getSource();
            if (updateBothEnds && otherEndParts.get(sourceEditPart) == null) {
                otherEndParts.put(sourceEditPart, "z");
            }
            if (sourceEditPart == null) continue;
            int gridId = this.getSourceGridLocation(sourceEditPart, this.diagramEditPart);
            if (gridId == 0 || gridId == 7 || gridId == 6) {
                eastAnchors.addAnchor(sourceEditPart, targetAnchor);
                continue;
            }
            if (gridId == 2 || gridId == 3 || gridId == 4) {
                westAnchors.addAnchor(sourceEditPart, targetAnchor);
                continue;
            }
            if (gridId == 1) {
                northAnchors.addAnchor(sourceEditPart, targetAnchor);
                continue;
            }
            if (gridId == 8 || gridId == 5) {
                southAnchors.addAnchor(sourceEditPart, targetAnchor);
                continue;
            }
            if (gridId == 9 || gridId == 10 || gridId == 12 || gridId == 17 || gridId == 19 || gridId == 20 || gridId == 22 || gridId == 25 || gridId == 27 || gridId == 29 || gridId == 30 || gridId == 32) {
                southAnchors.addAnchor(sourceEditPart, targetAnchor);
                continue;
            }
            if (gridId == 11 || gridId == 21 || gridId == 31) {
                northAnchors.addAnchor(sourceEditPart, targetAnchor);
                continue;
            }
            if (gridId == 13 || gridId == 14 || gridId == 15 || gridId == 16 || gridId == 18) {
                westAnchors.addAnchor(sourceEditPart, targetAnchor);
                continue;
            }
            eastAnchors.addAnchor(sourceEditPart, targetAnchor);
        }
        DiagramEditPart targetEditPart2 = null;
        NodeConnectionAnchor sourceAnchor = null;
        for (NodeConnectionEditPart nextConnection2 : sConnections) {
            sourceAnchor = (NodeConnectionAnchor)nextConnection2.getSourceAnchor();
            targetEditPart2 = (DiagramEditPart)nextConnection2.getTarget();
            if (updateBothEnds && otherEndParts.get(targetEditPart2) == null) {
                otherEndParts.put(targetEditPart2, "z");
            }
            if (targetEditPart2 == null) continue;
            int gridId = this.getSourceGridLocation(targetEditPart2, this.diagramEditPart);
            if (gridId == 0 || gridId == 7 || gridId == 6) {
                eastAnchors.addAnchor(targetEditPart2, sourceAnchor);
                continue;
            }
            if (gridId == 2 || gridId == 3 || gridId == 4) {
                westAnchors.addAnchor(targetEditPart2, sourceAnchor);
                continue;
            }
            if (gridId == 1) {
                northAnchors.addAnchor(targetEditPart2, sourceAnchor);
                continue;
            }
            if (gridId == 8 || gridId == 5) {
                southAnchors.addAnchor(targetEditPart2, sourceAnchor);
                continue;
            }
            if (gridId == 9 || gridId == 10 || gridId == 12 || gridId == 17 || gridId == 19 || gridId == 20 || gridId == 22 || gridId == 25 || gridId == 27 || gridId == 29 || gridId == 30 || gridId == 32) {
                southAnchors.addAnchor(targetEditPart2, sourceAnchor);
                continue;
            }
            if (gridId == 11 || gridId == 21 || gridId == 31) {
                northAnchors.addAnchor(targetEditPart2, sourceAnchor);
                continue;
            }
            if (gridId == 13 || gridId == 14 || gridId == 15 || gridId == 16 || gridId == 18) {
                westAnchors.addAnchor(targetEditPart2, sourceAnchor);
                continue;
            }
            eastAnchors.addAnchor(targetEditPart2, sourceAnchor);
        }
        this.reorderAnchors(eastAnchors.getOrderedAnchors(), 1);
        this.reorderAnchors(westAnchors.getOrderedAnchors(), 3);
        this.reorderAnchors(northAnchors.getOrderedAnchors(), 0);
        this.reorderAnchors(southAnchors.getOrderedAnchors(), 2);
        if (!otherEndParts.isEmpty()) {
            for (DiagramEditPart targetEditPart2 : otherEndParts.keySet()) {
                if (targetEditPart2 == null) continue;
                targetEditPart2.createOrUpdateAnchorsLocations(false);
            }
        }
    }

    private void setAnchorPositions(int oldDirection, int newDirection) {
        this.setAnchorPositions(oldDirection);
        this.setAnchorPositions(newDirection);
    }

    private void setAnchorPositions(int direction) {
        block5: {
            Iterator iter;
            Dimension partSize;
            block7: {
                block6: {
                    block4: {
                        partSize = ((DiagramModelNode)this.diagramEditPart.getModel()).getSize();
                        iter = null;
                        if (direction != 0 || this.getNorthAnchors() == null || this.getNorthAnchors().isEmpty()) break block4;
                        int nAnchors = this.getNorthAnchors().size();
                        int hOffsetIncrement = partSize.width / (nAnchors + 1);
                        iter = this.getNorthAnchors().iterator();
                        int aCount = 0;
                        NodeConnectionAnchor theAnchor = null;
                        while (iter.hasNext()) {
                            theAnchor = (NodeConnectionAnchor)((Object)iter.next());
                            theAnchor.setOffsetH(hOffsetIncrement * (aCount + 1));
                            theAnchor.setOffsetV(0);
                            ++aCount;
                        }
                        break block5;
                    }
                    if (direction != 2 || this.getSouthAnchors() == null || this.getSouthAnchors().isEmpty()) break block6;
                    int nAnchors = this.getSouthAnchors().size();
                    int hOffsetIncrement = partSize.width / (nAnchors + 1);
                    iter = this.getSouthAnchors().iterator();
                    int aCount = 0;
                    NodeConnectionAnchor theAnchor = null;
                    while (iter.hasNext()) {
                        theAnchor = (NodeConnectionAnchor)((Object)iter.next());
                        theAnchor.setOffsetH(hOffsetIncrement * (aCount + 1));
                        theAnchor.setOffsetV(partSize.height);
                        ++aCount;
                    }
                    break block5;
                }
                if (direction != 3 || this.getWestAnchors() == null || this.getWestAnchors().isEmpty()) break block7;
                int nAnchors = this.getWestAnchors().size();
                int vOffsetIncrement = partSize.height / (nAnchors + 1);
                iter = this.getWestAnchors().iterator();
                int aCount = 0;
                NodeConnectionAnchor theAnchor = null;
                while (iter.hasNext()) {
                    theAnchor = (NodeConnectionAnchor)((Object)iter.next());
                    theAnchor.setOffsetV(vOffsetIncrement * (aCount + 1));
                    theAnchor.setOffsetH(0);
                    ++aCount;
                }
                break block5;
            }
            if (this.getEastAnchors() == null || this.getEastAnchors().isEmpty()) break block5;
            int nAnchors = this.getEastAnchors().size();
            int vOffsetIncrement = partSize.height / (nAnchors + 1);
            iter = this.getEastAnchors().iterator();
            int aCount = 0;
            NodeConnectionAnchor theAnchor = null;
            while (iter.hasNext()) {
                theAnchor = (NodeConnectionAnchor)((Object)iter.next());
                theAnchor.setOffsetV(vOffsetIncrement * (aCount + 1));
                theAnchor.setOffsetH(partSize.width);
                ++aCount;
            }
        }
    }

    private int getAnchorListId(List anchors, NodeConnectionAnchor anchor) {
        int id = 0;
        Iterator iter = anchors.iterator();
        while (iter.hasNext()) {
            if (anchor.equals(iter.next())) break;
            ++id;
        }
        return id;
    }

    private int getSourceGridLocation(DiagramEditPart sourcePart, DiagramEditPart targetPart) {
        int gridId = 8;
        int padding = 20;
        Point tMin = new Point(((DiagramModelNode)targetPart.getModel()).getPosition().x - padding, ((DiagramModelNode)targetPart.getModel()).getPosition().y + padding);
        Dimension tSize = new Dimension(((DiagramModelNode)targetPart.getModel()).getSize().width + padding * 2, ((DiagramModelNode)targetPart.getModel()).getSize().height + padding * 2);
        Point sMin = new Point(((DiagramModelNode)sourcePart.getModel()).getPosition().x - padding, ((DiagramModelNode)sourcePart.getModel()).getPosition().y + padding);
        Dimension sSize = new Dimension(((DiagramModelNode)sourcePart.getModel()).getSize().width + padding * 2, ((DiagramModelNode)sourcePart.getModel()).getSize().height + padding * 2);
        Point tCenter = new Point(tMin.x + tSize.width / 2, tMin.y + tSize.height / 2);
        Point tMax = new Point(tMin.x + tSize.width, tMin.y + tSize.height);
        Point sMax = new Point(sMin.x + sSize.width, sMin.y + sSize.height);
        gridId = sMax.y < tMin.y ? (sMin.x > tMax.x ? 0 : (sMax.x < tMin.x ? 2 : 1)) : (sMin.y > tMax.y ? (sMin.x > tMax.x ? 6 : (sMax.x < tMin.x ? 4 : 5)) : (sMin.x > tMax.x ? 7 : (sMax.x < tMin.x ? 3 : (sMin.x > tCenter.x ? (sMax.y < tCenter.y ? 9 : (sMax.y > tCenter.y && sMax.y < tMax.y ? (sMin.y > tMin.y ? 12 : 10) : (sMin.y > tMin.y ? 11 : 13))) : (sMin.x > tMin.x ? (sMax.y < tCenter.y ? 14 : (sMax.y > tCenter.y && sMax.y < tMax.y ? (sMin.y > tMin.y ? 17 : 15) : (sMin.y > tMin.y ? 16 : 18))) : (sMax.x < tMax.x ? (sMax.x < tCenter.x ? (sMax.y < tCenter.y ? 19 : (sMax.y > tCenter.y && sMax.y < tMax.y ? (sMin.y > tMin.y ? 22 : 20) : (sMin.y > tMin.y ? 21 : 23))) : (sMax.y < tCenter.y ? 24 : (sMax.y > tCenter.y && sMax.y < tMax.y ? (sMin.y > tMin.y ? 27 : 25) : (sMin.y > tMin.y ? 26 : 28)))) : (sMax.y < tCenter.y ? 29 : (sMax.y < tMax.y ? 30 : (sMin.y > tMin.y ? 31 : 32)))))))));
        return gridId;
    }

    private class AnchorInfo {
        private NodeConnectionAnchor anchor;
        private int positionValue = 0;

        public AnchorInfo(NodeConnectionAnchor anchor, int position) {
            this.anchor = anchor;
            this.positionValue = position;
        }

        public NodeConnectionAnchor getAnchor() {
            return this.anchor;
        }

        public int getPositionValue() {
            return this.positionValue;
        }
    }

    private class AnchorListManager {
        private List anchorArray = new ArrayList();
        private int direction;

        public AnchorListManager(int direction) {
            this.direction = direction;
        }

        public void addAnchor(DiagramEditPart editPart, NodeConnectionAnchor anchor) {
            Point newPosition = new Point(((DiagramModelNode)editPart.getModel()).getPosition());
            int newPositionValue = 0;
            newPositionValue = this.direction == 1 || this.direction == 3 ? newPosition.y : newPosition.x;
            if (this.anchorArray.isEmpty()) {
                this.anchorArray.add(new AnchorInfo(anchor, newPositionValue));
            } else {
                int newIndex = 0;
                AnchorInfo anchorInfo2 = null;
                AnchorInfo nextAnchorInfo = null;
                int size = this.anchorArray.size();
                for (AnchorInfo anchorInfo2 : this.anchorArray) {
                    if (newPositionValue < anchorInfo2.getPositionValue() || ++newIndex >= size || newPositionValue <= (nextAnchorInfo = (AnchorInfo)this.anchorArray.get(newIndex)).getPositionValue()) break;
                }
                this.anchorArray.add(newIndex, new AnchorInfo(anchor, newPositionValue));
            }
        }

        public List getOrderedAnchors() {
            ArrayList<NodeConnectionAnchor> anchorList = new ArrayList<NodeConnectionAnchor>(this.anchorArray.size());
            AnchorInfo anchorInfo2 = null;
            for (AnchorInfo anchorInfo2 : this.anchorArray) {
                anchorList.add(anchorInfo2.getAnchor());
            }
            return anchorList;
        }
    }
}

