/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui.connection;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.draw2d.AbstractRouter;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Ray;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;

public final class BlockConnectionRouter
extends AbstractRouter {
    private int offsetPadding = 10;
    private Map<Integer, Integer> usedRows = new HashMap<Integer, Integer>();
    private Map<Integer, Integer> usedColumns = new HashMap<Integer, Integer>();
    private Map<Connection, ReservedInfo> reservedInfo = new HashMap<Connection, ReservedInfo>();
    private static Ray DIR_UP = new Ray(0, -1);
    private static Ray DIR_DOWN = new Ray(0, 1);
    private static Ray DIR_LEFT = new Ray(-1, 0);
    private static Ray DIR_RIGHT = new Ray(1, 0);

    public BlockConnectionRouter(int offsetPadding) {
        this.offsetPadding = offsetPadding;
    }

    public void invalidate(Connection connection) {
        this.removeReservedLines(connection);
    }

    protected Ray getDirection(Rectangle r, Point p) {
        int distance = Math.abs(r.x - p.x);
        Ray direction = DIR_LEFT;
        int i = Math.abs(r.y - p.y);
        if (i <= distance) {
            distance = i;
            direction = DIR_UP;
        }
        if ((i = Math.abs(r.bottom() - p.y)) <= distance) {
            distance = i;
            direction = DIR_DOWN;
        }
        if ((i = Math.abs(r.right() - p.x)) < distance) {
            distance = i;
            direction = DIR_RIGHT;
        }
        return direction;
    }

    private int getNearestColumn(Connection connection, int r, int n, int x) {
        int min = Math.min(n, x);
        int max = Math.max(n, x);
        if (min > r) {
            max = min;
            min = r - (min - r);
        }
        if (max < r) {
            min = max;
            max = r + (r - max);
        }
        int proxVal = 0;
        int dirVal = -1;
        if (r % 2 == 1) {
            --r;
        }
        while (proxVal < r) {
            Integer i = new Integer(r + proxVal * dirVal);
            if (!this.usedColumns.containsKey(i)) {
                this.usedColumns.put(i, i);
                this.reserveColumn(connection, i);
                return i;
            }
            int j = i;
            if (j <= min) {
                return j + 2;
            }
            if (j >= max) {
                return j - 2;
            }
            if (dirVal == 1) {
                dirVal = -1;
                continue;
            }
            dirVal = 1;
            proxVal += 2;
        }
        return r;
    }

    protected Ray getEndDirection(Connection conn) {
        Rectangle rect;
        ConnectionAnchor anchor = conn.getTargetAnchor();
        Point p = this.getEndPoint(conn);
        if (anchor.getOwner() == null) {
            rect = new Rectangle(p.x - 1, p.y - 1, 2, 2);
        } else {
            rect = conn.getTargetAnchor().getOwner().getBounds().getCopy();
            conn.getTargetAnchor().getOwner().translateToAbsolute((Translatable)rect);
        }
        return this.getDirection(rect, p);
    }

    protected int getNearestRow(Connection connection, int r, int n, int x) {
        int min = Math.min(n, x);
        int max = Math.max(n, x);
        if (min > r) {
            max = min;
            min = r - (min - r);
        }
        if (max < r) {
            min = max;
            max = r + (r - max);
        }
        int proxVal = 0;
        int dirVal = -1;
        if (r % 2 == 1) {
            --r;
        }
        while (proxVal < r) {
            Integer i = new Integer(r + proxVal * dirVal);
            if (!this.usedRows.containsKey(i)) {
                this.usedRows.put(i, i);
                this.reserveRow(connection, i);
                return i;
            }
            int j = i;
            if (j <= min) {
                return j + 2;
            }
            if (j >= max) {
                return j - 2;
            }
            if (dirVal == 1) {
                dirVal = -1;
                continue;
            }
            dirVal = 1;
            proxVal += 2;
        }
        return r;
    }

    protected Ray getStartDirection(Connection conn) {
        Rectangle rect;
        ConnectionAnchor anchor = conn.getSourceAnchor();
        Point p = this.getStartPoint(conn);
        if (anchor.getOwner() == null) {
            rect = new Rectangle(p.x - 1, p.y - 1, 2, 2);
        } else {
            rect = conn.getSourceAnchor().getOwner().getBounds().getCopy();
            conn.getSourceAnchor().getOwner().translateToAbsolute((Translatable)rect);
        }
        return this.getDirection(rect, p);
    }

    protected void processFinalPositions(Ray start, Ray end, List positions, boolean horizontalState, Connection conn) {
        this.removeReservedLines(conn);
        int[] pos = new int[positions.size() + 2];
        pos[0] = horizontalState ? start.x : start.y;
        int i = 0;
        while (i < positions.size()) {
            pos[i + 1] = (Integer)positions.get(i);
            ++i;
        }
        pos[++i] = horizontalState == (positions.size() % 2 == 1) ? end.x : end.y;
        PointList routerPoints = new PointList();
        routerPoints.addPoint(new Point(start.x, start.y));
        i = 2;
        while (i < pos.length - 1) {
            Point newPoint;
            int maxPosition;
            int minPosition;
            boolean adjust;
            horizontalState = !horizontalState;
            int previousPosition = pos[i - 1];
            int currentPosition = pos[i];
            boolean bl = adjust = i != pos.length - 2;
            if (horizontalState) {
                if (adjust) {
                    minPosition = pos[i - 2];
                    maxPosition = pos[i + 2];
                    pos[i] = currentPosition = this.getNearestRow(conn, currentPosition, minPosition, maxPosition);
                }
                newPoint = new Point(previousPosition, currentPosition);
            } else {
                if (adjust) {
                    minPosition = pos[i - 2];
                    maxPosition = pos[i + 2];
                    pos[i] = currentPosition = this.getNearestColumn(conn, currentPosition, minPosition, maxPosition);
                }
                newPoint = new Point(currentPosition, previousPosition);
            }
            routerPoints.addPoint(newPoint);
            ++i;
        }
        routerPoints.addPoint(new Point(end.x, end.y));
        conn.setPoints(routerPoints);
    }

    public void remove(Connection connection) {
        this.removeReservedLines(connection);
    }

    protected void reserveColumn(Connection connection, Integer column) {
        ReservedInfo info = this.reservedInfo.get(connection);
        if (info == null) {
            info = new ReservedInfo();
            this.reservedInfo.put(connection, info);
        }
        info.reservedColumns.add(column);
    }

    protected void reserveRow(Connection connection, Integer row) {
        ReservedInfo info = this.reservedInfo.get(connection);
        if (info == null) {
            info = new ReservedInfo();
            this.reservedInfo.put(connection, info);
        }
        info.reservedRows.add(row);
    }

    protected void removeReservedLines(Connection connection) {
        ReservedInfo rInfo = this.reservedInfo.get(connection);
        if (rInfo == null) {
            return;
        }
        int i = 0;
        while (i < rInfo.reservedRows.size()) {
            this.usedRows.remove(rInfo.reservedRows.get(i));
            ++i;
        }
        i = 0;
        while (i < rInfo.reservedColumns.size()) {
            this.usedColumns.remove(rInfo.reservedColumns.get(i));
            ++i;
        }
        this.reservedInfo.remove(connection);
    }

    public void route(Connection conn) {
        if (conn.getTargetAnchor() == null || conn.getSourceAnchor() == null) {
            return;
        }
        Point startingPt = this.getStartPoint(conn);
        conn.translateToRelative((Translatable)startingPt);
        Point endPt = this.getEndPoint(conn);
        conn.translateToRelative((Translatable)endPt);
        Ray startRay = new Ray(startingPt);
        Ray endRay = new Ray(endPt);
        Ray averageRay = startRay.getAveraged(endRay);
        Ray direction = new Ray(startRay, endRay);
        Ray startingNormal = this.getStartDirection(conn);
        Ray endingNormal = this.getEndDirection(conn);
        Vector<Integer> positions = new Vector<Integer>(5);
        boolean horizontalState = startingNormal.isHorizontal();
        if (horizontalState) {
            positions.add(new Integer(startRay.y));
        } else {
            positions.add(new Integer(startRay.x));
        }
        boolean bl = horizontalState = !horizontalState;
        if (startingNormal.dotProduct(endingNormal) == 0) {
            if (startingNormal.dotProduct(direction) < 0 || endingNormal.dotProduct(direction) > 0) {
                int i = startingNormal.dotProduct(direction) < 0 ? startingNormal.similarity(startRay.getAdded(startingNormal.getScaled(this.offsetPadding))) : (horizontalState ? averageRay.y : averageRay.x);
                positions.add(new Integer(i));
                boolean bl2 = horizontalState = !horizontalState;
                i = endingNormal.dotProduct(direction) > 0 ? endingNormal.similarity(endRay.getAdded(endingNormal.getScaled(this.offsetPadding))) : (horizontalState ? averageRay.y : averageRay.x);
                positions.add(new Integer(i));
                horizontalState = !horizontalState;
            }
        } else if (startingNormal.dotProduct(endingNormal) > 0) {
            int i = startingNormal.dotProduct(direction) >= 0 ? startingNormal.similarity(startRay.getAdded(startingNormal.getScaled(this.offsetPadding))) : endingNormal.similarity(endRay.getAdded(endingNormal.getScaled(this.offsetPadding)));
            positions.add(new Integer(i));
            horizontalState = !horizontalState;
        } else {
            int i;
            if (startingNormal.dotProduct(direction) < 0) {
                i = startingNormal.similarity(startRay.getAdded(startingNormal.getScaled(this.offsetPadding)));
                positions.add(new Integer(i));
                horizontalState = !horizontalState;
            }
            i = horizontalState ? averageRay.y : averageRay.x;
            positions.add(new Integer(i));
            boolean bl3 = horizontalState = !horizontalState;
            if (startingNormal.dotProduct(direction) < 0) {
                i = endingNormal.similarity(endRay.getAdded(endingNormal.getScaled(this.offsetPadding)));
                positions.add(new Integer(i));
                boolean bl4 = horizontalState = !horizontalState;
            }
        }
        if (horizontalState) {
            positions.add(new Integer(endRay.y));
        } else {
            positions.add(new Integer(endRay.x));
        }
        this.processFinalPositions(startRay, endRay, positions, startingNormal.isHorizontal(), conn);
    }

    class ReservedInfo {
        public List<Integer> reservedRows = new ArrayList<Integer>(2);
        public List<Integer> reservedColumns = new ArrayList<Integer>(2);

        ReservedInfo() {
        }
    }
}

