/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui.connection;

import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.BendpointEditPolicy;
import org.eclipse.gef.requests.BendpointRequest;
import org.teiid.designer.diagram.ui.connection.NodeConnectionModel;
import org.teiid.designer.diagram.ui.connection.commands.CreateBendpointCommand;
import org.teiid.designer.diagram.ui.connection.commands.DeleteBendpointCommand;
import org.teiid.designer.diagram.ui.connection.commands.MoveBendpointCommand;

public class LinkBendpointEditPolicy
extends BendpointEditPolicy {
    protected Command getCreateBendpointCommand(BendpointRequest request) {
        Point p = request.getLocation();
        CreateBendpointCommand com = new CreateBendpointCommand(p);
        Connection conn = this.getConnection();
        conn.translateToRelative((Translatable)p);
        com.setLocation(p);
        Point ref1 = this.getConnection().getSourceAnchor().getReferencePoint();
        Point ref2 = this.getConnection().getTargetAnchor().getReferencePoint();
        conn.translateToRelative((Translatable)ref1);
        conn.translateToRelative((Translatable)ref2);
        com.setConnectionModel((NodeConnectionModel)request.getSource().getModel());
        com.setIndex(request.getIndex());
        return com;
    }

    protected Command getMoveBendpointCommand(BendpointRequest request) {
        Point p = request.getLocation();
        MoveBendpointCommand com = new MoveBendpointCommand(p);
        Connection conn = this.getConnection();
        conn.translateToRelative((Translatable)p);
        com.setLocation(p);
        Point ref1 = this.getConnection().getSourceAnchor().getReferencePoint();
        Point ref2 = this.getConnection().getTargetAnchor().getReferencePoint();
        conn.translateToRelative((Translatable)ref1);
        conn.translateToRelative((Translatable)ref2);
        com.setConnectionModel((NodeConnectionModel)request.getSource().getModel());
        com.setIndex(request.getIndex());
        return com;
    }

    protected Command getDeleteBendpointCommand(BendpointRequest request) {
        DeleteBendpointCommand com = new DeleteBendpointCommand();
        Point p = request.getLocation();
        com.setLocation(p);
        com.setConnectionModel((NodeConnectionModel)request.getSource().getModel());
        com.setIndex(request.getIndex());
        return com;
    }
}

