/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui.connection;

import org.eclipse.draw2d.AbstractConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;

public class NodeConnectionAnchor
extends AbstractConnectionAnchor {
    public static final boolean IS_SOURCE = true;
    public static final boolean IS_TARGET = false;
    private boolean leftToRight = true;
    private int offsetH;
    private int offsetV;
    private boolean topDown = true;
    private int direction;
    private boolean isSourceAnchor = true;

    public NodeConnectionAnchor(IFigure iOwner) {
        super(iOwner);
    }

    public NodeConnectionAnchor(IFigure iOwner, boolean isSource) {
        super(iOwner);
        this.isSourceAnchor = isSource;
    }

    public Point getLocation(Point iReference) {
        Rectangle r = this.getOwner().getBounds();
        int y = this.topDown ? r.y + this.offsetV : r.y + r.height - this.offsetV;
        int x = this.leftToRight ? r.x + this.offsetH : r.x + r.width - this.offsetH;
        Point p = new Point(x, y);
        this.getOwner().translateToAbsolute((Translatable)p);
        return p;
    }

    public void setHOffset(int newHOffset) {
        this.offsetH = newHOffset;
    }

    public void setAsSource(boolean isSource) {
        this.isSourceAnchor = isSource;
    }

    public boolean isSource() {
        return this.isSourceAnchor;
    }

    public int getOffsetH() {
        return this.offsetH;
    }

    public int getOffsetV() {
        return this.offsetV;
    }

    public boolean isTopDown() {
        return this.topDown;
    }

    public void setOffsetH(int i) {
        this.offsetH = i;
    }

    public void setOffsetV(int i) {
        this.offsetV = i;
    }

    public void setTopDown(boolean b) {
        this.topDown = b;
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int i) {
        this.direction = i;
    }

    public boolean equals(Object oNodeConnectionAnchor) {
        if (oNodeConnectionAnchor instanceof NodeConnectionAnchor) {
            NodeConnectionAnchor ncaTarget = (NodeConnectionAnchor)((Object)oNodeConnectionAnchor);
            if (this.getOffsetH() == ncaTarget.getOffsetH() && this.getOffsetV() == ncaTarget.getOffsetV() && this.getDirection() == ncaTarget.getDirection() && this.isTopDown() == ncaTarget.isTopDown() && this.isSource() == ncaTarget.isSource()) {
                return true;
            }
        }
        return false;
    }
}

