/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui.connection;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.teiid.designer.diagram.ui.connection.LinkBendpointEditPolicy;
import org.teiid.designer.diagram.ui.connection.NodeConnectionAnchor;
import org.teiid.designer.diagram.ui.connection.NodeConnectionModel;
import org.teiid.designer.diagram.ui.editor.DiagramViewer;
import org.teiid.designer.diagram.ui.figure.DiagramPolylineConnection;
import org.teiid.designer.diagram.ui.model.DiagramModelNode;
import org.teiid.designer.diagram.ui.part.DiagramEditPart;

public class NodeConnectionEditPart
extends AbstractConnectionEditPart
implements PropertyChangeListener,
FigureListener {
    private ConnectionAnchor sourceAnchor;
    private ConnectionAnchor targetAnchor;
    private DiagramViewer diagramViewer;
    private boolean allowBendpoints = false;

    protected IFigure createFigure() {
        IFigure connectionFigure = super.createFigure();
        ((PolylineConnection)connectionFigure).setLineStyle(3);
        int iStandardWidth = ((PolylineConnection)connectionFigure).getLineWidth();
        iStandardWidth = 1;
        ((PolylineConnection)connectionFigure).setLineWidth(iStandardWidth);
        ((PolylineConnection)connectionFigure).setForegroundColor(ColorConstants.blue);
        return connectionFigure;
    }

    protected NodeConnectionModel getConnectionModel() {
        return (NodeConnectionModel)this.getModel();
    }

    protected void createEditPolicies() {
        this.installEditPolicy("Connection Endpoint Policy", null);
        if (this.allowBendpoints) {
            this.installEditPolicy("Connection Bendpoint Policy", (EditPolicy)new LinkBendpointEditPolicy());
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String prop = evt.getPropertyName();
        if (prop.equals("children")) {
            this.refreshVisuals();
        } else if (prop.equals("size")) {
            this.refreshVisuals();
        } else if (prop.equals("location")) {
            this.refreshVisuals();
        } else if (prop.equals("prop")) {
            this.refreshVisuals();
        } else if (prop.equals("bendpoint")) {
            this.refreshBendpoints();
        }
    }

    protected void refreshBendpoints() {
        if (((NodeConnectionModel)this.getModel()).getRouterStyle() != 2) {
            return;
        }
        List modelConstraint = this.getConnectionModel().getBendpoints();
        this.getConnectionFigure().setRoutingConstraint((Object)modelConstraint);
    }

    public void activate() {
        if (this.isActive()) {
            return;
        }
        super.activate();
        ((NodeConnectionModel)this.getModel()).addPropertyChangeListener(this);
        this.getFigure().addFigureListener((FigureListener)this);
    }

    public void deactivate() {
        if (!this.isActive()) {
            return;
        }
        super.deactivate();
        ((NodeConnectionModel)this.getModel()).removePropertyChangeListener(this);
        this.getFigure().removeFigureListener((FigureListener)this);
    }

    public void refreshVisuals() {
    }

    public void figureMoved(IFigure fig) {
        NodeConnectionModel daAssociation = (NodeConnectionModel)this.getModel();
        if (this.getSource() instanceof DiagramEditPart && this.getTarget() instanceof DiagramEditPart) {
            DiagramEditPart depSourceEditPart = (DiagramEditPart)this.getSource();
            DiagramEditPart depTargetEditPart = (DiagramEditPart)this.getTarget();
            if (depSourceEditPart != null && depTargetEditPart != null) {
                ConnectionAnchor ncaSourceAnchor = depSourceEditPart.getSourceConnectionAnchor((ConnectionEditPart)this);
                ConnectionAnchor ncaTargetAnchor = depTargetEditPart.getTargetConnectionAnchor((ConnectionEditPart)this);
                if (ncaSourceAnchor != null && ncaTargetAnchor != null && ncaSourceAnchor instanceof NodeConnectionAnchor && ncaTargetAnchor instanceof NodeConnectionAnchor) {
                    daAssociation.placeStereotypeAndName(((NodeConnectionAnchor)ncaSourceAnchor).getDirection(), ((NodeConnectionAnchor)ncaTargetAnchor).getDirection(), this.getConnectionFigure().getPoints());
                }
            }
        }
    }

    public void setSourceAndTarget(DiagramEditPart someEditPart) {
        DiagramEditPart rootEditPart;
        NodeConnectionModel daAssociation = (NodeConnectionModel)this.getModel();
        if (this.getSource() == null) {
            if (daAssociation.getSourceNode().equals(someEditPart.getModel())) {
                this.setSource((EditPart)someEditPart);
            } else {
                rootEditPart = (DiagramEditPart)someEditPart.getViewer().getContents();
                DiagramEditPart sourceEditPart = rootEditPart.getEditPart((DiagramModelNode)daAssociation.getSourceNode());
                this.setSource((EditPart)sourceEditPart);
            }
        }
        if (this.getTarget() == null) {
            if (daAssociation.getTargetNode().equals(someEditPart.getModel())) {
                this.setTarget((EditPart)someEditPart);
            } else {
                rootEditPart = (DiagramEditPart)someEditPart.getViewer().getContents();
                DiagramEditPart targetEditPart = rootEditPart.getEditPart((DiagramModelNode)daAssociation.getTargetNode());
                this.setTarget((EditPart)targetEditPart);
            }
        }
    }

    public void setSourceAndTarget(EditPart someEditPart) {
        EditPart nextChild;
        Iterator iter;
        Object rootEditPart;
        NodeConnectionModel daAssociation = (NodeConnectionModel)this.getModel();
        if (this.getSource() == null) {
            if (daAssociation.getSourceNode().equals(someEditPart.getModel())) {
                this.setSource(someEditPart);
            } else if (someEditPart instanceof DiagramEditPart) {
                rootEditPart = (DiagramEditPart)someEditPart.getViewer().getContents();
                DiagramEditPart sourceEditPart = rootEditPart.getEditPart((DiagramModelNode)daAssociation.getSourceNode());
                this.setSource((EditPart)sourceEditPart);
            } else {
                rootEditPart = someEditPart.getViewer().getContents();
                iter = rootEditPart.getChildren().iterator();
                EditPart sourcePart = null;
                nextChild = null;
                Object sourceNode = daAssociation.getSourceNode();
                while (iter.hasNext() && sourcePart == null) {
                    nextChild = (EditPart)iter.next();
                    if (nextChild.getModel() == null || !nextChild.getModel().equals(sourceNode)) continue;
                    sourcePart = nextChild;
                }
                this.setSource(sourcePart);
            }
        }
        if (this.getTarget() == null) {
            if (daAssociation.getTargetNode().equals(someEditPart.getModel())) {
                this.setTarget(someEditPart);
            } else if (someEditPart instanceof DiagramEditPart) {
                rootEditPart = (DiagramEditPart)someEditPart.getViewer().getContents();
                DiagramEditPart targetEditPart = rootEditPart.getEditPart((DiagramModelNode)daAssociation.getTargetNode());
                this.setTarget((EditPart)targetEditPart);
            } else {
                rootEditPart = someEditPart.getViewer().getContents();
                iter = rootEditPart.getChildren().iterator();
                EditPart targetPart = null;
                nextChild = null;
                Object targetNode = daAssociation.getTargetNode();
                while (iter.hasNext() && targetPart == null) {
                    nextChild = (EditPart)iter.next();
                    if (nextChild.getModel() == null || !nextChild.getModel().equals(targetNode)) continue;
                    targetPart = nextChild;
                }
                this.setTarget(targetPart);
            }
        }
    }

    public ConnectionAnchor getSourceAnchor() {
        return this.sourceAnchor;
    }

    public ConnectionAnchor getTargetAnchor() {
        return this.targetAnchor;
    }

    public void setSourceAnchor(ConnectionAnchor anchor) {
        this.sourceAnchor = anchor;
    }

    public void setTargetAnchor(ConnectionAnchor anchor) {
        this.targetAnchor = anchor;
    }

    public DiagramViewer getDiagramViewer() {
        return this.diagramViewer;
    }

    public void setDiagramViewer(DiagramViewer viewer) {
        this.diagramViewer = viewer;
    }

    public void hilite(boolean value) {
        if (this.getFigure() instanceof DiagramPolylineConnection) {
            ((DiagramPolylineConnection)this.getFigure()).hilite(value);
        }
    }

    public boolean isAllowBendpoints() {
        return this.allowBendpoints;
    }

    public void setAllowBendpoints(boolean allowBendpoints) {
        this.allowBendpoints = allowBendpoints;
    }
}

