/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui.custom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.diagram.ui.DiagramUiConstants;
import org.teiid.designer.diagram.ui.custom.CustomDiagramModelFactory;
import org.teiid.designer.diagram.ui.editor.DiagramEditor;
import org.teiid.designer.diagram.ui.editor.DiagramEditorUtil;
import org.teiid.designer.diagram.ui.model.DiagramModelNode;
import org.teiid.designer.diagram.ui.util.DiagramUiUtilities;
import org.teiid.designer.diagram.ui.util.RelationalUmlEObjectHelper;
import org.teiid.designer.metamodels.diagram.Diagram;

public class CustomDiagramContentHelper {
    public static List getApplicableDiagramEObjects(List selectedEObjects) {
        HashSet<EObject> applicableEObjects = new HashSet<EObject>(selectedEObjects.size());
        for (EObject nextEObj : selectedEObjects) {
            int objType = RelationalUmlEObjectHelper.getEObjectType(nextEObj);
            switch (objType) {
                case 2: 
                case 4: {
                    applicableEObjects.add(nextEObj.eContainer());
                    break;
                }
                default: {
                    applicableEObjects.add(nextEObj);
                }
            }
        }
        return new ArrayList(applicableEObjects);
    }

    public static List getActualObjectsToAdd(List originalObjects, DiagramModelNode diagramRootModelNode) {
        List applicableObjectsToAdd = CustomDiagramContentHelper.getApplicableDiagramEObjects(originalObjects);
        ArrayList<EObject> objectsToAdd = new ArrayList<EObject>(applicableObjectsToAdd.size());
        for (EObject nextEObj : applicableObjectsToAdd) {
            if (CustomDiagramContentHelper.objectAlreadyInDiagram(nextEObj, diagramRootModelNode)) continue;
            objectsToAdd.add(nextEObj);
        }
        return objectsToAdd;
    }

    public static boolean objectAlreadyInDiagram(EObject eObj, DiagramModelNode diagramRootModelNode) {
        return DiagramUiUtilities.getDiagramModelNode(eObj, diagramRootModelNode) != null;
    }

    public static List addToCustomDiagram(Diagram diagram, List objectsToAdd, DiagramEditor diagramEditor, Object txnSource) {
        List addableObjects = Collections.EMPTY_LIST;
        if (diagramEditor != null) {
            DiagramModelNode diagramNode = diagramEditor.getCurrentModel();
            CustomDiagramModelFactory modelFactory = (CustomDiagramModelFactory)diagramEditor.getModelFactory();
            addableObjects = CustomDiagramContentHelper.getActualObjectsToAdd(objectsToAdd, diagramNode);
            if (!addableObjects.isEmpty() && diagramNode != null && modelFactory != null) {
                boolean handleConstruction = !DiagramEditorUtil.isDiagramUnderConstruction(diagram);
                boolean requiredStart = false;
                boolean succeeded = false;
                try {
                    try {
                        if (handleConstruction) {
                            DiagramEditorUtil.setDiagramUnderConstruction(diagram);
                        }
                        requiredStart = ModelerCore.startTxn((boolean)true, (boolean)false, (String)"Add To Custom Diagram", (Object)txnSource);
                        modelFactory.add(addableObjects, diagramNode);
                        succeeded = true;
                    }
                    catch (Exception ex) {
                        DiagramUiConstants.Util.log(4, (Throwable)ex, String.valueOf(ex.getClass().getName()) + ": addToCustomDiagram()");
                        if (requiredStart) {
                            if (succeeded) {
                                ModelerCore.commitTxn();
                            } else {
                                ModelerCore.rollbackTxn();
                            }
                        }
                        if (handleConstruction) {
                            DiagramEditorUtil.setDiagramConstructionComplete(diagram, true);
                        }
                    }
                }
                finally {
                    if (requiredStart) {
                        if (succeeded) {
                            ModelerCore.commitTxn();
                        } else {
                            ModelerCore.rollbackTxn();
                        }
                    }
                    if (handleConstruction) {
                        DiagramEditorUtil.setDiagramConstructionComplete(diagram, true);
                    }
                }
            }
        }
        return addableObjects;
    }
}

