/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui.custom;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.teiid.designer.core.metamodel.aspect.MetamodelAspect;
import org.teiid.designer.core.metamodel.aspect.uml.UmlClassifier;
import org.teiid.designer.core.metamodel.aspect.uml.UmlPackage;
import org.teiid.designer.core.workspace.ModelDiagrams;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.diagram.ui.DiagramUiConstants;
import org.teiid.designer.diagram.ui.IDiagramProvider;
import org.teiid.designer.metamodels.core.ModelAnnotation;
import org.teiid.designer.metamodels.diagram.Diagram;
import org.teiid.designer.metamodels.diagram.PresentationEntity;
import org.teiid.designer.ui.viewsupport.ModelObjectUtilities;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public final class CustomDiagramContentProvider
implements ITreeContentProvider,
IDiagramProvider,
DiagramUiConstants {
    private static final Object[] NO_CHILDREN = new Object[0];

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public synchronized Object[] getChildren(Object parentElement) {
        Object[] children = NO_CHILDREN;
        if (!(parentElement instanceof PresentationEntity)) {
            if (parentElement instanceof EObject) {
                EObject eObject = (EObject)parentElement;
                ModelResource modelResource = ModelUtilities.getModelResourceForModelObject((EObject)eObject);
                if (modelResource != null) {
                    List diagramList = new ArrayList();
                    ArrayList allChildren = new ArrayList();
                    MetamodelAspect aspect = ModelObjectUtilities.getUmlAspect((EObject)eObject);
                    if (aspect instanceof UmlClassifier) {
                        return children;
                    }
                    if (aspect instanceof UmlPackage) {
                        diagramList = this.getCustomDiagrams(modelResource, eObject);
                    }
                    if (!diagramList.isEmpty()) {
                        allChildren.addAll(diagramList);
                        children = allChildren.toArray();
                    }
                }
            } else if (parentElement instanceof ModelResource) {
                ModelResource modelResource = (ModelResource)parentElement;
                List diagramList = this.getCustomDiagrams(modelResource, null);
                ArrayList allChildren = new ArrayList();
                if (!diagramList.isEmpty()) {
                    allChildren.addAll(diagramList);
                    children = allChildren.toArray();
                }
            }
        }
        return children;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public Object getParent(Object element) {
        EObject result = null;
        if (element instanceof Diagram) {
            EObject target = ((Diagram)element).getTarget();
            if (target instanceof EObject) {
                result = target;
            } else if (target instanceof ModelAnnotation) {
                result = ModelUtilities.getModelResourceForModelObject((EObject)((ModelAnnotation)target));
            }
        }
        return result;
    }

    public boolean hasChildren(Object element) {
        Object[] children = this.getChildren(element);
        return children != null && children.length > 0;
    }

    private List getCustomDiagrams(ModelResource modelResource, EObject eObject) {
        ArrayList<Diagram> customDiagrams;
        block9: {
            customDiagrams = new ArrayList<Diagram>();
            ModelDiagrams modelDiagrams = null;
            try {
                modelDiagrams = modelResource.getModelDiagrams();
                if (modelDiagrams != null && eObject != null) {
                    ArrayList diagramList = new ArrayList(modelDiagrams.getDiagrams(eObject));
                    Iterator iter = diagramList.iterator();
                    Diagram nextDiagram = null;
                    while (iter.hasNext()) {
                        nextDiagram = (Diagram)iter.next();
                        if (nextDiagram.getType() != null) {
                            if (!nextDiagram.getType().equals("customDiagramType")) continue;
                            customDiagrams.add(nextDiagram);
                            continue;
                        }
                        String message = "Diagram has no type!! shouldn't happen. Target = " + eObject + "   Diagram = " + nextDiagram;
                        System.out.println(message);
                    }
                } else if (modelDiagrams != null) {
                    ArrayList diagramList = new ArrayList(modelDiagrams.getDiagrams(null));
                    Iterator iter = diagramList.iterator();
                    Diagram nextDiagram = null;
                    while (iter.hasNext()) {
                        nextDiagram = (Diagram)iter.next();
                        if (nextDiagram.getType() != null) {
                            if (!nextDiagram.getType().equals("customDiagramType")) continue;
                            customDiagrams.add(nextDiagram);
                            continue;
                        }
                        String message = "Diagram has no type!! shouldn't happen. Target = " + eObject + "   Diagram = " + nextDiagram;
                        System.out.println(message);
                    }
                }
            }
            catch (ModelWorkspaceException e) {
                if (modelResource.hasErrors()) break block9;
                String message = Util.getString("CustomDiagramContentProvider.getCustomDiagramError", (Object)modelResource.toString());
                Util.log(4, (Throwable)e, message);
            }
        }
        return customDiagrams;
    }

    @Override
    public boolean canDelete(Diagram diagram) {
        return true;
    }
}

