/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui.custom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.teiid.designer.diagram.ui.custom.CustomDiagramContentHelper;
import org.teiid.designer.diagram.ui.custom.CustomDiagramEditPart;
import org.teiid.designer.diagram.ui.editor.DiagramEditor;
import org.teiid.designer.diagram.ui.editor.DiagramEditorUtil;
import org.teiid.designer.diagram.ui.model.DiagramModelNode;
import org.teiid.designer.diagram.ui.part.DropEditPartHelper;
import org.teiid.designer.diagram.ui.util.DiagramUiUtilities;
import org.teiid.designer.metamodels.diagram.Diagram;

public class CustomDiagramDropEditPartHelper
extends DropEditPartHelper {
    private CustomDiagramEditPart customDiagramEditPart;

    public CustomDiagramDropEditPartHelper(CustomDiagramEditPart customDiagramEditPart) {
        this.customDiagramEditPart = customDiagramEditPart;
    }

    @Override
    public void drop(Point dropPoint, List dropList) {
        Diagram diagram = (Diagram)this.customDiagramEditPart.getModelObject();
        DiagramModelNode diagramRootModelNode = (DiagramModelNode)this.customDiagramEditPart.getModel();
        DiagramEditor diagramEditor = DiagramEditorUtil.getDiagramEditor(diagram);
        List addedObjects = CustomDiagramContentHelper.addToCustomDiagram(diagram, dropList, diagramEditor, this);
        this.layoutNewNodes(dropPoint, addedObjects, diagram, diagramRootModelNode);
    }

    @Override
    public boolean allowsDrop(Object target, List dropList) {
        if (target instanceof CustomDiagramEditPart) {
            return dropList != null && !dropList.isEmpty();
        }
        return false;
    }

    private void layoutNewNodes(Point dropPoint, List addedObjects, Diagram diagram, DiagramModelNode diagramRootModelNode) {
        ArrayList<DiagramModelNode> diagramNodes = new ArrayList<DiagramModelNode>(addedObjects.size());
        for (EObject nextEObj : addedObjects) {
            DiagramModelNode nextNode = DiagramUiUtilities.getDiagramModelNode(nextEObj, diagramRootModelNode);
            if (nextNode == null) continue;
            diagramNodes.add(nextNode);
        }
        Point startPoint = new Point(dropPoint);
        for (DiagramModelNode nextNode : diagramNodes) {
            nextNode.setPosition(startPoint);
            startPoint.x += 20;
            startPoint.y += 20;
        }
    }
}

