/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui.custom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.teiid.designer.core.notification.util.NotificationUtilities;
import org.teiid.designer.core.transaction.SourcedNotification;
import org.teiid.designer.metamodels.diagram.Diagram;
import org.teiid.designer.metamodels.diagram.DiagramEntity;
import org.teiid.designer.ui.viewsupport.ModelObjectUtilities;

public class CustomDiagramNotificationHelper {
    private static final int IGNORE = 0;
    private static final int ADDED = 1;
    private static final int REMOVED = 2;
    private static final int CHANGED = 3;
    private Notification rootNotification;
    private Diagram customDiagram;
    Collection addNotifications;
    Collection removeNotifications;
    Collection changedNotifications;
    Collection movedEObjects;
    HashMap undoAddedObjects;

    public CustomDiagramNotificationHelper(Notification notification, Diagram customDiagram, Object source) {
        this.rootNotification = notification;
        this.customDiagram = customDiagram;
        this.init();
        this.processNotifications();
    }

    private void init() {
        this.addNotifications = new ArrayList();
        this.removeNotifications = new ArrayList();
        this.changedNotifications = new ArrayList();
        this.undoAddedObjects = new HashMap();
    }

    private void processNotifications() {
        if (this.rootNotification instanceof SourcedNotification) {
            Collection notifications = ((SourcedNotification)this.rootNotification).getNotifications();
            Iterator iter = notifications.iterator();
            while (iter.hasNext()) {
                this.processNotification((Notification)iter.next());
            }
        } else {
            this.processNotification(this.rootNotification);
        }
        this.processForMoves();
    }

    private void processNotification(Notification notification) {
        switch (this.getNotificationType(notification)) {
            case 1: {
                if (this.preProcessAddNofication(notification)) break;
                this.addNotifications.add(notification);
                break;
            }
            case 2: {
                if (this.preProcessRemoveNofication(notification)) break;
                this.removeNotifications.add(notification);
                break;
            }
            case 3: {
                this.changedNotifications.add(notification);
            }
        }
    }

    private int getNotificationType(Notification notification) {
        if (NotificationUtilities.isAdded((Notification)notification)) {
            return 1;
        }
        if (NotificationUtilities.isRemoved((Notification)notification)) {
            return 2;
        }
        if (NotificationUtilities.isChanged((Notification)notification)) {
            return 3;
        }
        return 0;
    }

    private void processForMoves() {
        if (!this.addNotifications.isEmpty() && !this.removeNotifications.isEmpty()) {
            ArrayList tempAdds = new ArrayList(this.addNotifications);
            ArrayList tempRemoves = new ArrayList(this.removeNotifications);
            this.movedEObjects = new ArrayList();
            Notification removeNotification2 = null;
            for (Notification removeNotification2 : tempRemoves) {
                Notification addedNotification = null;
                EObject[] oldChildren = NotificationUtilities.getRemovedChildren((Notification)removeNotification2);
                int i = 0;
                while (i < oldChildren.length) {
                    addedNotification = this.getAddedNotification(oldChildren[i], tempAdds);
                    if (addedNotification != null) break;
                    ++i;
                }
                if (addedNotification == null) continue;
                this.removeNotifications.remove(removeNotification2);
                this.addNotifications.remove(addedNotification);
                i = 0;
                while (i < oldChildren.length) {
                    this.movedEObjects.add(oldChildren[i]);
                    ++i;
                }
            }
        }
    }

    private Notification getAddedNotification(EObject eObj, Collection addList) {
        String targetID = ModelObjectUtilities.getUuid((EObject)eObj);
        Iterator iter = addList.iterator();
        Notification nextNotification = null;
        String newChildID = null;
        while (iter.hasNext()) {
            nextNotification = (Notification)iter.next();
            EObject[] newChildren = NotificationUtilities.getAddedChildren((Notification)nextNotification);
            int i = 0;
            while (i < newChildren.length) {
                newChildID = ModelObjectUtilities.getUuid((EObject)newChildren[i]);
                if (targetID != null && targetID.equals(newChildID)) {
                    return nextNotification;
                }
                ++i;
            }
        }
        return null;
    }

    private boolean preProcessAddNofication(Notification notification) {
        EObject[] newChildren = NotificationUtilities.getAddedChildren((Notification)notification);
        int i = 0;
        while (i < newChildren.length) {
            if (newChildren[i] instanceof DiagramEntity) {
                return true;
            }
            if (this.wasDiagramEntityAdded(newChildren[i])) {
                if (this.undoAddedObjects.get(newChildren[i]) == null) {
                    this.undoAddedObjects.put(newChildren[i], "x");
                }
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean preProcessRemoveNofication(Notification notification) {
        EObject[] oldChildren = NotificationUtilities.getRemovedChildren((Notification)notification);
        int i = 0;
        while (i < oldChildren.length) {
            if (oldChildren[i] instanceof DiagramEntity) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean wasDiagramEntityAdded(EObject eObj) {
        block7: {
            String targetID;
            block6: {
                targetID = ModelObjectUtilities.getUuid((EObject)eObj);
                if (!(this.rootNotification instanceof SourcedNotification)) break block6;
                Notification nextNotification2 = null;
                Collection notifications = ((SourcedNotification)this.rootNotification).getNotifications();
                for (Notification nextNotification2 : notifications) {
                    if (this.getNotificationType(nextNotification2) != 1) continue;
                    EObject[] newChildren = NotificationUtilities.getAddedChildren((Notification)nextNotification2);
                    int i = 0;
                    while (i < newChildren.length) {
                        EObject modelObject;
                        Diagram deDiagram;
                        if (newChildren[i] instanceof DiagramEntity && (deDiagram = ((DiagramEntity)newChildren[i]).getDiagram()) != null && deDiagram == this.customDiagram && (modelObject = ((DiagramEntity)newChildren[i]).getModelObject()) != null && modelObject == eObj) {
                            return true;
                        }
                        ++i;
                    }
                }
                break block7;
            }
            if (this.getNotificationType(this.rootNotification) != 1) break block7;
            EObject[] newChildren = NotificationUtilities.getAddedChildren((Notification)this.rootNotification);
            String newChildID = null;
            int i = 0;
            while (i < newChildren.length) {
                EObject modelObject;
                if (newChildren[i] instanceof DiagramEntity && (modelObject = ((DiagramEntity)newChildren[i]).getModelObject()) != null) {
                    newChildID = ModelObjectUtilities.getUuid((EObject)newChildren[i]);
                }
                if (newChildID != null && targetID != null && targetID.equals(newChildID)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public Collection getAddNotifications() {
        if (this.addNotifications == null || this.addNotifications.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return this.addNotifications;
    }

    public Collection getChangedNotifications() {
        if (this.changedNotifications == null || this.changedNotifications.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return this.changedNotifications;
    }

    public Collection getMovedEObjects() {
        if (this.movedEObjects == null || this.movedEObjects.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return this.movedEObjects;
    }

    public Collection getRemoveNotifications() {
        if (this.removeNotifications == null || this.removeNotifications.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return this.removeNotifications;
    }

    public Collection getUndoAddedEObjects() {
        if (this.undoAddedObjects == null || this.undoAddedObjects.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return new ArrayList(this.undoAddedObjects.keySet());
    }
}

