/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui.custom.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchPart;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.diagram.ui.DiagramUiConstants;
import org.teiid.designer.diagram.ui.DiagramUiPlugin;
import org.teiid.designer.diagram.ui.actions.DiagramAction;
import org.teiid.designer.diagram.ui.connection.UmlRelationshipHelper;
import org.teiid.designer.diagram.ui.custom.CustomDiagramModelFactory;
import org.teiid.designer.diagram.ui.editor.DiagramEditor;
import org.teiid.designer.diagram.ui.editor.DiagramEditorUtil;
import org.teiid.designer.diagram.ui.model.DiagramModelNode;
import org.teiid.designer.diagram.ui.util.DiagramUiUtilities;
import org.teiid.designer.metamodels.diagram.Diagram;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.editors.ModelEditor;

public class AddAssociatedObjectsAction
extends DiagramAction {
    private static final String THIS_CLASS = "AddAssociatedObjectsAction";
    private DiagramEditor editor;

    public AddAssociatedObjectsAction() {
        this.setImageDescriptor(DiagramUiPlugin.getDefault().getImageDescriptor("icons/full/cview20/tb_add_to_diagram.gif"));
    }

    public void selectionChanged(IWorkbenchPart thePart, ISelection theSelection) {
        super.selectionChanged(thePart, theSelection);
        this.setEnabled(this.shouldEnable());
    }

    @Override
    protected void doRun() {
        if (this.editor != null) {
            DiagramModelNode diagramNode = this.editor.getCurrentModel();
            Diagram diagram = (Diagram)diagramNode.getModelObject();
            CustomDiagramModelFactory modelFactory = (CustomDiagramModelFactory)this.editor.getModelFactory();
            List objectsToAdd = this.getAssociatedObjectsNotInDiagram();
            if (!objectsToAdd.isEmpty() && modelFactory != null) {
                boolean handleConstruction = !DiagramEditorUtil.isDiagramUnderConstruction(diagram);
                boolean requiredStart = false;
                boolean succeeded = false;
                try {
                    try {
                        if (handleConstruction) {
                            DiagramEditorUtil.setDiagramUnderConstruction(diagram);
                        }
                        requiredStart = ModelerCore.startTxn((boolean)true, (boolean)false, (String)"Add Related Objects", (Object)((Object)this));
                        modelFactory.add(objectsToAdd, diagramNode);
                        succeeded = true;
                    }
                    catch (Exception ex) {
                        DiagramUiConstants.Util.log(4, (Throwable)ex, String.valueOf(ex.getClass().getName()) + ":" + THIS_CLASS + ".doRun()");
                        if (requiredStart) {
                            if (succeeded) {
                                ModelerCore.commitTxn();
                            } else {
                                ModelerCore.rollbackTxn();
                            }
                        }
                        if (handleConstruction) {
                            DiagramEditorUtil.setDiagramConstructionComplete(diagram, true);
                        }
                    }
                }
                finally {
                    if (requiredStart) {
                        if (succeeded) {
                            ModelerCore.commitTxn();
                        } else {
                            ModelerCore.rollbackTxn();
                        }
                    }
                    if (handleConstruction) {
                        DiagramEditorUtil.setDiagramConstructionComplete(diagram, true);
                    }
                }
            }
        }
    }

    private boolean shouldEnable() {
        if (!(this.getPart() instanceof ModelEditor) || this.getSelection() == null || SelectionUtilities.getSelectedEObjects((ISelection)this.getSelection()).size() < 0) {
            return false;
        }
        return this.allSelectedInDiagram() && this.isWritable() && this.allObjectsAddable();
    }

    private boolean allSelectedInDiagram() {
        if (this.editor != null && this.editor.getDiagramViewer() != null && this.editor.getDiagramViewer().getSelectionHandler() != null) {
            List selectedEObjects = this.editor.getDiagramViewer().getSelectionHandler().getSelectedEObjects();
            if (selectedEObjects == null || selectedEObjects.isEmpty()) {
                return false;
            }
            Iterator iter = SelectionUtilities.getSelectedEObjects((ISelection)this.getSelection()).iterator();
            EObject eObj = null;
            while (iter.hasNext()) {
                eObj = (EObject)iter.next();
                if (selectedEObjects.contains(eObj)) continue;
                return false;
            }
        }
        return true;
    }

    public void setDiagramEditor(DiagramEditor editor) {
        this.editor = editor;
    }

    private boolean isWritable() {
        DiagramModelNode currentDiagram;
        if (this.editor != null && (currentDiagram = this.editor.getCurrentModel()) != null) {
            return !this.isReadOnly();
        }
        return false;
    }

    private boolean allObjectsAddable() {
        boolean allOK = true;
        List objectsToAdd = this.getAssociatedObjectsNotInDiagram();
        if (objectsToAdd == null || objectsToAdd.isEmpty()) {
            allOK = false;
        }
        return allOK;
    }

    private List getAssociatedObjectsNotInDiagram() {
        ArrayList<EObject> newObjects = new ArrayList<EObject>();
        if (this.editor != null && this.editor.getCurrentModel() != null) {
            DiagramModelNode diagramNode = this.editor.getCurrentModel();
            List allAssociatedToAdd = UmlRelationshipHelper.getRelatedObjects(SelectionUtilities.getSelectedEObjects((ISelection)this.getSelection()));
            Iterator iter = allAssociatedToAdd.iterator();
            EObject nextEObj = null;
            while (iter.hasNext()) {
                nextEObj = (EObject)iter.next();
                if (this.editor == null || this.editor.getCurrentModel() == null || DiagramUiUtilities.diagramContainsEObject(nextEObj, diagramNode)) continue;
                newObjects.add(nextEObj);
            }
        }
        if (newObjects.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return newObjects;
    }

    @Override
    protected boolean requiresEditorForRun() {
        return false;
    }
}

