/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui.custom.actions;

import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.teiid.designer.core.metamodel.aspect.MetamodelAspect;
import org.teiid.designer.core.metamodel.aspect.uml.UmlClassifier;
import org.teiid.designer.core.metamodel.aspect.uml.UmlPackage;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.diagram.ui.DiagramUiPlugin;
import org.teiid.designer.diagram.ui.actions.DiagramAction;
import org.teiid.designer.diagram.ui.custom.CustomDiagramContentHelper;
import org.teiid.designer.diagram.ui.editor.DiagramEditor;
import org.teiid.designer.diagram.ui.editor.DiagramToolBarManager;
import org.teiid.designer.diagram.ui.model.DiagramModelNode;
import org.teiid.designer.diagram.ui.util.DiagramUiUtilities;
import org.teiid.designer.metamodels.diagram.Diagram;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.editors.ModelEditor;
import org.teiid.designer.ui.editors.ModelEditorManager;
import org.teiid.designer.ui.search.SearchPageUtil;
import org.teiid.designer.ui.viewsupport.ModelObjectUtilities;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class AddToDiagramAction
extends DiagramAction {
    private DiagramEditor diagramEditor;
    private ActionContributionItem thisToolItem;
    private DiagramToolBarManager toolBarManager;
    private ISelection oldSelection;
    private ISelection focusedSelection;

    public AddToDiagramAction() {
        this.setImageDescriptor(DiagramUiPlugin.getDefault().getImageDescriptor("icons/full/cview16/tb_add_to_diagram.gif"));
    }

    public void selectionChanged(IWorkbenchPart thePart, ISelection theSelection) {
        if (thePart != null && thePart instanceof ModelEditor) {
            this.oldSelection = this.getSelection();
        }
        ISelection selection = theSelection;
        List searchResults = SearchPageUtil.getEObjectsFromSearchSelection((ISelection)theSelection);
        if (searchResults != null) {
            selection = searchResults.isEmpty() ? new StructuredSelection() : new StructuredSelection(searchResults);
        }
        super.selectionChanged(thePart, selection);
        this.setFocusedSelection();
        this.setEnabled(this.shouldEnable());
    }

    @Override
    protected void doRun() {
        if (this.diagramEditor != null) {
            DiagramModelNode diagramNode = this.diagramEditor.getCurrentModel();
            Diagram diagram = (Diagram)diagramNode.getModelObject();
            CustomDiagramContentHelper.addToCustomDiagram(diagram, SelectionUtilities.getSelectedEObjects((ISelection)this.focusedSelection), this.diagramEditor, (Object)this);
        }
        this.toolBarManager.resetFocusedToolItem();
        this.setFocusedSelection();
    }

    public void setDiagramEditor(DiagramEditor editor) {
        this.diagramEditor = editor;
    }

    private boolean shouldEnable() {
        boolean enable = false;
        enable = this.isWritable() && this.allObjectsAddable();
        return enable;
    }

    public boolean wasToolBarItemSelected() {
        return this.toolBarManager != null && this.toolBarManager.getFocusedToolItem() != null && this.thisToolItem != null && this.thisToolItem.equals((Object)this.toolBarManager.getFocusedToolItem());
    }

    public void setItem(ActionContributionItem aci) {
        this.thisToolItem = aci;
    }

    private void setFocusedSelection() {
        this.focusedSelection = this.wasToolBarItemSelected() ? this.oldSelection : this.getSelection();
    }

    public void setToolBarManager(DiagramToolBarManager tbManager) {
        this.toolBarManager = tbManager;
    }

    private boolean isWritable() {
        EObject diagram;
        DiagramModelNode currentDiagram;
        return this.diagramEditor != null && (currentDiagram = this.diagramEditor.getCurrentModel()) != null && !ModelObjectUtilities.isReadOnly((EObject)(diagram = currentDiagram.getModelObject()));
    }

    private boolean allObjectsAddable() {
        boolean allOK = true;
        List selectedEObjects = SelectionUtilities.getSelectedEObjects((ISelection)this.focusedSelection);
        if (!selectedEObjects.isEmpty()) {
            List applicableObjectsToAdd = CustomDiagramContentHelper.getApplicableDiagramEObjects(selectedEObjects);
            Object nextObject = null;
            Iterator iter = applicableObjectsToAdd.iterator();
            MetamodelAspect someAspect = null;
            while (iter.hasNext() && allOK) {
                nextObject = iter.next();
                if (nextObject instanceof Diagram) {
                    allOK = false;
                    continue;
                }
                someAspect = ModelObjectUtilities.getUmlAspect((EObject)nextObject);
                if (someAspect == null || !(someAspect instanceof UmlPackage) && !(someAspect instanceof UmlClassifier)) {
                    allOK = false;
                }
                if (!allOK || this.diagramEditor == null || this.diagramEditor.getCurrentModel() == null) continue;
                boolean bl = allOK = !DiagramUiUtilities.diagramContainsEObject(nextObject, this.diagramEditor.getCurrentModel());
            }
        } else {
            allOK = false;
        }
        return allOK;
    }

    protected boolean preRun() {
        EObject eObject;
        ModelResource mr;
        List allSelectedEObjects;
        if (this.requiresEditorForRun() && (allSelectedEObjects = SelectionUtilities.getSelectedEObjects((ISelection)this.focusedSelection)) != null && !allSelectedEObjects.isEmpty() && (mr = ModelUtilities.getModelResourceForModelObject((EObject)(eObject = this.diagramEditor.getCurrentModel().getModelObject()))) != null) {
            ModelEditorManager.activate((ModelResource)mr, (boolean)false);
        }
        return true;
    }
}

