/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui.custom.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.diagram.ui.DiagramUiConstants;
import org.teiid.designer.diagram.ui.DiagramUiPlugin;
import org.teiid.designer.diagram.ui.actions.DiagramAction;
import org.teiid.designer.diagram.ui.connection.UmlRelationshipHelper;
import org.teiid.designer.diagram.ui.custom.CustomDiagramContentHelper;
import org.teiid.designer.diagram.ui.custom.CustomDiagramModelFactory;
import org.teiid.designer.diagram.ui.custom.actions.AssociatedLevelsDialog;
import org.teiid.designer.diagram.ui.editor.DiagramEditor;
import org.teiid.designer.diagram.ui.editor.DiagramEditorUtil;
import org.teiid.designer.diagram.ui.model.DiagramModelNode;
import org.teiid.designer.diagram.ui.util.DiagramUiUtilities;
import org.teiid.designer.metamodels.diagram.Diagram;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.editors.ModelEditorManager;
import org.teiid.designer.ui.explorer.ModelExplorerContentProvider;
import org.teiid.designer.ui.explorer.ModelExplorerLabelProvider;
import org.teiid.designer.ui.viewsupport.ModelUtilities;
import org.teiid.designer.ui.viewsupport.ModelWorkspaceViewerFilter;

public class AddToNewCustomDiagramAction
extends DiagramAction
implements DiagramUiConstants {
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix(AddToNewCustomDiagramAction.class);
    private static final String TARGET_SELECTION_DIALOG_TITLE = AddToNewCustomDiagramAction.getString("containerSelectionDialogTitle");
    private static final String EMPTY_STRING = "";
    private static final String TARGET_SELECTION_DIALOG_MESSAGE = AddToNewCustomDiagramAction.getString("containerSelectionDialogMessage");
    static final String INVALID_SELECTION_MESSAGE = AddToNewCustomDiagramAction.getString("invalidSelectionMessage");
    static final String READ_ONLY_MODEL_SELECTION_MESSAGE = AddToNewCustomDiagramAction.getString("readOnlyModelSelectionMessage");
    static final String READ_ONLY_OBJECT_SELECTION_MESSAGE = AddToNewCustomDiagramAction.getString("readOnlyObjectSelectionMessage");
    private static final String LEVELS_SELECTION_DIALOG_TITLE = AddToNewCustomDiagramAction.getString("levelsDialogTitle");
    private static final boolean PERSIST_CUSTOM_DIAGRAMS = true;
    private static final String THIS_CLASS = "AddToNewCustomDiagramAction";

    private static String getString(String id) {
        return Util.getString(String.valueOf(I18N_PREFIX) + id, new Object[0]);
    }

    public AddToNewCustomDiagramAction() {
    }

    public AddToNewCustomDiagramAction(int theStyle) {
        super(theStyle);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        super.selectionChanged(part, selection);
        this.determineEnablement();
    }

    @Override
    protected void doRun() {
        block22: {
            DiagramEditor dEditor;
            boolean diagramWasConstructed;
            Diagram newDiagram;
            block25: {
                block26: {
                    List selectedEObjects = SelectionUtilities.getSelectedEObjects((ISelection)this.getSelection());
                    if (selectedEObjects == null || selectedEObjects.isEmpty()) break block22;
                    Object selectedContainer = this.getTargetForDiagram();
                    newDiagram = null;
                    diagramWasConstructed = false;
                    if (selectedContainer == null) break block22;
                    this.verifyResouceOpen(selectedContainer);
                    dEditor = null;
                    boolean requiredStart = false;
                    boolean succeeded = false;
                    try {
                        requiredStart = ModelerCore.startTxn((boolean)true, (boolean)false, (String)"Add To New Custom Diagram", (Object)this);
                        newDiagram = this.createDiagram(selectedContainer);
                        if (newDiagram != null) {
                            diagramWasConstructed = true;
                            ModelEditorManager.open((EObject)newDiagram, (boolean)true);
                            dEditor = DiagramEditorUtil.getVisibleDiagramEditor();
                            DiagramModelNode diagramNode = dEditor.getCurrentModel();
                            CustomDiagramModelFactory modelFactory = (CustomDiagramModelFactory)dEditor.getModelFactory();
                            if (diagramNode != null && modelFactory != null) {
                                DiagramEditorUtil.setDiagramUnderConstruction(newDiagram);
                                List applicableDiagramObjects = CustomDiagramContentHelper.getApplicableDiagramEObjects(selectedEObjects);
                                modelFactory.add(applicableDiagramObjects, diagramNode);
                                int levels = this.getAssociationLevels();
                                this.addAssociatedObjects(dEditor, modelFactory, diagramNode, selectedEObjects, levels);
                                dEditor.autoLayout();
                            }
                        }
                        succeeded = true;
                    }
                    catch (ModelWorkspaceException e) {
                        String message = Util.getString("AddToNewCustomDiagramAction.createCustomDiagramError", (Object)selectedContainer.toString());
                        Util.log(4, (Throwable)e, message);
                        if (requiredStart) {
                            if (succeeded) {
                                ModelerCore.commitTxn();
                            } else {
                                ModelerCore.rollbackTxn();
                            }
                        }
                        if (diagramWasConstructed) {
                            DiagramEditorUtil.setDiagramConstructionComplete(newDiagram, true);
                            if (dEditor != null) {
                                dEditor.openContext(newDiagram, true);
                            }
                        }
                        break block22;
                    }
                    catch (Exception ex) {
                        block23: {
                            block24: {
                                try {
                                    DiagramUiConstants.Util.log(4, (Throwable)ex, String.valueOf(ex.getClass().getName()) + ":" + THIS_CLASS + ".doRun()");
                                    if (!requiredStart) break block23;
                                    if (!succeeded) break block24;
                                }
                                catch (Throwable throwable) {
                                    if (requiredStart) {
                                        if (succeeded) {
                                            ModelerCore.commitTxn();
                                        } else {
                                            ModelerCore.rollbackTxn();
                                        }
                                    }
                                    if (diagramWasConstructed) {
                                        DiagramEditorUtil.setDiagramConstructionComplete(newDiagram, true);
                                        if (dEditor != null) {
                                            dEditor.openContext(newDiagram, true);
                                        }
                                    }
                                    throw throwable;
                                }
                                ModelerCore.commitTxn();
                                break block23;
                            }
                            ModelerCore.rollbackTxn();
                        }
                        if (diagramWasConstructed) {
                            DiagramEditorUtil.setDiagramConstructionComplete(newDiagram, true);
                            if (dEditor != null) {
                                dEditor.openContext(newDiagram, true);
                            }
                        }
                        break block22;
                    }
                    if (!requiredStart) break block25;
                    if (!succeeded) break block26;
                    ModelerCore.commitTxn();
                    break block25;
                }
                ModelerCore.rollbackTxn();
            }
            if (diagramWasConstructed) {
                DiagramEditorUtil.setDiagramConstructionComplete(newDiagram, true);
                if (dEditor != null) {
                    dEditor.openContext(newDiagram, true);
                }
            }
        }
        this.determineEnablement();
    }

    private void determineEnablement() {
        boolean enable = false;
        if (!SelectionUtilities.getSelectedEObjects((ISelection)this.getSelection()).isEmpty()) {
            List allEObjs = SelectionUtilities.getSelectedEObjects((ISelection)this.getSelection());
            enable = true;
            Iterator iter = allEObjs.iterator();
            while (iter.hasNext() && enable) {
                if (!(iter.next() instanceof Diagram)) continue;
                enable = false;
            }
        }
        this.setEnabled(enable);
    }

    protected boolean preRun() {
        return true;
    }

    @Override
    protected boolean requiresEditorForRun() {
        return true;
    }

    private void verifyResouceOpen(Object targetContainer) {
        if (this.requiresEditorForRun()) {
            Object selectedObject = SelectionUtilities.getSelectedObject((ISelection)this.getSelection());
            ModelResource modelResource = null;
            if (targetContainer instanceof IResource && ModelUtilities.isModelFile((IResource)((IResource)targetContainer))) {
                try {
                    modelResource = ModelUtil.getModelResource((IFile)((IFile)targetContainer), (boolean)false);
                }
                catch (ModelWorkspaceException e) {
                    String message = Util.getString("AddToNewCustomDiagramAction.createCustomDiagramError", (Object)selectedObject.toString());
                    Util.log(4, (Throwable)e, message);
                }
            } else {
                modelResource = ModelUtilities.getModelResourceForModelObject((EObject)((EObject)targetContainer));
            }
            if (modelResource != null) {
                ModelEditorManager.activate((ModelResource)modelResource, (boolean)true);
            }
        }
    }

    private Diagram createDiagram(Object targetContainer) throws ModelWorkspaceException {
        Diagram result = null;
        if (targetContainer instanceof IResource && ModelUtilities.isModelFile((IResource)((IResource)targetContainer))) {
            ModelResource modelResource = ModelUtil.getModelResource((IFile)((IFile)targetContainer), (boolean)false);
            if (modelResource != null) {
                result = modelResource.getModelDiagrams().createNewDiagram(null, true);
                result.setType("customDiagramType");
            }
        } else {
            ModelResource modelResource = ModelUtilities.getModelResourceForModelObject((EObject)((EObject)targetContainer));
            if (modelResource != null) {
                result = modelResource.getModelDiagrams().createNewDiagram((EObject)targetContainer, true);
                result.setType("customDiagramType");
            }
        }
        return result;
    }

    public int getAssociationLevels() {
        int levels = 0;
        Shell shell = DiagramUiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
        AssociatedLevelsDialog dialog = new AssociatedLevelsDialog(shell, LEVELS_SELECTION_DIALOG_TITLE);
        if (dialog.open() == 0) {
            levels = dialog.getLevels();
        }
        return levels;
    }

    private Object getTargetForDiagram() {
        ModelWorkspaceViewerFilter filter = new ModelWorkspaceViewerFilter(true){

            public boolean select(Viewer viewer, Object parent, Object element) {
                boolean doSelect = super.select(viewer, parent, element);
                if (doSelect && element instanceof EObject && !DiagramUiUtilities.isStandardUmlPackage(element)) {
                    return false;
                }
                return doSelect && (element instanceof IContainer || element instanceof IResource);
            }
        };
        ISelectionStatusValidator validator = new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection.length == 1) {
                    if (selection[0] instanceof IResource) {
                        if (ModelUtilities.isModelFile((IResource)((IResource)selection[0])) && !ModelUtil.isXsdFile((IResource)((IResource)selection[0]))) {
                            ModelResource mr = null;
                            try {
                                mr = ModelUtil.getModelResource((IFile)((IFile)selection[0]), (boolean)false);
                            }
                            catch (ModelWorkspaceException err) {
                                String message = Util.getString("AddToNewCustomDiagramAction.findModelResourceError", (Object)selection[0].toString());
                                Util.log(4, (Throwable)err, message);
                            }
                            if (mr != null && mr.isReadOnly()) {
                                return new Status(4, "org.teiid.designer.diagram.ui", 0, READ_ONLY_MODEL_SELECTION_MESSAGE, null);
                            }
                            return new Status(0, "org.teiid.designer.diagram.ui", 0, AddToNewCustomDiagramAction.EMPTY_STRING, null);
                        }
                    } else if (selection[0] instanceof EObject && DiagramUiUtilities.isStandardUmlPackage(selection[0])) {
                        ModelResource mr = ModelUtilities.getModelResourceForModelObject((EObject)((EObject)selection[0]));
                        if (mr != null && mr.isReadOnly()) {
                            return new Status(4, "org.teiid.designer.diagram.ui", 0, READ_ONLY_OBJECT_SELECTION_MESSAGE, null);
                        }
                        return new Status(0, "org.teiid.designer.diagram.ui", 0, AddToNewCustomDiagramAction.EMPTY_STRING, null);
                    }
                }
                return new Status(4, "org.teiid.designer.diagram.ui", 0, INVALID_SELECTION_MESSAGE, null);
            }
        };
        Object[] targets = WidgetUtil.showWorkspaceObjectSelectionDialog((String)TARGET_SELECTION_DIALOG_TITLE, (String)TARGET_SELECTION_DIALOG_MESSAGE, (boolean)true, null, (ViewerFilter)filter, (ISelectionStatusValidator)validator, (ILabelProvider)new ModelExplorerLabelProvider(), (ITreeContentProvider)new ModelExplorerContentProvider());
        if (targets.length > 0) {
            return targets[0];
        }
        return null;
    }

    private void addAssociatedObjects(DiagramEditor editor, CustomDiagramModelFactory modelFactory, DiagramModelNode diagramNode, List startingList, int levels) {
        List currentContents = new ArrayList(startingList);
        int i = 0;
        while (i < levels) {
            List newObjects = this.getAssociatedObjectsNotInDiagram(editor, currentContents);
            if (newObjects.isEmpty()) break;
            modelFactory.add(newObjects, diagramNode);
            currentContents = DiagramEditorUtil.getCurrentDiagramNodeEObjects();
            ++i;
        }
    }

    private List getAssociatedObjectsNotInDiagram(DiagramEditor editor, List objectList) {
        ArrayList<EObject> newObjects = new ArrayList<EObject>();
        if (editor != null && editor.getCurrentModel() != null) {
            DiagramModelNode diagramNode = editor.getCurrentModel();
            List allAssociatedToAdd = UmlRelationshipHelper.getRelatedObjects(objectList);
            Iterator iter = allAssociatedToAdd.iterator();
            EObject nextEObj = null;
            while (iter.hasNext()) {
                nextEObj = (EObject)iter.next();
                if (editor.getCurrentModel() == null || DiagramUiUtilities.diagramContainsEObject(nextEObj, diagramNode)) continue;
                newObjects.add(nextEObj);
            }
        }
        if (newObjects.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return newObjects;
    }
}

