/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui.custom.actions;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchPart;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.diagram.ui.DiagramUiConstants;
import org.teiid.designer.diagram.ui.DiagramUiPlugin;
import org.teiid.designer.diagram.ui.actions.DiagramAction;
import org.teiid.designer.diagram.ui.custom.CustomDiagramModelFactory;
import org.teiid.designer.diagram.ui.editor.DiagramEditor;
import org.teiid.designer.diagram.ui.model.DiagramModelNode;
import org.teiid.designer.ui.viewsupport.ModelObjectUtilities;

public class ClearDiagramAction
extends DiagramAction {
    private static final String THIS_CLASS = "ClearDiagramAction";
    private DiagramEditor editor;

    public ClearDiagramAction() {
        this.setImageDescriptor(DiagramUiPlugin.getDefault().getImageDescriptor("icons/full/cview16/tb_clear_diagram.gif"));
    }

    public void selectionChanged(IWorkbenchPart thePart, ISelection theSelection) {
        super.selectionChanged(thePart, theSelection);
        this.setEnabled(this.shouldEnable());
    }

    @Override
    protected void doRun() {
        block11: {
            if (this.editor != null) {
                DiagramModelNode diagramNode = this.editor.getCurrentModel();
                CustomDiagramModelFactory modelFactory = (CustomDiagramModelFactory)this.editor.getModelFactory();
                if (diagramNode != null && modelFactory != null) {
                    boolean requiredStart = false;
                    boolean succeeded = false;
                    try {
                        try {
                            requiredStart = ModelerCore.startTxn((boolean)true, (boolean)false, (String)"Add To Custom Diagram", (Object)((Object)this));
                            modelFactory.clear(diagramNode);
                            succeeded = true;
                        }
                        catch (Exception ex) {
                            DiagramUiConstants.Util.log(4, (Throwable)ex, String.valueOf(ex.getClass().getName()) + ":" + THIS_CLASS + ".doRun()");
                            if (!requiredStart) break block11;
                            if (succeeded) {
                                ModelerCore.commitTxn();
                                break block11;
                            }
                            ModelerCore.rollbackTxn();
                        }
                    }
                    finally {
                        if (requiredStart) {
                            if (succeeded) {
                                ModelerCore.commitTxn();
                            } else {
                                ModelerCore.rollbackTxn();
                            }
                        }
                    }
                }
            }
        }
    }

    private boolean shouldEnable() {
        return this.diagramNotEmpty() && this.isWritable();
    }

    public void setDiagramEditor(DiagramEditor editor) {
        this.editor = editor;
    }

    private boolean diagramNotEmpty() {
        DiagramModelNode currentDiagram;
        return this.editor != null && (currentDiagram = this.editor.getCurrentModel()) != null && currentDiagram.getChildren() != null && !currentDiagram.getChildren().isEmpty() && currentDiagram.getChildren().size() > 0;
    }

    private boolean isWritable() {
        EObject diagram;
        DiagramModelNode currentDiagram;
        return this.editor != null && (currentDiagram = this.editor.getCurrentModel()) != null && !ModelObjectUtilities.isReadOnly((EObject)(diagram = currentDiagram.getModelObject()));
    }
}

