/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui.custom.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.teiid.designer.diagram.ui.DiagramUiPlugin;
import org.teiid.designer.diagram.ui.actions.DiagramGlobalActionsMap;
import org.teiid.designer.diagram.ui.actions.RefreshAction;
import org.teiid.designer.diagram.ui.actions.RouterTypeMenuManager;
import org.teiid.designer.diagram.ui.actions.SaveDiagramAction;
import org.teiid.designer.diagram.ui.connection.NodeConnectionEditPart;
import org.teiid.designer.diagram.ui.custom.actions.AddAssociatedObjectsAction;
import org.teiid.designer.diagram.ui.custom.actions.AddToDiagramAction;
import org.teiid.designer.diagram.ui.custom.actions.AddToNewCustomDiagramAction;
import org.teiid.designer.diagram.ui.custom.actions.ClearDiagramAction;
import org.teiid.designer.diagram.ui.custom.actions.CloneAction;
import org.teiid.designer.diagram.ui.custom.actions.CutAction;
import org.teiid.designer.diagram.ui.custom.actions.DeleteAction;
import org.teiid.designer.diagram.ui.custom.actions.ICustomDiagramActionConstants;
import org.teiid.designer.diagram.ui.custom.actions.PasteAction;
import org.teiid.designer.diagram.ui.custom.actions.RemoveFromDiagramAction;
import org.teiid.designer.diagram.ui.custom.actions.ShowParentDiagramAction;
import org.teiid.designer.diagram.ui.editor.DiagramActionAdapter;
import org.teiid.designer.diagram.ui.editor.DiagramEditor;
import org.teiid.designer.diagram.ui.editor.DiagramToolBarManager;
import org.teiid.designer.diagram.ui.model.DiagramModelNode;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.actions.IModelerActionConstants;
import org.teiid.designer.ui.actions.ModelerActionService;
import org.teiid.designer.ui.common.actions.AbstractAction;
import org.teiid.designer.ui.common.actions.GlobalActionsMap;
import org.teiid.designer.ui.common.actions.IActionConstants;
import org.teiid.designer.ui.editors.ModelEditorPage;

public class CustomDiagramActionAdapter
extends DiagramActionAdapter
implements ICustomDiagramActionConstants {
    private static final String D_MARKER = "diagramStart";
    private static final String D_MARKER_END = "diagramEnd";
    private AbstractAction addToNewCustomDiagramAction;
    private AddToDiagramAction addAction;
    private RemoveFromDiagramAction removeAction;
    private ClearDiagramAction clearAction;
    private AddAssociatedObjectsAction addAssociatedAction;
    private MenuManager linkTypeManager;
    private RefreshAction refreshDiagramAction;
    private ShowParentDiagramAction upPackageDiagramAction;
    private AbstractAction saveDiagramAction;
    private AbstractAction deleteAction;
    private AbstractAction cutAction;
    private AbstractAction pasteAction;
    private AbstractAction cloneAction;
    private GlobalActionsMap actionsMap;

    public CustomDiagramActionAdapter(ModelEditorPage page) {
        super(page);
    }

    private boolean singleLinkSelected() {
        Object selectedEP;
        List selectedEPs = this.getSelectedInDiagram();
        return !selectedEPs.isEmpty() && selectedEPs.size() == 1 && (selectedEP = selectedEPs.get(0)) instanceof NodeConnectionEditPart;
    }

    @Override
    public GlobalActionsMap getGlobalActions() {
        if (this.actionsMap == null) {
            this.actionsMap = new DiagramGlobalActionsMap();
            this.actionsMap.reset();
            this.actionsMap.put((Object)IActionConstants.EclipseGlobalActions.DELETE, (Object)this.deleteAction);
            this.actionsMap.put((Object)IActionConstants.EclipseGlobalActions.CUT, (Object)this.cutAction);
            this.actionsMap.put((Object)IActionConstants.EclipseGlobalActions.PASTE, (Object)this.pasteAction);
            this.actionsMap.put((Object)IModelerActionConstants.ModelerGlobalActions.CLONE, (Object)this.cloneAction);
        }
        this.updateLinkTypeMenu();
        return this.actionsMap;
    }

    private void updateLinkTypeMenu() {
        DiagramModelNode currentModel = this.getDiagramEditor().getCurrentModel();
        if (currentModel != null) {
            boolean readOnly = currentModel.isReadOnly();
            ((RouterTypeMenuManager)this.linkTypeManager).setEnabled(!readOnly);
        }
    }

    @Override
    protected void initActions() {
        super.initActions();
        this.refreshDiagramAction = (RefreshAction)this.getRegisteredAction(RefreshAction.class.getName());
        if (this.refreshDiagramAction == null) {
            this.refreshDiagramAction = new RefreshAction();
            this.registerAction(this.refreshDiagramAction);
        }
        this.upPackageDiagramAction = (ShowParentDiagramAction)this.getRegisteredAction(ShowParentDiagramAction.class.getName());
        if (this.upPackageDiagramAction == null) {
            this.upPackageDiagramAction = new ShowParentDiagramAction();
            this.registerAction(this.upPackageDiagramAction);
        }
        this.linkTypeManager = new RouterTypeMenuManager();
        this.addToNewCustomDiagramAction = (AbstractAction)this.getRegisteredAction(AddToNewCustomDiagramAction.class.getName());
        if (this.addToNewCustomDiagramAction == null) {
            this.addToNewCustomDiagramAction = new AddToNewCustomDiagramAction();
            this.registerAction(this.addToNewCustomDiagramAction);
        }
        this.addAction = (AddToDiagramAction)this.getRegisteredAction(AddToDiagramAction.class.getName());
        if (this.addAction == null) {
            this.addAction = new AddToDiagramAction();
            this.registerAction((AbstractAction)this.addAction);
        }
        this.removeAction = (RemoveFromDiagramAction)this.getRegisteredAction(RemoveFromDiagramAction.class.getName());
        if (this.removeAction == null) {
            this.removeAction = new RemoveFromDiagramAction();
            this.registerAction((AbstractAction)this.removeAction);
        }
        this.clearAction = (ClearDiagramAction)this.getRegisteredAction(ClearDiagramAction.class.getName());
        if (this.clearAction == null) {
            this.clearAction = new ClearDiagramAction();
            this.registerAction((AbstractAction)this.clearAction);
        }
        this.addAssociatedAction = (AddAssociatedObjectsAction)this.getRegisteredAction(AddAssociatedObjectsAction.class.getName());
        if (this.addAssociatedAction == null) {
            this.addAssociatedAction = new AddAssociatedObjectsAction();
            this.registerAction((AbstractAction)this.addAssociatedAction);
        }
        this.saveDiagramAction = (AbstractAction)this.getRegisteredAction(SaveDiagramAction.class.getName());
        if (this.saveDiagramAction == null) {
            this.saveDiagramAction = new SaveDiagramAction((DiagramEditor)this.getEditorPage());
            this.registerAction(this.saveDiagramAction);
        }
        this.deleteAction = (AbstractAction)this.getRegisteredAction(DeleteAction.class.getName());
        if (this.deleteAction == null) {
            this.deleteAction = new DeleteAction();
            this.registerAction(this.deleteAction);
        }
        this.cutAction = (AbstractAction)this.getRegisteredAction(CutAction.class.getName());
        if (this.cutAction == null) {
            this.cutAction = new CutAction();
            this.registerAction(this.cutAction);
        }
        this.pasteAction = (AbstractAction)this.getRegisteredAction(PasteAction.class.getName());
        if (this.pasteAction == null) {
            this.pasteAction = new PasteAction();
            this.registerAction(this.pasteAction);
        }
        this.cloneAction = (AbstractAction)this.getRegisteredAction(CloneAction.class.getName());
        if (this.cloneAction == null) {
            this.cloneAction = new CloneAction();
            this.registerAction(this.cloneAction);
        }
    }

    @Override
    public void createContextMenu() {
        this.createContextMenu("diagramEditorPage.contextMenu", this.getEditorPage().getControl());
    }

    private void clearAllActions(IMenuManager theMenuMgr) {
        IContributionItem[] allContributions = theMenuMgr.getItems();
        ArrayList<IContributionItem> removeItems = new ArrayList<IContributionItem>(allContributions.length);
        int i = 0;
        while (i < allContributions.length) {
            IContributionItem nextItem = allContributions[i];
            if (!(nextItem instanceof GroupMarker) && !(nextItem instanceof Separator)) {
                removeItems.add(nextItem);
            }
            ++i;
        }
        Iterator iter = removeItems.iterator();
        while (iter.hasNext()) {
            theMenuMgr.remove((IContributionItem)iter.next());
        }
    }

    @Override
    public void contributeToMenuManager(IMenuManager theMenuMgr, ISelection selection) {
        if (this.singleLinkSelected()) {
            this.clearAllActions(theMenuMgr);
            ((RouterTypeMenuManager)this.linkTypeManager).setSingleLinkEdit(true);
            ((RouterTypeMenuManager)this.linkTypeManager).setInitialSelection();
            this.addDiagramActions(theMenuMgr);
        } else {
            MenuManager menuMgr;
            if (theMenuMgr.find(D_MARKER) != null) {
                theMenuMgr.remove(D_MARKER);
            }
            if (theMenuMgr.find(this.addAssociatedAction.getId()) != null) {
                theMenuMgr.remove(this.addAssociatedAction.getId());
            }
            if (theMenuMgr.find(this.removeAction.getId()) != null) {
                theMenuMgr.remove(this.removeAction.getId());
            }
            if (theMenuMgr.find(this.clearAction.getId()) != null) {
                theMenuMgr.remove(this.clearAction.getId());
            }
            if (theMenuMgr.find(this.refreshDiagramAction.getId()) != null) {
                theMenuMgr.remove(this.refreshDiagramAction.getId());
            }
            if (theMenuMgr.find(this.upPackageDiagramAction.getId()) != null) {
                theMenuMgr.remove(this.upPackageDiagramAction.getId());
            }
            if (theMenuMgr.find(this.saveDiagramAction.getId()) != null) {
                theMenuMgr.remove(this.saveDiagramAction.getId());
            }
            if (theMenuMgr.find(D_MARKER_END) != null) {
                theMenuMgr.remove(D_MARKER_END);
            }
            if ((menuMgr = this.getModelingActionMenu(selection)).getItems().length > 0) {
                theMenuMgr.add((IContributionItem)menuMgr);
                theMenuMgr.add((IContributionItem)new Separator());
            }
            this.addDiagramActions(theMenuMgr);
        }
    }

    private void addDiagramActions(IMenuManager theMenuMgr) {
        theMenuMgr.add((IContributionItem)new GroupMarker(D_MARKER));
        theMenuMgr.appendToGroup(D_MARKER, (IAction)this.refreshDiagramAction);
        theMenuMgr.appendToGroup(D_MARKER, (IAction)this.upPackageDiagramAction);
        theMenuMgr.appendToGroup(D_MARKER, (IAction)this.addAssociatedAction);
        theMenuMgr.appendToGroup(D_MARKER, (IAction)this.removeAction);
        theMenuMgr.appendToGroup(D_MARKER, (IAction)this.clearAction);
        theMenuMgr.appendToGroup(D_MARKER, (IContributionItem)this.linkTypeManager);
        theMenuMgr.appendToGroup(D_MARKER, (IAction)this.saveDiagramAction);
        theMenuMgr.add((IContributionItem)new Separator());
    }

    @Override
    public void contributeExportedActions(IMenuManager theMenuMgr) {
        if (theMenuMgr.getId() != null && theMenuMgr.getId().equals("TempMenuID")) {
            theMenuMgr.add((IAction)this.addAction);
            theMenuMgr.add((IAction)this.clearAction);
        } else {
            theMenuMgr.add((IAction)this.addAction);
            theMenuMgr.add((IAction)this.clearAction);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    public void contributeToDiagramToolBar() {
        DiagramToolBarManager tbm = (DiagramToolBarManager)((DiagramEditor)this.getEditorPage()).getToolBarManager();
        tbm.removeAll();
        tbm.add((IAction)this.refreshDiagramAction);
        tbm.add((IAction)this.upPackageDiagramAction);
        tbm.add((IContributionItem)new Separator());
        tbm.add((IAction)this.addAction);
        tbm.add((IAction)this.removeAction);
        tbm.add((IAction)this.clearAction);
        tbm.add((IContributionItem)new Separator());
        tbm.add((IAction)this.saveDiagramAction);
        this.refreshDiagramAction.setDiagramEditor((DiagramEditor)this.getEditorPage());
        this.upPackageDiagramAction.setDiagramEditor((DiagramEditor)this.getEditorPage());
        this.clearAction.setDiagramEditor((DiagramEditor)this.getEditorPage());
        this.removeAction.setDiagramEditor((DiagramEditor)this.getEditorPage());
        this.addAssociatedAction.setDiagramEditor((DiagramEditor)this.getEditorPage());
        this.addAction.setDiagramEditor((DiagramEditor)this.getEditorPage());
        this.addAction.setToolBarManager(tbm);
        ActionContributionItem addItem = new ActionContributionItem((IAction)this.addAction);
        this.addAction.setItem(addItem);
        tbm.update(true);
    }

    private MenuManager getModelingActionMenu(ISelection theSelection) {
        IWorkbenchWindow window = DiagramUiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        ModelerActionService service = (ModelerActionService)UiPlugin.getDefault().getActionService(window.getActivePage());
        return service.getModelingActionMenu(theSelection);
    }

    @Override
    public boolean shouldOverrideMenu(ISelection selection) {
        boolean value = false;
        if (this.singleLinkSelected()) {
            return true;
        }
        if (!this.singleLinkSelected()) {
            value = true;
        }
        return value;
    }
}

