/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui.custom.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.ISelectionListener;
import org.teiid.designer.core.metamodel.aspect.MetamodelAspect;
import org.teiid.designer.core.metamodel.aspect.uml.UmlPackage;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.diagram.ui.DiagramUiPlugin;
import org.teiid.designer.diagram.ui.actions.DiagramAction;
import org.teiid.designer.diagram.ui.custom.actions.AddToNewCustomDiagramAction;
import org.teiid.designer.diagram.ui.custom.actions.NewCustomDiagramAction;
import org.teiid.designer.diagram.ui.custom.actions.NewCustomDiagramSiblingAction;
import org.teiid.designer.metamodels.diagram.Diagram;
import org.teiid.designer.ui.actions.IModelObjectActionContributor;
import org.teiid.designer.ui.actions.ModelerActionBarIdManager;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.viewsupport.ModelIdentifier;
import org.teiid.designer.ui.viewsupport.ModelObjectUtilities;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class CustomDiagramPermanentActionContributor
implements IModelObjectActionContributor {
    private DiagramAction createDiagramAction;
    private DiagramAction createDiagramSiblingAction;
    private DiagramAction addToNewCustomDiagramAction;

    public CustomDiagramPermanentActionContributor() {
        this.initActions();
    }

    public void contributeToContextMenu(IMenuManager theMenuMgr, ISelection theSelection) {
        Object selectedObject;
        if (SelectionUtilities.isSingleSelection((ISelection)theSelection) && this.supportsDiagrams(selectedObject = SelectionUtilities.getSelectedObject((ISelection)theSelection))) {
            if (selectedObject instanceof EObject) {
                EObject eObject = (EObject)selectedObject;
                if (this.isPackage(eObject)) {
                    this.addToChildMenu(theMenuMgr);
                }
                if (eObject instanceof Diagram || eObject.eContainer() != null && this.isPackage(eObject.eContainer())) {
                    this.addToSiblingMenu(theMenuMgr);
                } else if (eObject.eContainer() == null) {
                    this.addToSiblingMenu(theMenuMgr);
                }
            } else if (selectedObject instanceof IResource && ModelUtilities.isModelFile((IResource)((IResource)selectedObject)) && !ModelUtil.isXsdFile((IResource)((IResource)selectedObject)) && !ModelIdentifier.isRelationshipModel((IResource)((IResource)selectedObject))) {
                this.addToResourceChildMenu(theMenuMgr);
            }
        }
    }

    public List<IAction> getAdditionalModelingActions(ISelection theSelection) {
        ArrayList<IAction> addedActions = new ArrayList<IAction>();
        if (this.addToNewCustomDiagramAction.isEnabled()) {
            if (SelectionUtilities.isSingleSelection((ISelection)theSelection)) {
                Object selectedObject = SelectionUtilities.getSelectedObject((ISelection)theSelection);
                if (this.supportsDiagrams(selectedObject) && selectedObject instanceof EObject) {
                    addedActions.add((IAction)this.addToNewCustomDiagramAction);
                }
            } else if (!SelectionUtilities.getSelectedEObjects((ISelection)theSelection).isEmpty()) {
                addedActions.add((IAction)this.addToNewCustomDiagramAction);
            }
        }
        return addedActions;
    }

    private void initActions() {
        this.createDiagramAction = new NewCustomDiagramAction();
        DiagramUiPlugin.registerDiagramActionForSelection((ISelectionListener)this.createDiagramAction);
        this.createDiagramSiblingAction = new NewCustomDiagramSiblingAction();
        DiagramUiPlugin.registerDiagramActionForSelection((ISelectionListener)this.createDiagramSiblingAction);
        this.addToNewCustomDiagramAction = new AddToNewCustomDiagramAction();
        DiagramUiPlugin.registerDiagramActionForSelection((ISelectionListener)this.addToNewCustomDiagramAction);
    }

    private void addToChildMenu(IMenuManager theMenuMgr) {
        String menuPath = ModelerActionBarIdManager.getInsertChildMenuId();
        IMenuManager mm = theMenuMgr.findMenuUsingPath(menuPath);
        if (mm != null) {
            mm.add((IContributionItem)new Separator());
            mm.add((IAction)this.createDiagramAction);
        }
    }

    private void addToResourceChildMenu(IMenuManager theMenuMgr) {
        String menuPath = ModelerActionBarIdManager.getInsertChildMenuId();
        IMenuManager mm = theMenuMgr.findMenuUsingPath(menuPath);
        if (mm != null) {
            mm.add((IContributionItem)new Separator());
            mm.add((IAction)this.createDiagramAction);
        } else {
            theMenuMgr.add((IContributionItem)new Separator());
            theMenuMgr.add((IAction)this.createDiagramAction);
        }
    }

    private void addToSiblingMenu(IMenuManager theMenuMgr) {
        String menuPath = ModelerActionBarIdManager.getInsertSiblingMenuId();
        IMenuManager mm = theMenuMgr.findMenuUsingPath(menuPath);
        if (mm != null) {
            mm.add((IContributionItem)new Separator());
            mm.add((IAction)this.createDiagramSiblingAction);
        }
    }

    private boolean isPackage(EObject eObject) {
        MetamodelAspect aspect = ModelObjectUtilities.getUmlAspect((EObject)eObject);
        return aspect instanceof UmlPackage;
    }

    private boolean supportsDiagrams(Object input) {
        ModelResource mr = null;
        if (input instanceof EObject) {
            mr = ModelUtilities.getModelResourceForModelObject((EObject)((EObject)input));
        } else if (input instanceof IFile) {
            mr = ModelUtilities.getModelResourceForIFile((IFile)((IFile)input), (boolean)false);
        }
        if (mr == null) {
            return false;
        }
        if (input instanceof Diagram) {
            if (!ModelIdentifier.isRelationshipModel((ModelResource)mr)) {
                return ModelUtilities.supportsDiagrams((ModelResource)mr);
            }
            return false;
        }
        if (ModelIdentifier.isRelationshipModel((ModelResource)mr)) {
            return false;
        }
        return ModelUtilities.supportsDiagrams((Object)input);
    }
}

