/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionListener;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.diagram.ui.DiagramUiConstants;
import org.teiid.designer.diagram.ui.DiagramUiPlugin;
import org.teiid.designer.diagram.ui.actions.DiagramActionService;
import org.teiid.designer.diagram.ui.editor.DiagramEditor;
import org.teiid.designer.diagram.ui.editor.IDiagramActionAdapter;
import org.teiid.designer.ui.common.actions.AbstractAction;
import org.teiid.designer.ui.common.actions.ActionService;
import org.teiid.designer.ui.editors.AbstractModelEditorPageActionBarContributor;
import org.teiid.designer.ui.editors.ModelEditorPage;

public class DiagramActionAdapter
extends AbstractModelEditorPageActionBarContributor
implements IDiagramActionAdapter,
DiagramUiConstants {
    private static final String PREFIX = I18nUtil.getPropertyPrefix(DiagramActionAdapter.class);
    private List contributionItems;
    private HashMap allRegisteredActions = new HashMap();
    private IMenuManager editMenu;
    private boolean actionsInitialized = false;

    public DiagramActionAdapter(ModelEditorPage page) {
        super(page);
        this.contributionItems = new ArrayList();
        this.initActions();
    }

    protected void initActions() {
        this.actionsInitialized = true;
    }

    @Override
    public void setDiagramEditor(ModelEditorPage editor) {
        super.setActiveEditor((IEditorPart)editor);
        if (!this.actionsInitialized) {
            this.initActions();
        }
    }

    protected DiagramEditor getDiagramEditor() {
        if (super.getEditorPage() instanceof DiagramEditor) {
            return (DiagramEditor)super.getEditorPage();
        }
        return null;
    }

    protected List getSelectedInDiagram() {
        if (this.getDiagramEditor() != null) {
            return this.getDiagramEditor().getDiagramViewer().getSelectedEditParts();
        }
        return Collections.EMPTY_LIST;
    }

    protected void addContributionItem(IContributionItem newItem) {
        this.contributionItems.add(newItem);
    }

    protected List getContributionItems() {
        return this.contributionItems;
    }

    protected void removeContributionItem(IContributionItem oldItem) {
        this.contributionItems.remove(oldItem);
    }

    protected IAction getRegisteredAction(String theActionId) {
        String key;
        IAction result = null;
        ActionService actionService = this.getActionService();
        if (actionService.isRegistered(key = DiagramActionService.constructKey(theActionId, this.getEditorPage()))) {
            try {
                result = actionService.getAction(key);
            }
            catch (CoreException coreException) {
                Util.log(4, Util.getString(String.valueOf(PREFIX) + "actionProblem", new Object[]{theActionId}));
            }
        }
        return result;
    }

    protected void registerAction(AbstractAction theAction) {
        DiagramUiPlugin.registerDiagramActionForSelection((ISelectionListener)theAction);
        String actionKey = DiagramActionService.constructKey((IAction)theAction, this.getEditorPage());
        this.getActionService().registerAction(actionKey, (IAction)theAction);
        this.allRegisteredActions.put(theAction, actionKey);
    }

    protected void unregisterAction(AbstractAction theAction) {
        DiagramUiPlugin.unregisterDiagramActionForSelection((ISelectionListener)theAction);
        String actionKey = (String)this.allRegisteredActions.get(theAction);
        this.getActionService().removeAction(actionKey);
    }

    protected ActionContributionItem createActionContributionItem(IAction theAction) {
        ActionContributionItem item = new ActionContributionItem(theAction);
        item.setVisible(false);
        this.addContributionItem((IContributionItem)item);
        return item;
    }

    public ActionService getActionService() {
        ActionService actionService = null;
        if (this.getEditorPage() != null && this.getEditorPage().getSite() != null && this.getEditorPage().getEditorSite().getPage() != null) {
            actionService = DiagramUiPlugin.getDefault().getActionService(this.getEditorPage().getSite().getPage());
        }
        return actionService;
    }

    @Override
    public void pageActivated() {
        this.setActionsVisible(true);
    }

    @Override
    public void pageDeactivated() {
        this.setActionsVisible(false);
    }

    private void setActionsVisible(boolean theShowFlag) {
        int size = this.contributionItems.size();
        int i = 0;
        while (i < size) {
            IContributionItem item = (IContributionItem)this.contributionItems.get(i);
            item.setVisible(theShowFlag);
            ++i;
        }
        if (this.getActionBars() != null && this.getActionBars().getToolBarManager() != null) {
            this.getActionBars().getToolBarManager().update(true);
        }
    }

    protected void setEditMenu(IMenuManager theEditMenu) {
        this.editMenu = theEditMenu;
    }

    public void dispose() {
        ActionService service = this.getActionService();
        if (service != null) {
            for (AbstractAction theAction : this.allRegisteredActions.keySet()) {
                this.unregisterAction(theAction);
            }
            int size = this.contributionItems.size();
            int i = 0;
            while (i < size) {
                IContributionItem item = (IContributionItem)this.contributionItems.get(i);
                if (item instanceof ActionContributionItem) {
                    ActionContributionItem ai = (ActionContributionItem)item;
                    service.removeAction(DiagramActionService.constructKey(ai.getAction(), this.getEditorPage()));
                    if (ai.getAction() instanceof ISelectionListener) {
                        DiagramUiPlugin.unregisterDiagramActionForSelection((ISelectionListener)ai.getAction());
                    }
                }
                if (this.editMenu != null) {
                    this.editMenu.remove(item);
                }
                ++i;
            }
        }
        this.setEditorPage(null);
    }

    @Override
    public void disposeOfActions() {
        this.dispose();
    }

    @Override
    public void contributeToDiagramToolBar() {
    }

    @Override
    public void contributeToMenuManager(IMenuManager theMenuMgr, ISelection theSelection) {
    }

    @Override
    public void enableDiagramToolbarActions() {
    }

    @Override
    public void handleNotification(Notification theNotification) {
    }

    @Override
    public boolean shouldOverrideMenu(ISelection theSelection) {
        return false;
    }

    public void createContextMenu() {
    }
}

