/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui.editor;

import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.dnd.AbstractTransferDropTargetListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.Transfer;
import org.teiid.designer.diagram.ui.part.DropEditPart;
import org.teiid.designer.ui.util.EObjectTransfer;

public class DiagramDropTargetAdapter
extends AbstractTransferDropTargetListener {
    private EditPart currentEditPart = null;

    public DiagramDropTargetAdapter(EditPartViewer viewer) {
        super(viewer);
    }

    public Transfer getTransfer() {
        return EObjectTransfer.getInstance();
    }

    public boolean isEnabled(DropTargetEvent event) {
        return true;
    }

    private List getEventEObjects(DropTargetEvent event) {
        Transfer[] transfers = ((DropTarget)event.getSource()).getTransfer();
        int i = 0;
        while (i < transfers.length) {
            EObjectTransfer transfer;
            if (transfers[i] instanceof EObjectTransfer && (transfer = (EObjectTransfer)transfers[i]).getObject() != null) {
                return (List)transfer.getObject();
            }
            ++i;
        }
        return Collections.EMPTY_LIST;
    }

    public void drop(DropTargetEvent event) {
        event.detail = 1;
        this.updateTargetEditPart();
        List dropList = this.getEventEObjects(event);
        if (!dropList.isEmpty()) {
            ((DropEditPart)this.getTargetEditPart()).drop(this.getCurrentAbsolutePoint(), dropList);
        }
    }

    public void dragOver(DropTargetEvent event) {
        boolean allowsDrop = false;
        this.setCurrentEditPart();
        List dropList = this.getEventEObjects(event);
        if (this.currentEditPart != null && !dropList.isEmpty() && this.currentEditPart instanceof DropEditPart) {
            ((DropEditPart)this.currentEditPart).setLastHoverPoint(this.getCurrentAbsolutePoint());
            allowsDrop = ((DropEditPart)this.currentEditPart).allowsDrop(this.currentEditPart, dropList);
        }
        event.detail = !allowsDrop ? 0 : 1;
        super.dragOver(event);
    }

    protected void helper(DropTargetEvent theEvent) {
    }

    private Point getCurrentAbsolutePoint() {
        FigureCanvas canvas = (FigureCanvas)this.getViewer().getControl();
        Point newPoint = new Point(this.getDropLocation());
        newPoint.x += canvas.getViewport().getViewLocation().x;
        newPoint.y += canvas.getViewport().getViewLocation().y;
        return newPoint;
    }

    protected void updateTargetRequest() {
        this.updateTargetEditPart();
        this.getTargetRequest().setType((Object)"add children");
    }

    protected Request createTargetRequest() {
        Request req = new Request();
        req.setType((Object)"add children");
        return req;
    }

    private void setCurrentEditPart() {
        this.currentEditPart = this.getViewer().findObjectAtExcluding(this.getDropLocation(), this.getExclusionSet(), new EditPartViewer.Conditional(){

            public boolean evaluate(EditPart editpart) {
                return editpart.getTargetEditPart(DiagramDropTargetAdapter.this.proxyGetTargetRequest()) != null;
            }
        });
    }

    Request proxyGetTargetRequest() {
        return this.getTargetRequest();
    }
}

