/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui.editor;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.teiid.designer.diagram.ui.editor.DiagramController;
import org.teiid.designer.diagram.ui.editor.DiagramViewer;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;

public class DiagramEditorSelectionProvider
implements ISelectionProvider,
ISelectionChangedListener {
    ISelection currentSelection;
    ArrayList listenerList = new ArrayList();

    public DiagramEditorSelectionProvider(DiagramViewer viewer) {
        viewer.addSelectionChangedListener(this);
    }

    public void setDiagramController(DiagramController controller) {
        ISelectionProvider provider = controller.getSelectionSource();
        if (provider != null) {
            provider.addSelectionChangedListener((ISelectionChangedListener)this);
        }
    }

    public void removeDiagramController(DiagramController controller) {
        ISelectionProvider provider = controller.getSelectionSource();
        if (provider != null) {
            provider.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
    }

    public synchronized void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (!this.listenerList.contains(listener)) {
            this.listenerList.add(listener);
        }
    }

    public synchronized ISelection getSelection() {
        return this.currentSelection;
    }

    public synchronized void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listenerList.remove(listener);
    }

    public synchronized void setSelection(ISelection selection) {
        this.currentSelection = selection;
        this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)this, selection));
    }

    public synchronized void selectionChanged(SelectionChangedEvent event) {
        this.currentSelection = event.getSelection();
        this.fireSelectionChanged(event);
    }

    private void fireSelectionChanged(SelectionChangedEvent event) {
        SelectionChangedEvent theEvent = event;
        ISelection selection = event.getSelection();
        boolean invalidSelection = false;
        for (Object eobj : SelectionUtilities.getSelectedEObjects((ISelection)selection)) {
            if (((EObject)eobj).eResource() == null) {
                invalidSelection = true;
            }
            if (invalidSelection) break;
        }
        if (invalidSelection) {
            theEvent = new SelectionChangedEvent(event.getSelectionProvider(), (ISelection)new StructuredSelection());
        }
        Iterator iter = this.listenerList.iterator();
        while (iter.hasNext()) {
            ((ISelectionChangedListener)iter.next()).selectionChanged(theEvent);
        }
    }
}

